/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.brooklynnode;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Range;
import java.util.Map;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.HttpToolResponse;

public interface EntityHttpClient {
    public HttpTool.HttpClientBuilder getHttpClientForBrooklynNode();

    public EntityHttpClient responseSuccess(Predicate<Integer> var1);

    public HttpToolResponse get(String var1);

    public HttpToolResponse post(String var1, Map<String, String> var2, byte[] var3);

    public HttpToolResponse post(String var1, Map<String, String> var2, Map<String, String> var3);

    public HttpToolResponse delete(String var1, Map<String, String> var2);

    public static class ResponseCodePredicates {
        public static Predicate<Integer> informational() {
            return Range.closed((Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(199));
        }

        public static Predicate<Integer> success() {
            return new ResponseCodeHealthyPredicate();
        }

        public static Predicate<Integer> redirect() {
            return Range.closed((Comparable)Integer.valueOf(300), (Comparable)Integer.valueOf(399));
        }

        public static Predicate<Integer> clientError() {
            return Range.closed((Comparable)Integer.valueOf(400), (Comparable)Integer.valueOf(499));
        }

        public static Predicate<Integer> serverError() {
            return Range.closed((Comparable)Integer.valueOf(500), (Comparable)Integer.valueOf(599));
        }

        public static Predicate<Integer> invalid() {
            return Predicates.or((Predicate)Range.atMost((Comparable)Integer.valueOf(99)), (Predicate)Range.atLeast((Comparable)Integer.valueOf(600)));
        }

        private static class ResponseCodeHealthyPredicate
        implements Predicate<Integer> {
            private ResponseCodeHealthyPredicate() {
            }

            public boolean apply(Integer input) {
                return HttpTool.isStatusCodeHealthy((int)input);
            }
        }
    }
}

