/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.loadbalancing;

import com.google.common.base.Predicate;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.entity.group.AbstractGroup;
import org.apache.brooklyn.entity.group.DynamicGroupImpl;
import org.apache.brooklyn.policy.loadbalancing.BalanceableContainer;
import org.apache.brooklyn.policy.loadbalancing.ItemsInContainersGroup;
import org.apache.brooklyn.policy.loadbalancing.Movable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemsInContainersGroupImpl
extends DynamicGroupImpl
implements ItemsInContainersGroup {
    private static final Logger LOG = LoggerFactory.getLogger(ItemsInContainersGroup.class);
    private Group containerGroup;
    private final SensorEventListener<Object> eventHandler = new SensorEventListener<Object>(){

        public void onEvent(SensorEvent<Object> event) {
            Entity source = event.getSource();
            Object value = event.getValue();
            Sensor sensor = event.getSensor();
            if (sensor.equals(AbstractGroup.MEMBER_ADDED)) {
                ItemsInContainersGroupImpl.this.onContainerAdded((Entity)value);
            } else if (sensor.equals(AbstractGroup.MEMBER_REMOVED)) {
                ItemsInContainersGroupImpl.this.onContainerRemoved((Entity)value);
            } else if (sensor.equals(Movable.CONTAINER)) {
                ItemsInContainersGroupImpl.this.onItemMoved((Movable)source, (BalanceableContainer)value);
            } else {
                throw new IllegalStateException("Unhandled event type " + sensor + ": " + event);
            }
        }
    };

    public void init() {
        super.init();
        this.setEntityFilter((Predicate)new Predicate<Entity>(){

            public boolean apply(Entity e) {
                return ItemsInContainersGroupImpl.this.acceptsEntity(e);
            }
        });
    }

    protected Predicate<? super Entity> getItemFilter() {
        return (Predicate)this.getConfig(ITEM_FILTER);
    }

    protected boolean acceptsEntity(Entity e) {
        if (e instanceof Movable) {
            return this.acceptsItem((Movable)e, (BalanceableContainer)((Movable)e).getAttribute((AttributeSensor)Movable.CONTAINER));
        }
        return false;
    }

    boolean acceptsItem(Movable e, BalanceableContainer c) {
        return this.containerGroup != null && c != null ? this.getItemFilter().apply((Object)e) && this.containerGroup.hasMember((Entity)c) : false;
    }

    @Override
    public void setContainers(Group containerGroup) {
        this.containerGroup = containerGroup;
        this.subscriptions().subscribe((Entity)containerGroup, (Sensor)AbstractGroup.MEMBER_ADDED, this.eventHandler);
        this.subscriptions().subscribe((Entity)containerGroup, (Sensor)AbstractGroup.MEMBER_REMOVED, this.eventHandler);
        this.subscriptions().subscribe(null, Movable.CONTAINER, this.eventHandler);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} scanning entities on container group set", (Object)this);
        }
        this.rescanEntities();
    }

    private void onContainerAdded(Entity newContainer) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} rescanning entities on container {} added", (Object)this, (Object)newContainer);
        }
        this.rescanEntities();
    }

    private void onContainerRemoved(Entity oldContainer) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} rescanning entities on container {} removed", (Object)this, (Object)oldContainer);
        }
        this.rescanEntities();
    }

    protected void onEntityAdded(Entity item) {
        if (this.acceptsEntity(item)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} adding new item {}", (Object)this, (Object)item);
            }
            this.addMember(item);
        }
    }

    protected void onEntityRemoved(Entity item) {
        if (this.removeMember(item) && LOG.isDebugEnabled()) {
            LOG.debug("{} removing deleted item {}", (Object)this, (Object)item);
        }
    }

    private void onItemMoved(Movable item, BalanceableContainer container) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} processing moved item {}, to container {}", new Object[]{this, item, container});
        }
        if (this.hasMember(item)) {
            if (!this.acceptsItem(item, container)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} removing moved item {} from group, as new container {} is not a member", new Object[]{this, item, container});
                }
                this.removeMember(item);
            }
        } else if (this.acceptsItem(item, container)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} adding moved item {} to group, as new container {} is a member", new Object[]{this, item, container});
            }
            this.addMember(item);
        }
    }
}

