/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.BaseEncoding;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;
import org.jclouds.s3.domain.ObjectMetadata;

@Singleton
public class BindObjectMetadataToRequest
implements Binder {
    protected final BindMapToHeadersWithPrefix metadataPrefixer;

    @Inject
    public BindObjectMetadataToRequest(BindMapToHeadersWithPrefix metadataPrefixer) {
        this.metadataPrefixer = (BindMapToHeadersWithPrefix)Preconditions.checkNotNull((Object)metadataPrefixer, (Object)"metadataPrefixer");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        ObjectMetadata.StorageClass storageClass;
        String contentLanguage;
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof ObjectMetadata), (Object)"this binder is only valid for ObjectMetadata!");
        Preconditions.checkNotNull(request, (Object)"request");
        ObjectMetadata md = (ObjectMetadata)ObjectMetadata.class.cast(input);
        Preconditions.checkArgument((md.getKey() != null ? 1 : 0) != 0, (Object)"objectMetadata.getKey() must be set!");
        request = this.metadataPrefixer.bindToRequest(request, md.getUserMetadata());
        ImmutableMultimap.Builder headers = ImmutableMultimap.builder();
        if (md.getContentMetadata().getCacheControl() != null) {
            headers.put((Object)"Cache-Control", (Object)md.getContentMetadata().getCacheControl());
        }
        if (md.getContentMetadata().getContentDisposition() != null) {
            headers.put((Object)"Content-Disposition", (Object)md.getContentMetadata().getContentDisposition());
        }
        if (md.getContentMetadata().getContentEncoding() != null) {
            headers.put((Object)"Content-Encoding", (Object)md.getContentMetadata().getContentEncoding());
        }
        if ((contentLanguage = md.getContentMetadata().getContentLanguage()) != null) {
            headers.put((Object)"Content-Language", (Object)contentLanguage);
        }
        if (md.getContentMetadata().getContentType() != null) {
            headers.put((Object)"Content-Type", (Object)md.getContentMetadata().getContentType());
        } else {
            headers.put((Object)"Content-Type", (Object)"binary/octet-stream");
        }
        if (md.getContentMetadata().getContentMD5() != null) {
            headers.put((Object)"Content-MD5", (Object)BaseEncoding.base64().encode(md.getContentMetadata().getContentMD5()));
        }
        if ((storageClass = md.getStorageClass()) != ObjectMetadata.StorageClass.STANDARD) {
            headers.put((Object)"x-amz-storage-class", (Object)storageClass.toString());
        }
        return (R)((HttpRequest.Builder)request.toBuilder().replaceHeaders((Multimap)headers.build())).build();
    }
}

