/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.units;

import java.util.Objects;
import java.util.function.Function;
import org.apache.brooklyn.util.guava.Maybe;

public abstract class AbstractUnit {
    protected final long value;
    private static final String[] PREFIXES = new String[]{"", "K", "M", "G", "T"};

    protected AbstractUnit() {
        this(0L);
    }

    public AbstractUnit(long v) {
        this.value = v;
    }

    protected String[] prefixes() {
        return PREFIXES;
    }

    protected abstract String unit();

    protected abstract String binaryUnit();

    public String toString() {
        if (this.value == 0L) {
            return "0 " + this.unit();
        }
        return (String)this.toString(1000, s -> s + this.unit()).orMaybe(() -> this.binaryUnit() == null ? Maybe.absent() : this.toString(1024, s -> s + this.binaryUnit())).or(() -> this.value + " " + this.unit());
    }

    private Maybe<String> toString(int modulus, Function<String, String> unitFn) {
        if (this.value % (long)modulus == 0L) {
            long v = this.value;
            int unit = 0;
            while (v % (long)modulus == 0L && unit + 1 < PREFIXES.length) {
                v /= (long)modulus;
                ++unit;
            }
            return Maybe.of((Object)(v + " " + unitFn.apply(PREFIXES[unit])));
        }
        return Maybe.absent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractUnit other = (AbstractUnit)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public int compareTo(AbstractUnit o) {
        return Long.compare(this.value, o.value);
    }
}

