/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import org.jclouds.Fallback;
import org.jclouds.azure.storage.AzureStorageResponseException;

public final class AzureBlobFallbacks {
    private AzureBlobFallbacks() {
    }

    public static final class FalseIfContainerAlreadyExists
    implements Fallback<Boolean> {
        public Boolean createOrPropagate(Throwable t) throws Exception {
            AzureStorageResponseException responseException;
            if (Preconditions.checkNotNull((Object)t, (Object)"throwable") instanceof AzureStorageResponseException && "ContainerAlreadyExists".equals((responseException = (AzureStorageResponseException)((Object)AzureStorageResponseException.class.cast(t))).getError().getCode())) {
                return false;
            }
            throw Throwables.propagate((Throwable)t);
        }
    }
}

