/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.guava;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.brooklyn.util.guava.Functionals;

public class IfFunctions {
    public static <I, O> IfFunctionBuilder<I, O> newInstance(Class<I> testType, Class<O> returnType) {
        return new IfFunctionBuilder();
    }

    public static <I> IfFunctionBuilderApplyingFirst<I> ifPredicate(Predicate<? super I> test) {
        return new IfFunctionBuilderApplyingFirst(test);
    }

    public static <I> IfFunctionBuilderApplyingFirst<I> ifEquals(I test) {
        return IfFunctions.ifPredicate(Predicates.equalTo(test));
    }

    public static <I> IfFunctionBuilderApplyingFirst<I> ifNotEquals(I test) {
        return IfFunctions.ifPredicate(Predicates.not((Predicate)Predicates.equalTo(test)));
    }

    @Beta
    public static class IfFunctionBuilderApplyingFirst<I> {
        private Predicate<? super I> test;

        private IfFunctionBuilderApplyingFirst(Predicate<? super I> test) {
            this.test = test;
        }

        public <O> IfFunctionBuilder<I, O> value(O value) {
            return this.apply(new Functionals.ConstantFunction(value, value));
        }

        public <O> IfFunctionBuilder<I, O> get(Supplier<? extends O> supplier) {
            return this.apply(Functions.forSupplier(supplier));
        }

        public <O> IfFunctionBuilder<I, O> apply(Function<? super I, ? extends O> function) {
            IfFunctionBuilder result = new IfFunctionBuilder();
            result.tests.put(this.test, function);
            return result;
        }
    }

    @Beta
    public static class IfFunctionBuilderApplying<I, O> {
        private IfFunction<I, O> input;
        private Predicate<? super I> test;

        private IfFunctionBuilderApplying(IfFunction<I, O> input, Predicate<? super I> test) {
            this.input = input;
            this.test = test;
        }

        public IfFunctionBuilder<I, O> value(O value) {
            return this.apply(new Functionals.ConstantFunction(value, value));
        }

        public IfFunctionBuilder<I, O> get(Supplier<? extends O> supplier) {
            return this.apply(Functions.forSupplier(supplier));
        }

        public IfFunctionBuilder<I, O> apply(Function<? super I, ? extends O> function) {
            IfFunctionBuilder<I, O> result = new IfFunctionBuilder<I, O>(this.input);
            result.tests.put(this.test, function);
            return result;
        }
    }

    @Beta
    public static class IfFunctionBuilder<I, O>
    extends IfFunction<I, O> {
        protected IfFunctionBuilder() {
        }

        protected IfFunctionBuilder(IfFunction<I, O> input) {
            super(input);
        }

        public IfFunction<I, O> build() {
            return new IfFunction(this);
        }

        public IfFunctionBuilderApplying<I, O> ifPredicate(Predicate<I> test) {
            return new IfFunctionBuilderApplying(this, test);
        }

        public IfFunctionBuilderApplying<I, O> ifEquals(I test) {
            return this.ifPredicate(Predicates.equalTo(test));
        }

        public IfFunctionBuilderApplying<I, O> ifNotEquals(I test) {
            return this.ifPredicate(Predicates.not((Predicate)Predicates.equalTo(test)));
        }

        public IfFunctionBuilder<I, O> defaultValue(O defaultValue) {
            return this.defaultApply(new Functionals.ConstantFunction(defaultValue, defaultValue));
        }

        public IfFunctionBuilder<I, O> defaultGet(Supplier<? extends O> defaultSupplier) {
            return this.defaultApply(Functions.forSupplier(defaultSupplier));
        }

        public IfFunctionBuilder<I, O> defaultApply(Function<? super I, ? extends O> defaultFunction) {
            IfFunctionBuilder<I, O> result = new IfFunctionBuilder<I, O>(this);
            result.defaultFunction = defaultFunction;
            return result;
        }
    }

    @Beta
    public static class IfFunction<I, O>
    implements Function<I, O> {
        protected final Map<Predicate<? super I>, Function<? super I, ? extends O>> tests = new LinkedHashMap<Predicate<? super I>, Function<? super I, ? extends O>>();
        protected Function<? super I, ? extends O> defaultFunction = null;

        protected IfFunction(IfFunction<I, O> input) {
            this.tests.putAll(input.tests);
            this.defaultFunction = input.defaultFunction;
        }

        protected IfFunction() {
        }

        public O apply(I input) {
            for (Map.Entry<Predicate<I>, Function<I, O>> test : this.tests.entrySet()) {
                if (!test.getKey().apply(input)) continue;
                return (O)test.getValue().apply(input);
            }
            return (O)(this.defaultFunction == null ? null : this.defaultFunction.apply(input));
        }

        public String toString() {
            return "if[" + this.tests + "]" + (this.defaultFunction != null ? "-else[" + this.defaultFunction + "]" : "");
        }
    }
}

