/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.location.Zone;

public final class ZoneToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Supplier<URI>>> zoneToEndpoints;

    @Inject
    ZoneToEndpoint(@Zone Supplier<Map<String, Supplier<URI>>> zoneToEndpoints) {
        this.zoneToEndpoints = zoneToEndpoints;
    }

    public URI apply(Object from) {
        Map zoneToEndpoint = (Map)this.zoneToEndpoints.get();
        Preconditions.checkState((!zoneToEndpoint.isEmpty() ? 1 : 0) != 0, (Object)"no zone name to endpoint mappings configured!");
        Preconditions.checkArgument((boolean)zoneToEndpoint.containsKey(from), (String)"requested location %s, which is not a configured zone: %s", (Object)from, (Object)zoneToEndpoint);
        return (URI)((Supplier)zoneToEndpoint.get(from)).get();
    }
}

