/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.binders;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.jclouds.googlecomputeengine.options.DiskCreationOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;

public final class DiskCreationBinder
implements MapBinder {
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        DiskCreationOptions options = (DiskCreationOptions)postParams.get("options");
        StringWriter out = new StringWriter();
        JsonWriter json = new JsonWriter((Writer)out);
        json.setSerializeNulls(false);
        try {
            json.beginObject();
            json.name("name").value(postParams.get("name").toString());
            json.name("sizeGb").value((Number)options.sizeGb());
            json.name("type").value(options.type() != null ? options.type().toString() : null);
            json.name("sourceSnapshot").value(options.sourceSnapshot() != null ? options.sourceSnapshot().toString() : null);
            json.name("description").value(options.description());
            json.endObject();
            json.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        request.setPayload(((Object)out).toString());
        request.getPayload().getContentMetadata().setContentType("application/json");
        return request;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new UnsupportedOperationException();
    }
}

