/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.ha;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynVersion;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.catalog.internal.CatalogInitialization;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.core.typereg.BasicBrooklynTypeRegistry;
import org.apache.brooklyn.core.typereg.BasicManagedBundle;
import org.apache.brooklyn.core.typereg.BundleUpgradeParser;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.osgi.BundleMaker;
import org.apache.brooklyn.util.core.osgi.Osgis;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.stream.InputStreamSource;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.BrooklynVersionSyntax;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.text.VersionComparator;
import org.apache.commons.lang3.tuple.Pair;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class BrooklynBomOsgiArchiveInstaller {
    private static final Logger log = LoggerFactory.getLogger(BrooklynBomOsgiArchiveInstaller.class);
    public static final ConfigKey<String> PERSIST_MANAGED_BUNDLE_WHITELIST_REGEX = BrooklynServerConfig.PERSIST_MANAGED_BUNDLE_WHITELIST_REGEX;
    public static final ConfigKey<String> PERSIST_MANAGED_BUNDLE_BLACKLIST_REGEX = BrooklynServerConfig.PERSIST_MANAGED_BUNDLE_BLACKLIST_REGEX;
    private final OsgiManager osgiManager;
    private ManagedBundle suppliedKnownBundleMetadata;
    private InputStream zipIn;
    private boolean start = true;
    private boolean loadCatalogBom = true;
    private String format = null;
    private String bomText = null;
    private boolean force = false;
    private boolean deferredStart = false;
    private boolean validateTypes = true;
    private FileWithTempInfo<File> zipFile;
    private boolean isBringingExistingOsgiInstalledBundleUnderBrooklynManagement = false;
    private Manifest discoveredManifest;
    private VersionedName discoveredBomVersionedName;
    OsgiBundleInstallationResult result;
    private ManagedBundle inferredMetadata;
    private final boolean inputStreamSupplied;
    private volatile Predicate<ManagedBundle> blacklistBundlePersistencePredicate;

    public BrooklynBomOsgiArchiveInstaller(OsgiManager osgiManager, ManagedBundle knownBundleMetadata, InputStream zipIn) {
        this.osgiManager = osgiManager;
        this.suppliedKnownBundleMetadata = knownBundleMetadata;
        this.zipIn = zipIn;
        this.inputStreamSupplied = zipIn != null;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public void setLoadCatalogBom(boolean loadCatalogBom) {
        this.loadCatalogBom = loadCatalogBom;
    }

    public void setCatalogBomText(String format, String bomText) {
        this.format = format;
        this.bomText = bomText;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setDeferredStart(boolean deferredStart) {
        this.deferredStart = deferredStart;
    }

    public void setValidateTypes(boolean validateTypes) {
        this.validateTypes = validateTypes;
    }

    private ManagementContextInternal mgmt() {
        return (ManagementContextInternal)this.osgiManager.getManagementContext();
    }

    private synchronized void init() {
        if (this.result != null) {
            if (this.zipFile != null || this.zipIn == null) {
                return;
            }
            throw new IllegalStateException("This installer instance has already been used and the input stream discarded");
        }
        this.result = new OsgiBundleInstallationResult();
        this.inferredMetadata = this.suppliedKnownBundleMetadata == null ? new BasicManagedBundle() : this.suppliedKnownBundleMetadata;
    }

    private synchronized void makeLocalZipFileFromInputStreamOrUrl() {
        PrepareInstallResult pr = BrooklynBomOsgiArchiveInstaller.prepareInstall(this.mgmt(), this.suppliedKnownBundleMetadata, this.inferredMetadata, () -> this.zipIn, this.force, this.result);
        if (pr.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement) {
            this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement = true;
        }
        if (pr.existingBundle != null) {
            this.result.bundle = pr.existingBundle;
        }
        if (pr.zipFile != null) {
            this.zipFile = pr.zipFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrepareInstallResult prepareInstall(ManagementContext mgmt, ManagedBundle suppliedKnownBundleMetadata, ManagedBundle optionalAdditionalInferredMetadata, Supplier<InputStream> zipInS, boolean force, @Nullable OsgiBundleInstallationResult resultObject) {
        PrepareInstallResult prepareInstallResult;
        block55: {
            InputStream zipIn = zipInS == null ? null : zipInS.get();
            prepareInstallResult = new PrepareInstallResult();
            prepareInstallResult.resultObject = resultObject;
            try {
                Maybe<Bundle> existingOsgiInstalledBundle = Maybe.absent();
                Maybe existingBrooklynInstalledBundle = Maybe.absent();
                OsgiManager osgiManager = (OsgiManager)((ManagementContextInternal)mgmt).getOsgiManager().get();
                if (suppliedKnownBundleMetadata != null) {
                    Maybe<VersionedName> forcedReplacementBundle;
                    com.google.common.base.Optional<VersionedName> inferredName;
                    if (optionalAdditionalInferredMetadata == null) {
                        optionalAdditionalInferredMetadata = suppliedKnownBundleMetadata;
                    }
                    if (suppliedKnownBundleMetadata.isNameResolved()) {
                        Maybe<VersionedName> forcedReplacementBundle2 = BundleUpgradeParser.CatalogUpgrades.tryGetBundleForcedReplaced(mgmt, suppliedKnownBundleMetadata.getVersionedName());
                        if (forcedReplacementBundle2.isPresent()) {
                            if (prepareInstallResult.resultObject == null) {
                                prepareInstallResult.resultObject = new OsgiBundleInstallationResult();
                            }
                            BrooklynBomOsgiArchiveInstaller.setResultForciblyRemovedResult(osgiManager, suppliedKnownBundleMetadata.getVersionedName(), optionalAdditionalInferredMetadata, forcedReplacementBundle2, prepareInstallResult.resultObject);
                            PrepareInstallResult prepareInstallResult2 = prepareInstallResult;
                            return prepareInstallResult2;
                        }
                    } else if (suppliedKnownBundleMetadata.getUrl() != null && suppliedKnownBundleMetadata.getUrl().toLowerCase().startsWith("mvn:") && (inferredName = BrooklynBomOsgiArchiveInstaller.inferBundleNameFromMvnUrl(suppliedKnownBundleMetadata.getUrl())).isPresent() && (forcedReplacementBundle = BundleUpgradeParser.CatalogUpgrades.tryGetBundleForcedReplaced(mgmt, (VersionedName)inferredName.get())).isPresent()) {
                        if (prepareInstallResult.resultObject == null) {
                            prepareInstallResult.resultObject = new OsgiBundleInstallationResult();
                        }
                        BrooklynBomOsgiArchiveInstaller.setResultForciblyRemovedResult(osgiManager, (VersionedName)inferredName.get(), optionalAdditionalInferredMetadata, forcedReplacementBundle, prepareInstallResult.resultObject);
                        PrepareInstallResult prepareInstallResult3 = prepareInstallResult;
                        return prepareInstallResult3;
                    }
                    if (zipIn == null) {
                        if (!suppliedKnownBundleMetadata.isNameResolved() && (existingBrooklynInstalledBundle = Maybe.ofDisallowingNull((Object)osgiManager.getManagedBundleFromUrl(suppliedKnownBundleMetadata.getUrl()))).isPresent()) {
                            ((BasicManagedBundle)suppliedKnownBundleMetadata).setSymbolicName(((ManagedBundle)existingBrooklynInstalledBundle.get()).getSymbolicName());
                            ((BasicManagedBundle)suppliedKnownBundleMetadata).setVersion(((ManagedBundle)existingBrooklynInstalledBundle.get()).getSuppliedVersionString());
                        }
                        if (existingOsgiInstalledBundle.isAbsent() && suppliedKnownBundleMetadata.getOsgiUniqueUrl() != null) {
                            existingOsgiInstalledBundle = Osgis.bundleFinder(osgiManager.getFramework()).requiringFromUrl(suppliedKnownBundleMetadata.getOsgiUniqueUrl()).find();
                        }
                        if (existingOsgiInstalledBundle.isAbsent() && suppliedKnownBundleMetadata.getUrl() != null) {
                            existingOsgiInstalledBundle = Osgis.bundleFinder(osgiManager.getFramework()).requiringFromUrl(suppliedKnownBundleMetadata.getUrl()).find();
                        }
                        if (existingOsgiInstalledBundle.isAbsent() && suppliedKnownBundleMetadata.isNameResolved()) {
                            existingOsgiInstalledBundle = Osgis.bundleFinder(osgiManager.getFramework()).symbolicName(suppliedKnownBundleMetadata.getSymbolicName()).version(suppliedKnownBundleMetadata.getSuppliedVersionString()).find();
                        }
                        if (existingOsgiInstalledBundle.isPresent()) {
                            if (existingBrooklynInstalledBundle.isAbsent()) {
                                existingBrooklynInstalledBundle = Maybe.ofDisallowingNull((Object)osgiManager.getManagedBundle(new VersionedName((Bundle)existingOsgiInstalledBundle.get())));
                            }
                            if (suppliedKnownBundleMetadata.getUrl() == null) {
                                if (existingBrooklynInstalledBundle.isPresent()) {
                                    log.debug("Detected bundle " + suppliedKnownBundleMetadata + " installed to Brooklyn already; no URL or stream supplied, so re-using existing installation");
                                    if (prepareInstallResult.resultObject == null) {
                                        prepareInstallResult.resultObject = new OsgiBundleInstallationResult();
                                    }
                                    prepareInstallResult.resultObject.metadata = (ManagedBundle)existingBrooklynInstalledBundle.get();
                                    prepareInstallResult.resultObject.setIgnoringAlreadyInstalled();
                                } else {
                                    String candidateUrl = ((Bundle)existingOsgiInstalledBundle.get()).getLocation();
                                    log.debug("Detected bundle " + suppliedKnownBundleMetadata + " installed to OSGi but not Brooklyn; trying to find a URL to get bundle binary, candidate " + candidateUrl);
                                    if (Strings.isBlank((CharSequence)candidateUrl)) {
                                        throw new IllegalArgumentException("No input stream available and no URL could be found: no way to promote " + suppliedKnownBundleMetadata + " from " + existingOsgiInstalledBundle.get() + " to Brooklyn management");
                                    }
                                    try {
                                        zipIn = ResourceUtils.create(mgmt).getResourceFromUrl(candidateUrl);
                                        prepareInstallResult.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement = true;
                                    }
                                    catch (Exception e) {
                                        Exceptions.propagateIfFatal((Throwable)e);
                                        throw new IllegalArgumentException("Could not find binary for already installed OSGi bundle " + existingOsgiInstalledBundle.get() + " (location " + candidateUrl + ") when trying to promote " + suppliedKnownBundleMetadata + " to Brooklyn management", e);
                                    }
                                }
                            }
                        } else if (suppliedKnownBundleMetadata.getUrl() == null) {
                            throw new IllegalArgumentException("No input stream available and no URL could be found: no way to install " + suppliedKnownBundleMetadata);
                        }
                        if (zipIn == null) {
                            if (existingBrooklynInstalledBundle.isAbsent() || force) {
                                String url = suppliedKnownBundleMetadata.getUrl();
                                if (url == null) {
                                    throw new IllegalStateException("should have found a stream or inferred a URL or already installed");
                                }
                                if (BrooklynVersion.isDevelopmentEnvironment() && url.startsWith("system:file:")) {
                                    try {
                                        url = Strings.removeFromStart((String)url, (String)"system:");
                                        File zipTemp = new BundleMaker(ResourceUtils.create(mgmt)).createJarFromClasspathDir(url);
                                        zipIn = new FileInputStream(zipTemp);
                                    }
                                    catch (FileNotFoundException e) {
                                        throw Exceptions.propagate((Throwable)e);
                                    }
                                } else {
                                    zipIn = ResourceUtils.create(mgmt).getResourceFromUrl(url, suppliedKnownBundleMetadata.getUrlCredential());
                                }
                            } else {
                                if (prepareInstallResult.resultObject == null) {
                                    prepareInstallResult.resultObject = new OsgiBundleInstallationResult();
                                }
                                prepareInstallResult.resultObject.metadata = (ManagedBundle)existingBrooklynInstalledBundle.get();
                                prepareInstallResult.resultObject.setIgnoringAlreadyInstalled();
                            }
                        }
                    }
                }
                prepareInstallResult.existingBundle = (Bundle)existingOsgiInstalledBundle.orNull();
                if (zipIn == null) break block55;
                if (zipInS instanceof InputStreamSource.InputStreamSourceFromFile) {
                    prepareInstallResult.zipFile = new FileWithTempInfo<File>(((InputStreamSource.InputStreamSourceFromFile)zipInS).getFile(), false);
                    break block55;
                }
                prepareInstallResult.zipFile = new FileWithTempInfo<File>(Os.newTempFile((String)("brooklyn-bundle-transient-" + suppliedKnownBundleMetadata), (String)"zip"), true);
                try {
                    FileOutputStream fos = new FileOutputStream(prepareInstallResult.zipFile.getFile());
                    Streams.copyClose((InputStream)zipIn, (OutputStream)fos);
                    try (ZipFile zf = new ZipFile(prepareInstallResult.zipFile.getFile());){
                        zf.entries();
                    }
                }
                catch (Exception e) {
                    try {
                        prepareInstallResult.zipFile.deleteIfTemp();
                    }
                    catch (Exception e2) {
                        Exceptions.propagateIfFatal((Throwable)e2);
                        log.warn("Error deleting ZIP file but ignoring because handling error " + e + ": " + e2);
                    }
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            finally {
                Streams.closeQuietly((Closeable)zipIn);
                zipIn = null;
            }
        }
        return prepareInstallResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverManifestFromCatalogBom(boolean isCatalogBomRequired) {
        ZipEntry bom;
        ZipFile zf;
        block9: {
            block10: {
                this.discoveredManifest = new BundleMaker(this.mgmt()).getManifest(this.zipFile.getFile());
                if (Strings.isNonBlank((CharSequence)this.bomText)) {
                    this.discoveredBomVersionedName = BasicBrooklynCatalog.getVersionedName(BasicBrooklynCatalog.getCatalogMetadata(this.bomText), false);
                    return;
                }
                zf = null;
                try {
                    try {
                        zf = new ZipFile(this.zipFile.getFile());
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Invalid ZIP/JAR archive: " + e);
                    }
                    bom = zf.getEntry("catalog.bom");
                    if (bom == null) {
                        bom = zf.getEntry("/catalog.bom");
                    }
                    if (bom != null) break block9;
                    if (!isCatalogBomRequired) break block10;
                    throw new IllegalArgumentException("Archive must contain a catalog.bom file in the root");
                }
                catch (Throwable throwable) {
                    Streams.closeQuietly(zf);
                    throw throwable;
                }
            }
            Streams.closeQuietly((Closeable)zf);
            return;
        }
        try {
            this.bomText = Streams.readFullyString((InputStream)zf.getInputStream(bom));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading catalog.bom from ZIP/JAR archive: " + e);
        }
        this.discoveredBomVersionedName = BasicBrooklynCatalog.getVersionedName(BasicBrooklynCatalog.getCatalogMetadata(this.bomText), false);
        Streams.closeQuietly((Closeable)zf);
    }

    private void updateManifestFromAllSourceInformation() {
        if (this.discoveredBomVersionedName != null) {
            this.matchSetOrFail("catalog.bom in archive", this.discoveredBomVersionedName.getSymbolicName(), this.discoveredBomVersionedName.getVersionString());
        }
        boolean manifestNeedsUpdating = false;
        if (this.discoveredManifest == null) {
            this.discoveredManifest = new Manifest();
            manifestNeedsUpdating = true;
        }
        if (!this.matchSetOrFail("MANIFEST.MF in archive", this.discoveredManifest.getMainAttributes().getValue("Bundle-SymbolicName"), this.discoveredManifest.getMainAttributes().getValue("Bundle-Version"))) {
            manifestNeedsUpdating = true;
            this.discoveredManifest.getMainAttributes().putValue("Bundle-SymbolicName", this.inferredMetadata.getSymbolicName());
            this.discoveredManifest.getMainAttributes().putValue("Bundle-Version", this.inferredMetadata.getOsgiVersionString());
        }
        if (Strings.isBlank((CharSequence)this.inferredMetadata.getSymbolicName())) {
            throw new IllegalArgumentException("Missing bundle symbolic name in BOM or MANIFEST");
        }
        if (Strings.isBlank((CharSequence)this.inferredMetadata.getSuppliedVersionString())) {
            throw new IllegalArgumentException("Missing bundle version in BOM or MANIFEST");
        }
        if (this.discoveredManifest.getMainAttributes().getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            this.discoveredManifest.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            manifestNeedsUpdating = true;
        }
        if (this.discoveredManifest.getMainAttributes().getValue("Bundle-ManifestVersion") == null || ("" + this.discoveredManifest.getMainAttributes().getValue("Bundle-ManifestVersion")).startsWith("1")) {
            this.discoveredManifest.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
            manifestNeedsUpdating = true;
        }
        if (manifestNeedsUpdating) {
            File zf2 = new BundleMaker(this.mgmt()).copyAddingManifest(this.zipFile.getFile(), this.discoveredManifest);
            this.zipFile.deleteIfTemp();
            this.zipFile = new FileWithTempInfo<File>(zf2, this.zipFile.isTemp);
        }
    }

    private synchronized void close() {
        if (this.zipFile != null) {
            this.zipFile.deleteIfTemp();
            this.zipFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceWithError<OsgiBundleInstallationResult> install() {
        boolean startedInstallation = false;
        try {
            ManagedBundle oldManagedBundle;
            File oldZipFile;
            List<Bundle> existingBundles;
            boolean updating;
            this.init();
            this.makeLocalZipFileFromInputStreamOrUrl();
            if (this.result.code != null) {
                ReferenceWithError referenceWithError = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                return referenceWithError;
            }
            this.discoverManifestFromCatalogBom(false);
            if (this.result.code != null) {
                ReferenceWithError referenceWithError = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                return referenceWithError;
            }
            this.updateManifestFromAllSourceInformation();
            if (this.result.code != null) {
                ReferenceWithError referenceWithError = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                return referenceWithError;
            }
            assert (this.inferredMetadata.isNameResolved()) : "Should have resolved " + this.inferredMetadata;
            assert (this.inferredMetadata instanceof BasicManagedBundle) : "Only BasicManagedBundles supported";
            ((BasicManagedBundle)this.inferredMetadata).setChecksum(BrooklynBomOsgiArchiveInstaller.getChecksum(new ZipFile(this.zipFile.getFile())));
            ((BasicManagedBundle)this.inferredMetadata).setFormat(this.format);
            this.result.metadata = this.osgiManager.getManagedBundle(this.inferredMetadata.getVersionedName());
            if (this.result.getMetadata() != null) {
                String knownIdForThisUrl;
                if (this.suppliedKnownBundleMetadata != null && this.suppliedKnownBundleMetadata.getUrl() != null) {
                    knownIdForThisUrl = this.osgiManager.managedBundlesRecord.getManagedBundleIdFromUrl(this.suppliedKnownBundleMetadata.getUrl());
                    if (knownIdForThisUrl == null) {
                        log.warn("Request to install from " + this.suppliedKnownBundleMetadata.getUrl() + " which is not recognized but appears to match " + this.result.getMetadata() + "; now associating with the latter");
                        this.osgiManager.managedBundlesRecord.setManagedBundleUrl(this.suppliedKnownBundleMetadata.getUrl(), this.result.getMetadata().getId());
                    } else if (!knownIdForThisUrl.equals(this.result.getMetadata().getId())) {
                        log.warn("Request to install from " + this.suppliedKnownBundleMetadata.getUrl() + " which is associated to " + knownIdForThisUrl + " but appears to match " + this.result.getMetadata() + "; now associating with the latter");
                        this.osgiManager.managedBundlesRecord.setManagedBundleUrl(this.suppliedKnownBundleMetadata.getUrl(), this.result.getMetadata().getId());
                    }
                }
                log.debug("Request to install " + this.inferredMetadata.getVersionedName() + " (checksum " + this.inferredMetadata.getChecksum() + ", OSGi URL " + this.inferredMetadata.getOsgiUniqueUrl() + ") in the presence of " + this.result.getMetadata().getVersionedName() + " (checksum " + this.result.getMetadata().getChecksum() + ", OSGi URL " + this.result.getMetadata().getOsgiUniqueUrl() + ")");
                this.result.bundle = this.osgiManager.getFramework().getBundleContext().getBundle(this.result.getMetadata().getOsgiUniqueUrl());
                if (this.result.bundle != null && BrooklynBomOsgiArchiveInstaller.checksumsMatch(this.result.getMetadata(), this.inferredMetadata)) {
                    log.trace("Bundle " + this.inferredMetadata + " matches already installed managed bundle " + this.result.getMetadata() + "; install is no-op");
                    this.result.setIgnoringAlreadyInstalled();
                    knownIdForThisUrl = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                    return knownIdForThisUrl;
                }
                List<Bundle> matchingVsnBundles = BrooklynBomOsgiArchiveInstaller.findBundlesBySymbolicNameAndVersion(this.osgiManager, this.inferredMetadata);
                List sameContentBundles = matchingVsnBundles.stream().filter(b -> BrooklynBomOsgiArchiveInstaller.isBundleSameOsgiUrlOrSameContents(b, this.inferredMetadata, this.zipFile.getFile())).collect(Collectors.toList());
                if (!sameContentBundles.isEmpty()) {
                    log.trace("Bundle " + this.inferredMetadata + " matches metadata of managed bundle " + this.result.getMetadata() + " (but not OSGi bundle location " + this.result.getMetadata().getOsgiUniqueUrl() + "), and identified as equivalent to installed OSGi bundle; ; install is no-op");
                    this.result.setIgnoringAlreadyInstalled();
                    this.result.bundle = (Bundle)sameContentBundles.iterator().next();
                    ReferenceWithError referenceWithError = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                    return referenceWithError;
                }
                if (this.canUpdate()) {
                    if (this.result.bundle == null && !matchingVsnBundles.isEmpty()) {
                        log.info("Updating existing brooklyn-managed bundle " + this.result + " with " + this.inferredMetadata + " with different OSGi location and different contents");
                        this.result.bundle = matchingVsnBundles.iterator().next();
                    }
                    if (this.result.getBundle() == null) {
                        log.warn("Brooklyn thought it was already managing bundle " + this.result.getMetadata().getVersionedName() + " but it's not installed to framework at location " + this.result.getMetadata().getOsgiUniqueUrl() + "; reinstalling it");
                        updating = false;
                    } else {
                        log.trace("Updating existing brooklyn-managed bundle " + this.result);
                        updating = true;
                    }
                } else {
                    if (matchingVsnBundles.size() > 0 && (this.result.getMetadata().getChecksum() == null || this.inferredMetadata.getChecksum() == null)) {
                        log.info("Missing bundle checksum data for " + this.result + "; assuming bundle matches existing brooklyn-managed bundle (not re-installing)");
                        this.result.setIgnoringAlreadyInstalled();
                        ReferenceWithError referenceWithError = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                        return referenceWithError;
                    }
                    if (this.result.bundle != null || matchingVsnBundles.size() > 0) {
                        throw new IllegalArgumentException("Bundle " + this.result.getMetadata().getVersionedName() + " already installed; cannot install a different bundle with the same non-snapshot version");
                    }
                    throw new IllegalArgumentException("Bundle " + this.result.getMetadata().getVersionedName() + " already a brooklyn-managed bundle, but not found in OSGi framework; will not re-install without use of 'force'");
                }
                this.result.metadata = BasicManagedBundle.copyFirstWithCoordsOfSecond(this.inferredMetadata, this.result.metadata);
            } else {
                Maybe<VersionedName> forcedReplacementBundle = BundleUpgradeParser.CatalogUpgrades.tryGetBundleForcedReplaced(this.mgmt(), this.inferredMetadata.getVersionedName());
                if (forcedReplacementBundle.isPresent()) {
                    BrooklynBomOsgiArchiveInstaller.setResultForciblyRemovedResult(this.osgiManager, this.inferredMetadata.getVersionedName(), this.inferredMetadata, forcedReplacementBundle, this.result);
                    ReferenceWithError sameContentBundles = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                    return sameContentBundles;
                }
                this.result.metadata = this.inferredMetadata;
                existingBundles = BrooklynBomOsgiArchiveInstaller.findBundlesBySymbolicNameAndVersion(this.osgiManager, this.inferredMetadata);
                Maybe<Bundle> existingEquivalentBundle = BrooklynBomOsgiArchiveInstaller.tryFindSameOsgiUrlOrSameContentsBundle(existingBundles, this.inferredMetadata, this.zipFile.getFile());
                if (existingEquivalentBundle.isPresent()) {
                    this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement = true;
                    this.result.bundle = (Bundle)existingEquivalentBundle.get();
                } else if (existingBundles.size() > 0) {
                    Bundle existingBundle = existingBundles.get(0);
                    if (this.force && this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement) {
                        log.debug("Request to install " + this.inferredMetadata + " was forced, so forcing reinstallation of existing OSGi installed (but not Brooklyn-managed) bundle " + existingBundle);
                        this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement = false;
                    }
                    if (this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement) {
                        this.result.bundle = existingBundle;
                    } else {
                        log.debug("Brooklyn install of " + this.result.getMetadata().getVersionedName() + " detected already loaded in OSGi; uninstalling that to reinstall as Brooklyn-managed");
                        existingBundle.uninstall();
                        this.result.bundle = null;
                    }
                }
                updating = false;
            }
            startedInstallation = true;
            FileInputStream fin = new FileInputStream(this.zipFile.getFile());
            existingBundles = null;
            try {
                if (!updating) {
                    if (this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement) {
                        assert (this.result.getBundle() != null);
                        log.debug("Brooklyn install of " + this.result.getMetadata().getVersionedName() + " detected already loaded " + this.result.getBundle() + " in OSGi can be re-used, skipping OSGi install");
                    } else {
                        assert (this.result.getBundle() == null);
                        log.debug("Installing bundle " + this.result.getMetadata().getVersionedName() + ", using OSGi location " + this.result.getMetadata().getOsgiUniqueUrl());
                        this.result.bundle = this.osgiManager.getFramework().getBundleContext().installBundle(this.result.getMetadata().getOsgiUniqueUrl(), (InputStream)fin);
                    }
                } else {
                    this.result.bundle.update((InputStream)fin);
                }
            }
            catch (Throwable existingEquivalentBundle) {
                existingBundles = existingEquivalentBundle;
                throw existingEquivalentBundle;
            }
            finally {
                if (fin != null) {
                    if (existingBundles != null) {
                        try {
                            ((InputStream)fin).close();
                        }
                        catch (Throwable existingEquivalentBundle) {
                            ((Throwable)((Object)existingBundles)).addSuppressed(existingEquivalentBundle);
                        }
                    } else {
                        ((InputStream)fin).close();
                    }
                }
            }
            this.osgiManager.checkCorrectlyInstalled((OsgiBundleWithUrl)this.result.getMetadata(), this.result.bundle);
            if (!updating) {
                oldZipFile = null;
                oldManagedBundle = null;
                this.osgiManager.managedBundlesRecord.addManagedBundle(this.result, this.zipFile.getFile());
                this.result.code = OsgiBundleInstallationResult.ResultCode.INSTALLED_NEW_BUNDLE;
                this.result.message = "Installed Brooklyn catalog bundle " + this.result.getMetadata().getVersionedName() + " with ID " + this.result.getMetadata().getId() + " [" + this.result.bundle.getBundleId() + "]";
            } else {
                Pair<File, ManagedBundle> olds = this.osgiManager.managedBundlesRecord.updateManagedBundleFileAndMetadata(this.result, this.zipFile.getFile());
                oldZipFile = (File)olds.getLeft();
                oldManagedBundle = (ManagedBundle)olds.getRight();
                this.result.code = OsgiBundleInstallationResult.ResultCode.UPDATED_EXISTING_BUNDLE;
                this.result.message = "Updated Brooklyn catalog bundle " + this.result.getMetadata().getVersionedName() + " as existing ID " + this.result.getMetadata().getId() + " [" + this.result.bundle.getBundleId() + "]";
            }
            log.debug(this.result.message + " (partial): OSGi bundle installed, with bundle start and Brooklyn management to follow");
            this.zipFile.deleteIfTemp();
            this.zipFile = null;
            Runnable startRunnable = new Runnable(){

                private void rollbackBundle() {
                    if (updating) {
                        if (oldZipFile == null) {
                            throw new IllegalStateException("Did not have old ZIP file to install");
                        }
                        log.debug("Rolling back bundle " + BrooklynBomOsgiArchiveInstaller.this.result.getVersionedName() + " to state " + oldManagedBundle + " from " + oldZipFile);
                        try {
                            File zipFileNow = ((BrooklynBomOsgiArchiveInstaller)BrooklynBomOsgiArchiveInstaller.this).osgiManager.managedBundlesRecord.rollbackManagedBundleFileAndMetadata(BrooklynBomOsgiArchiveInstaller.this.result, oldZipFile, oldManagedBundle);
                            BrooklynBomOsgiArchiveInstaller.this.result.bundle.update((InputStream)new FileInputStream((File)Preconditions.checkNotNull((Object)zipFileNow, (Object)"Couldn't find contents of old version of bundle")));
                        }
                        catch (Exception e) {
                            Exceptions.propagateIfFatal((Throwable)e);
                            log.error("Error rolling back following failed install of updated " + BrooklynBomOsgiArchiveInstaller.this.result.getVersionedName() + "; installation will likely be corrupted and correct version should be manually installed.", (Throwable)e);
                        }
                        if (!BrooklynBomOsgiArchiveInstaller.this.isBlacklistedForPersistence(BrooklynBomOsgiArchiveInstaller.this.result.getMetadata())) {
                            ((BasicManagedBundle)BrooklynBomOsgiArchiveInstaller.this.result.getMetadata()).setPersistenceNeeded(true);
                            BrooklynBomOsgiArchiveInstaller.this.mgmt().getRebindManager().getChangeListener().onChanged((BrooklynObject)BrooklynBomOsgiArchiveInstaller.this.result.getMetadata());
                        }
                    } else {
                        if (BrooklynBomOsgiArchiveInstaller.this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement) {
                            log.debug("Uninstalling bundle " + BrooklynBomOsgiArchiveInstaller.this.result.getVersionedName() + " from Brooklyn management only (rollback needed but it was already installed to OSGi)");
                        } else {
                            log.debug("Uninstalling bundle " + BrooklynBomOsgiArchiveInstaller.this.result.getVersionedName() + " (roll back of failed fresh install, no previous version to revert to)");
                        }
                        BrooklynBomOsgiArchiveInstaller.this.osgiManager.uninstallUploadedBundle(BrooklynBomOsgiArchiveInstaller.this.result.getMetadata(), false, BrooklynBomOsgiArchiveInstaller.this.isBringingExistingOsgiInstalledBundleUnderBrooklynManagement);
                        if (!BrooklynBomOsgiArchiveInstaller.this.isBlacklistedForPersistence(BrooklynBomOsgiArchiveInstaller.this.result.getMetadata())) {
                            ((BasicManagedBundle)BrooklynBomOsgiArchiveInstaller.this.result.getMetadata()).setPersistenceNeeded(true);
                            BrooklynBomOsgiArchiveInstaller.this.mgmt().getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)BrooklynBomOsgiArchiveInstaller.this.result.getMetadata());
                        }
                    }
                }

                @Override
                public void run() {
                    if (BrooklynBomOsgiArchiveInstaller.this.start) {
                        try {
                            log.debug("Starting bundle " + BrooklynBomOsgiArchiveInstaller.this.result.getVersionedName());
                            if (!BrooklynBomOsgiArchiveInstaller.this.isBlacklistedForPersistence(BrooklynBomOsgiArchiveInstaller.this.result.getMetadata())) {
                                ((BasicManagedBundle)BrooklynBomOsgiArchiveInstaller.this.result.getMetadata()).setPersistenceNeeded(true);
                                if (updating) {
                                    BrooklynBomOsgiArchiveInstaller.this.mgmt().getRebindManager().getChangeListener().onChanged((BrooklynObject)BrooklynBomOsgiArchiveInstaller.this.result.getMetadata());
                                } else {
                                    BrooklynBomOsgiArchiveInstaller.this.mgmt().getRebindManager().getChangeListener().onManaged((BrooklynObject)BrooklynBomOsgiArchiveInstaller.this.result.getMetadata());
                                }
                            }
                            BrooklynBomOsgiArchiveInstaller.this.result.bundle.start();
                        }
                        catch (BundleException e) {
                            log.warn("Error starting bundle " + BrooklynBomOsgiArchiveInstaller.this.result.getVersionedName() + ", uninstalling, restoring any old bundle, then re-throwing error: " + (Object)((Object)e));
                            try {
                                this.rollbackBundle();
                            }
                            catch (Throwable t) {
                                Exceptions.propagateIfFatal((Throwable)t);
                                log.warn("Error rolling back " + BrooklynBomOsgiArchiveInstaller.this.result.getVersionedName() + " after bundle start problem; server may be in inconsistent state (swallowing this error and propagating installation error): " + Exceptions.collapseText((Throwable)t), t);
                                throw Exceptions.propagate((Throwable)new BundleException("Failure installing and rolling back; server may be in inconsistent state regarding bundle " + BrooklynBomOsgiArchiveInstaller.this.result.getVersionedName() + ". Rollback failure (" + Exceptions.collapseText((Throwable)t) + ") detailed in log. Installation error is: " + Exceptions.collapseText((Throwable)e), (Throwable)e));
                            }
                            throw Exceptions.propagate((Throwable)e);
                        }
                    }
                    if (BrooklynBomOsgiArchiveInstaller.this.loadCatalogBom) {
                        Iterable<RegisteredType> itemsFromOldBundle = null;
                        MutableMap itemsReplacedHere = null;
                        try {
                            if (updating) {
                                itemsFromOldBundle = BrooklynBomOsgiArchiveInstaller.this.osgiManager.uninstallCatalogItemsFromBundle(BrooklynBomOsgiArchiveInstaller.this.result.getVersionedName());
                            }
                            itemsReplacedHere = MutableMap.of();
                            BrooklynBomOsgiArchiveInstaller.this.osgiManager.loadBrooklynBundleWithCatalogBom(BrooklynBomOsgiArchiveInstaller.this.result.bundle, BrooklynBomOsgiArchiveInstaller.this.bomText, BrooklynBomOsgiArchiveInstaller.this.force, BrooklynBomOsgiArchiveInstaller.this.validateTypes, (Map<RegisteredType, RegisteredType>)itemsReplacedHere);
                            Iterable items = BrooklynBomOsgiArchiveInstaller.this.mgmt().getTypeRegistry().getMatching(RegisteredTypePredicates.containingBundle((OsgiBundleWithUrl)BrooklynBomOsgiArchiveInstaller.this.result.getMetadata()));
                            log.debug("Adding items from bundle " + BrooklynBomOsgiArchiveInstaller.this.result.getVersionedName() + ": " + items);
                            for (RegisteredType ci : items) {
                                BrooklynBomOsgiArchiveInstaller.this.result.addType(ci);
                            }
                        }
                        catch (Exception e) {
                            if (CatalogInitialization.isRebindReadOnlyShuttingDown(((BrooklynBomOsgiArchiveInstaller)BrooklynBomOsgiArchiveInstaller.this).osgiManager.mgmt)) {
                                throw Exceptions.propagate((Throwable)e);
                            }
                            log.warn("Error adding Brooklyn items from bundle " + BrooklynBomOsgiArchiveInstaller.this.result.getVersionedName() + ", uninstalling, restoring any old bundle and items, then re-throwing error: " + Exceptions.collapseText((Throwable)e));
                            try {
                                this.rollbackBundle();
                            }
                            catch (Throwable t) {
                                Exceptions.propagateIfFatal((Throwable)t);
                                log.warn("Error rolling back " + BrooklynBomOsgiArchiveInstaller.this.result.getVersionedName() + " after catalog install problem; server may be in inconsistent state (swallowing this error and propagating installation error): " + Exceptions.collapseText((Throwable)t), t);
                                throw Exceptions.propagate((Throwable)new BundleException("Failure loading catalog items, and also failed rolling back; server may be in inconsistent state regarding bundle " + BrooklynBomOsgiArchiveInstaller.this.result.getVersionedName() + ". Rollback failure (" + Exceptions.collapseText((Throwable)t) + ") detailed in log. Installation error is: " + Exceptions.collapseText((Throwable)e), (Throwable)e));
                            }
                            if (itemsFromOldBundle != null) {
                                for (RegisteredType oldItem : itemsFromOldBundle) {
                                    if (log.isTraceEnabled()) {
                                        log.trace("RESTORING replaced bundle item " + oldItem + "\n" + RegisteredTypes.getImplementationDataStringForSpec(oldItem));
                                    }
                                    ((BasicBrooklynTypeRegistry)BrooklynBomOsgiArchiveInstaller.this.mgmt().getTypeRegistry()).addToLocalUnpersistedTypeRegistry(oldItem, true);
                                }
                            }
                            if (itemsReplacedHere != null) {
                                MutableList replaced = MutableList.copyOf(itemsReplacedHere.values());
                                Collections.reverse(replaced);
                                for (RegisteredType oldItem : replaced) {
                                    if (oldItem == null) continue;
                                    if (log.isTraceEnabled()) {
                                        log.trace("RESTORING replaced external item " + oldItem + "\n" + RegisteredTypes.getImplementationDataStringForSpec(oldItem));
                                    }
                                    ((BasicBrooklynTypeRegistry)BrooklynBomOsgiArchiveInstaller.this.mgmt().getTypeRegistry()).addToLocalUnpersistedTypeRegistry(oldItem, true);
                                }
                            }
                            throw Exceptions.propagate((Throwable)e);
                        }
                    }
                }
            };
            if (this.deferredStart) {
                this.result.deferredStart = startRunnable;
                log.debug(this.result.message + " (Brooklyn load deferred)");
            } else {
                int startBundleCount = (Integer)this.mgmt().getOsgiManager().map(o -> o.getManagedBundles().size()).or((Object)0);
                startRunnable.run();
                int newBundleCount = (Integer)this.mgmt().getOsgiManager().map(o -> o.getManagedBundles().size()).or((Object)0) - startBundleCount;
                if (!this.result.typesInstalled.isEmpty() && newBundleCount <= 1) {
                    int LIST_EXPLICITLY_MAX = 5;
                    boolean LIST_EXPLICITLY_IF_MAX_EXCEEDED = true;
                    int listExplicitlyHereCount = this.result.typesInstalled.size() > 5 ? 1 : 5;
                    Iterable firstN = Iterables.transform((Iterable)MutableList.copyOf((Iterable)Iterables.limit(this.result.typesInstalled, (int)listExplicitlyHereCount)), input -> input.getVersionedName().toString());
                    log.info(this.result.message + " (completed), items: " + firstN + (this.result.typesInstalled.size() > listExplicitlyHereCount ? " (and others, " + this.result.typesInstalled.size() + " total)" : ""));
                    if (log.isDebugEnabled() && this.result.typesInstalled.size() > listExplicitlyHereCount) {
                        log.debug(this.result.message + ", all items: " + this.result.typesInstalled);
                    }
                } else {
                    log.info(this.result.message + " (completed), " + this.result.typesInstalled.size() + " item" + (this.result.typesInstalled.size() != 1 ? "s" : "") + " " + (newBundleCount > 1 ? " plus " + (newBundleCount - 1) + " other bundle" + (newBundleCount > 2 ? "s" : "") + " detected" : "") + ", " + Iterables.size((Iterable)this.mgmt().getTypeRegistry().getAll()) + " total in type registry");
                }
            }
            ReferenceWithError referenceWithError = ReferenceWithError.newInstanceWithoutError((Object)this.result);
            return referenceWithError;
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            this.result.code = startedInstallation ? OsgiBundleInstallationResult.ResultCode.ERROR_LAUNCHING_BUNDLE : OsgiBundleInstallationResult.ResultCode.ERROR_PREPARING_BUNDLE;
            this.result.message = "Bundle " + this.inferredMetadata + " failed " + (startedInstallation ? "installation" : "preparation") + ": " + Exceptions.collapseText((Throwable)e);
            ReferenceWithError referenceWithError = ReferenceWithError.newInstanceThrowingError((Object)this.result, (Throwable)new IllegalStateException(this.result.message, e));
            return referenceWithError;
        }
        finally {
            this.close();
        }
    }

    @VisibleForTesting
    static com.google.common.base.Optional<VersionedName> inferBundleNameFromMvnUrl(String url) {
        assert (url.startsWith("mvn:")) : "url=" + url;
        String[] parts = url.substring(4).split("/");
        if (parts.length != 3) {
            return com.google.common.base.Optional.absent();
        }
        if (parts[0].trim().isEmpty() || parts[1].trim().isEmpty() || parts[2].trim().isEmpty()) {
            return com.google.common.base.Optional.absent();
        }
        return com.google.common.base.Optional.of((Object)new VersionedName(parts[0] + "." + parts[1], parts[2]));
    }

    private static void setResultForciblyRemovedResult(OsgiManager osgiManager, VersionedName desiredBundle, ManagedBundle inferredMetadata, Maybe<VersionedName> replacementBundle, OsgiBundleInstallationResult result) {
        if (replacementBundle.isPresentAndNonNull()) {
            result.metadata = osgiManager.getManagedBundle((VersionedName)replacementBundle.get());
            if (result.getMetadata() != null) {
                result.bundle = osgiManager.getFramework().getBundleContext().getBundle(result.getMetadata().getOsgiUniqueUrl());
                log.debug("Bundle " + inferredMetadata + " forcibly replaced by bundle " + result.getMetadata() + "; install is no-op");
                result.setIgnoringForciblyRemoved(inferredMetadata.getVersionedName(), replacementBundle);
                return;
            }
            Optional<Bundle> replacer = Arrays.stream(osgiManager.getFramework().getBundleContext().getBundles()).filter(b -> ((VersionedName)replacementBundle.get()).equals(b.getSymbolicName(), b.getVersion())).findAny();
            if (replacer.isPresent()) {
                log.info("Bundle " + inferredMetadata + " forcibly replaced by bundle " + replacementBundle.get() + " which was not yet installed; installing it now");
                try {
                    replacer.get().start();
                }
                catch (Exception e) {
                    log.warn("Failed to install " + replacer.get() + " which declares itself as a replacement for " + inferredMetadata + " (rethrowing): " + e);
                    Exceptions.propagateAnnotated((String)("Failed to install " + replacer.get() + " which declares itself as a replacement for " + inferredMetadata), (Throwable)e);
                }
                result.metadata = osgiManager.getManagedBundle((VersionedName)replacementBundle.get());
                if (result.getMetadata() != null) {
                    result.bundle = osgiManager.getFramework().getBundleContext().getBundle(result.getMetadata().getOsgiUniqueUrl());
                    log.debug("Bundle " + inferredMetadata + " forcibly replaced by bundle " + result.getMetadata() + " which has been installed instead");
                    result.setIgnoringForciblyRemoved(inferredMetadata.getVersionedName(), replacementBundle);
                    return;
                }
                log.warn("Failed to find " + replacer.get() + " which declares itself as a replacement for " + inferredMetadata + ", after starting it (throwing); bundle status is: " + replacer.get().getState());
                throw new IllegalArgumentException("Bundle " + inferredMetadata + " forcibly replaced by bundle " + replacementBundle.get() + " started, but still replacement not found");
            }
            throw new IllegalArgumentException("Bundle " + inferredMetadata + " forcibly replaced by bundle " + replacementBundle.get() + ", but replacement not found");
        }
        log.debug("Bundle " + inferredMetadata + " forcibly removed, but no upgrade bundle supplied; install is no-op");
        result.setIgnoringForciblyRemoved(inferredMetadata.getVersionedName(), (Maybe<VersionedName>)Maybe.absent());
    }

    @VisibleForTesting
    boolean isBlacklistedForPersistence(ManagedBundle managedBundle) {
        if (this.blacklistBundlePersistencePredicate == null) {
            String whitelistRegex = (String)this.mgmt().getConfig().getConfig(PERSIST_MANAGED_BUNDLE_WHITELIST_REGEX);
            String blacklistRegex = (String)this.mgmt().getConfig().getConfig(PERSIST_MANAGED_BUNDLE_BLACKLIST_REGEX);
            Pattern whitelistPattern = whitelistRegex != null ? Pattern.compile(whitelistRegex) : null;
            Pattern blacklistPattern = blacklistRegex != null ? Pattern.compile(blacklistRegex) : null;
            this.blacklistBundlePersistencePredicate = input -> {
                String bundleName = input.getSymbolicName();
                if (whitelistPattern != null && whitelistPattern.matcher(bundleName).matches()) {
                    return false;
                }
                return blacklistPattern != null && blacklistPattern.matcher(bundleName).matches();
            };
        }
        return this.blacklistBundlePersistencePredicate.test(managedBundle);
    }

    private static List<Bundle> findBundlesBySymbolicNameAndVersion(OsgiManager osgiManager, ManagedBundle desired) {
        return Osgis.bundleFinder(osgiManager.getFramework()).symbolicName(desired.getSymbolicName()).version(desired.getOsgiVersionString()).findAll();
    }

    private static boolean checksumsMatch(ManagedBundle actual, ManagedBundle desired) {
        return actual.getChecksum() != null && Objects.equal((Object)actual.getChecksum(), (Object)desired.getChecksum());
    }

    private static Maybe<Bundle> tryFindSameOsgiUrlOrSameContentsBundle(Iterable<? extends Bundle> bundles, ManagedBundle desired, File zipFile) {
        for (Bundle bundle : bundles) {
            if (!BrooklynBomOsgiArchiveInstaller.isBundleSameOsgiUrlOrSameContents(bundle, desired, zipFile)) continue;
            return Maybe.of((Object)bundle);
        }
        return Maybe.absent();
    }

    private static boolean isBundleSameOsgiUrlOrSameContents(Bundle bundle, ManagedBundle desired, File zipFile) {
        if (Objects.equal((Object)bundle.getLocation(), (Object)desired.getUrl())) {
            log.debug("Request to install " + desired + " from same location " + bundle.getLocation() + " as existing OSGi installed (but not Brooklyn-managed) bundle " + bundle + ", so skipping reinstall");
            return true;
        }
        try {
            if (Streams.compare((InputStream)new FileInputStream(zipFile), (InputStream)new URL(bundle.getLocation()).openStream())) {
                log.debug("Request to install " + desired + " has same contents as existing OSGi installed (but not Brooklyn-managed) bundle " + bundle + ", so skipping reinstall");
                return true;
            }
            log.debug("Request to install " + desired + " has different contents as existing OSGi installed (but not Brooklyn-managed) bundle " + bundle + ", so will do reinstall (if no other equivalents found)");
            return false;
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.debug("Request to install " + desired + " could not compare contents with existing OSGi installed (but not Brooklyn-managed) bundle " + bundle + ", so will do reinstall if not other equivalents found (error " + e + " loading from " + bundle.getLocation() + ")");
            return false;
        }
    }

    private static String getChecksum(ZipFile zf) {
        try {
            MutableMap entriesToChecksum = MutableMap.of();
            for (ZipEntry zipEntry : Collections.list(zf.entries())) {
                entriesToChecksum.put(zipEntry.getName(), Streams.getMd5Checksum((InputStream)zf.getInputStream(zipEntry)));
            }
            return Streams.getMd5Checksum((InputStream)Streams.newInputStreamWithContents((String)new TreeMap(entriesToChecksum).toString()));
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private boolean canUpdate() {
        return this.force || VersionComparator.isSnapshot((String)this.inferredMetadata.getSuppliedVersionString()) && this.inputStreamSupplied;
    }

    private boolean matchSetOrFail(String source, String name, String version) {
        Map<?, ?> catalogMetadata;
        boolean inferredMetadataCanBeOverridden;
        boolean suppliedIsComplete = true;
        if (Strings.isBlank((CharSequence)name)) {
            suppliedIsComplete = false;
        } else if (Strings.isBlank((CharSequence)this.inferredMetadata.getSymbolicName())) {
            ((BasicManagedBundle)this.inferredMetadata).setSymbolicName(name);
        } else if (!Objects.equal((Object)this.inferredMetadata.getSymbolicName(), (Object)name)) {
            inferredMetadataCanBeOverridden = false;
            try {
                catalogMetadata = BasicBrooklynCatalog.getCatalogMetadata(this.bomText);
                if (!catalogMetadata.containsKey("bundle") && catalogMetadata.containsKey("id")) {
                    inferredMetadataCanBeOverridden = true;
                    log.warn("Installing bundle '" + this.inferredMetadata + "' from " + source + ", even though 'id' in its catalog BOM is different ('" + name + "', v '" + version + "'); strongly recommended that the BOM 'id' match the bundle symbolic name");
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
            }
            if (!inferredMetadataCanBeOverridden) {
                throw new IllegalArgumentException("Symbolic name mismatch '" + name + "' from " + source + " (expected '" + this.inferredMetadata.getSymbolicName() + "')");
            }
        }
        if (Strings.isBlank((CharSequence)version)) {
            suppliedIsComplete = false;
        } else if (Strings.isBlank((CharSequence)this.inferredMetadata.getSuppliedVersionString())) {
            ((BasicManagedBundle)this.inferredMetadata).setVersion(version);
        } else if (!BrooklynVersionSyntax.equalAsOsgiVersions((String)this.inferredMetadata.getSuppliedVersionString(), (String)version)) {
            inferredMetadataCanBeOverridden = false;
            try {
                if ("0.0.0-SNAPSHOT".equals(version)) {
                    inferredMetadataCanBeOverridden = true;
                } else {
                    catalogMetadata = BasicBrooklynCatalog.getCatalogMetadata(this.bomText);
                    if (!catalogMetadata.containsKey("bundle") && catalogMetadata.containsKey("id")) {
                        inferredMetadataCanBeOverridden = true;
                        log.warn("Installing bundle '" + this.inferredMetadata + "' from " + source + ", even though 'version' in its catalog BOM is different ('" + name + "', v '" + version + "'); strongly recommended that the BOM 'version' match the bundle version");
                    }
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
            }
            if (!inferredMetadataCanBeOverridden) {
                throw new IllegalArgumentException("Bundle version mismatch '" + version + "' from " + source + " (expected '" + this.inferredMetadata.getSuppliedVersionString() + "')");
            }
        }
        return suppliedIsComplete;
    }

    public static class PrepareInstallResult {
        public Bundle existingBundle;
        public OsgiBundleInstallationResult resultObject = null;
        public boolean isBringingExistingOsgiInstalledBundleUnderBrooklynManagement = false;
        public FileWithTempInfo<File> zipFile;
    }

    public static class FileWithTempInfo<T extends File> {
        private T f;
        public boolean isTemp;

        public FileWithTempInfo(T f, boolean isTemp) {
            this.f = f;
            this.isTemp = isTemp;
        }

        public void deleteIfTemp() {
            if (this.isTemp && this.getFile() != null) {
                ((File)this.getFile()).delete();
                this.f = null;
            }
        }

        public T getFile() {
            return this.f;
        }
    }
}

