/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.core.workflow.steps.CustomWorkflowStep;
import org.apache.brooklyn.entity.group.BasicGroup;
import org.apache.brooklyn.entity.group.DynamicGroup;
import org.apache.brooklyn.entity.group.DynamicMultiGroupImpl;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@ImplementedBy(value=DynamicMultiGroupImpl.class)
@Beta
public interface DynamicMultiGroup
extends DynamicGroup {
    @SetFromFlag(value="bucketFunction")
    public static final ConfigKey<Function<Entity, String>> BUCKET_FUNCTION = ConfigKeys.newConfigKey(new TypeToken<Function<Entity, String>>(){}, "brooklyn.multigroup.bucketFunction", "Function to return the bucket (name) an entity should be placed in");
    @SetFromFlag(value="bucketWorkflow")
    public static final ConfigKey<CustomWorkflowStep> BUCKET_WORKFLOW = ConfigKeys.newConfigKey(CustomWorkflowStep.class, "brooklyn.multigroup.bucketWorkflow", "Workflow to return the bucket (name) an entity should be placed in");
    @SetFromFlag(value="bucketExpression")
    public static final ConfigKey<String> BUCKET_EXPRESSION = ConfigKeys.newConfigKey(String.class, "brooklyn.multigroup.bucketExpression", "Freemarker template expression to return the bucket (name) an entity should be placed in");
    @SetFromFlag(value="bucketIdFunction")
    public static final ConfigKey<Function<Entity, String>> BUCKET_ID_FUNCTION = ConfigKeys.newConfigKey(new TypeToken<Function<Entity, String>>(){}, "brooklyn.multigroup.bucketIdFunction", "Used at bucket creation time to generate an ID for the bucket. Should be unique if and only if the bucket (name) function is unique for two entities. If not supplied, no ID is set.");
    public static final ConfigKey<CustomWorkflowStep> BUCKET_ID_WORKFLOW = ConfigKeys.newConfigKey(CustomWorkflowStep.class, "brooklyn.multigroup.bucketIdWorkflow");
    public static final ConfigKey<String> BUCKET_ID_EXPRESSION = ConfigKeys.newConfigKey(String.class, "brooklyn.multigroup.bucketIdExpression");
    @SetFromFlag(value="bucketSpec")
    public static final ConfigKey<EntitySpec<? extends BasicGroup>> BUCKET_SPEC = ConfigKeys.newConfigKey(new TypeToken<EntitySpec<? extends BasicGroup>>(){}, "brooklyn.multigroup.groupSpec", "Determines the entity type used for the 'bucket' groups", EntitySpec.create(BasicGroup.class));
    public static final AttributeSensor<Map<String, BasicGroup>> BUCKETS = Sensors.newSensor(new TypeToken<Map<String, BasicGroup>>(){}, "brooklyn.multigroup.buckets", "The bucket name to Group mappings");
    @SetFromFlag(value="rescanInterval")
    public static final ConfigKey<Long> RESCAN_INTERVAL = ConfigKeys.newLongConfigKey("brooklyn.multigroup.rescanInterval", "Interval (in seconds) between scans of all entities for membership. Set to null (default) or zero to disable.");
    public static final AttributeSensor<Void> RESCAN = Sensors.newSensor(Void.class, "brooklyn.multigroup.rescan", "Notification of entity rescan");

    public void distributeEntities();
}

