/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.stock;

import com.google.common.base.Supplier;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.effector.MethodEffector;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.entity.group.SequenceGroup;
import org.apache.brooklyn.entity.stock.SequenceEntityImpl;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@ImplementedBy(value=SequenceEntityImpl.class)
public interface SequenceEntity
extends Entity,
Startable,
Supplier<Integer> {
    public static final AttributeSensor<Integer> SEQUENCE_VALUE = SequenceGroup.SEQUENCE_VALUE;
    public static final AttributeSensor<AtomicInteger> SEQUENCE_STATE = SequenceGroup.SEQUENCE_STATE;
    @SetFromFlag(value="sequenceStart")
    public static final ConfigKey<Integer> SEQUENCE_START = SequenceGroup.SEQUENCE_START;
    @SetFromFlag(value="sequenceIncrement")
    public static final ConfigKey<Integer> SEQUENCE_INCREMENT = SequenceGroup.SEQUENCE_INCREMENT;
    public static final MethodEffector<Void> RESET = new MethodEffector(SequenceEntity.class, "reset");
    public static final MethodEffector<Void> INCREMENT = new MethodEffector(SequenceEntity.class, "increment");
    public static final MethodEffector<Integer> GET = new MethodEffector(SequenceEntity.class, "get");
    public static final MethodEffector<Integer> INCREMENT_AND_GET = new MethodEffector(SequenceEntity.class, "incrementAndGet");

    @Effector(description="Reset the sequence to initial value")
    public Void reset();

    @Effector(description="Update the value of the sequence by the configured increment")
    public Void increment();

    @Effector(description="Return the current numeric value of the sequence")
    public Integer get();

    @Effector(description="Update and return the next value of the sequence")
    public Integer incrementAndGet();
}

