/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.logbook.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.logbook.BrooklynLogEntry;
import org.apache.brooklyn.util.core.logbook.LogBookQueryParams;
import org.apache.brooklyn.util.core.logbook.LogStore;
import org.apache.brooklyn.util.core.logbook.LogbookConfig;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Time;

public class FileLogStore
implements LogStore {
    public static final String BASE_NAME_FILE_LOG_STORE = "brooklyn.logbook.fileLogStore";
    public static final ConfigKey<String> LOGBOOK_LOG_STORE_PATH;
    public static final ConfigKey<String> LOGBOOK_LOG_STORE_REGEX;
    public static final ConfigKey<String> LOGBOOK_LOG_STORE_DATEFORMAT;
    public static final TimeZone UTC_TIMEZONE;
    private final String filePath;
    private final Path path;
    private final String logLinePatternString;
    private final Pattern logLinePatternCompiled;
    private final DateFormat dateFormat;
    private final ManagementContext mgmt;
    private final Integer maxTasks;
    private static final boolean STARTING_TASK_MESSAGE_IS_ALWAYS_THE_FIRST_MESSAGE_FOR_THAT_TASK = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    @VisibleForTesting
    public FileLogStore() {
        this.mgmt = null;
        this.maxTasks = (Integer)LogbookConfig.LOGBOOK_MAX_RECURSIVE_TASKS.getDefaultValue();
        this.path = null;
        this.filePath = "";
        this.logLinePatternString = (String)LOGBOOK_LOG_STORE_REGEX.getDefaultValue();
        this.logLinePatternCompiled = Pattern.compile(this.logLinePatternString);
        this.dateFormat = new SimpleDateFormat((String)LOGBOOK_LOG_STORE_DATEFORMAT.getDefaultValue());
        this.dateFormat.setTimeZone(UTC_TIMEZONE);
    }

    public FileLogStore(ManagementContext mgmt) {
        this.mgmt = (ManagementContext)Preconditions.checkNotNull((Object)mgmt);
        this.maxTasks = (Integer)mgmt.getConfig().getConfig(LogbookConfig.LOGBOOK_MAX_RECURSIVE_TASKS);
        this.filePath = (String)mgmt.getConfig().getConfig(LOGBOOK_LOG_STORE_PATH);
        this.logLinePatternString = (String)mgmt.getConfig().getConfig(LOGBOOK_LOG_STORE_REGEX);
        this.logLinePatternCompiled = Pattern.compile(this.logLinePatternString);
        this.dateFormat = new SimpleDateFormat((String)mgmt.getConfig().getConfig(LOGBOOK_LOG_STORE_DATEFORMAT));
        this.dateFormat.setTimeZone(UTC_TIMEZONE);
        Preconditions.checkNotNull((Object)this.filePath, (Object)("Log file path must be set: " + LOGBOOK_LOG_STORE_PATH.getName()));
        this.path = Paths.get(this.filePath, new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<BrooklynLogEntry> query(LogBookQueryParams params) {
        try (Stream<String> stream = Files.lines(this.path);){
            MutableSet childTaskIds = MutableSet.of();
            if (Strings.isNonBlank((CharSequence)params.getTaskId()) && params.isRecursive().booleanValue() && this.mgmt != null) {
                Task parent = this.mgmt.getExecutionManager().getTask(params.getTaskId());
                BrooklynTaskTags.WorkflowTaskTag wf = BrooklynTaskTags.getWorkflowTaskTag(parent, false);
                String workflowId = wf != null ? wf.getWorkflowId() : null;
                childTaskIds.addAll(this.enumerateTaskIds((Set<?>)MutableSet.of().putIfNotNull((Object)parent).putIfNotNull((Object)workflowId), this.maxTasks));
            }
            Date dateTimeFrom = Strings.isNonBlank((CharSequence)params.getDateTimeFrom()) ? Time.parseDate((String)params.getDateTimeFrom()) : null;
            Date dateTimeTo = Strings.isNonBlank((CharSequence)params.getDateTimeTo()) ? Time.parseDate((String)params.getDateTimeTo()) : null;
            Predicate<BrooklynLogEntry> filter = arg_0 -> FileLogStore.lambda$query$1(params, dateTimeFrom, dateTimeTo, (Set)childTaskIds, arg_0);
            AtomicInteger lineCount = new AtomicInteger();
            List filteredQueryResult = stream.map(line -> this.parseLogLine((String)line, lineCount)).filter(filter).collect(Collectors.toList());
            Stream filteredStream = params.isTail() != false ? filteredQueryResult.stream().skip(Math.max(0, filteredQueryResult.size() - params.getNumberOfItems())) : filteredQueryResult.stream().limit(params.getNumberOfItems().intValue());
            List<BrooklynLogEntry> list = filteredStream.collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected BrooklynLogEntry parseLogLine(String logLine, AtomicInteger lineCount) {
        Pattern p = this.logLinePatternCompiled;
        Matcher m = p.matcher(logLine);
        BrooklynLogEntry entry = null;
        m.find();
        if (m.matches()) {
            entry = new BrooklynLogEntry();
            entry.setTimestampString(m.group("timestamp"));
            Maybe calendarMaybe = Time.parseCalendarFormat((String)entry.getTimestampString(), (DateFormat)this.dateFormat);
            if (calendarMaybe.isPresentAndNonNull()) {
                entry.setDatetime(((Calendar)calendarMaybe.get()).getTime());
            }
            entry.setTaskId(m.group("taskId"));
            entry.setEntityIds(m.group("entityIds"));
            entry.setLevel(m.group("level").trim());
            entry.setBundleId(m.group("bundleId"));
            entry.setClazz(m.group("class"));
            entry.setThreadName(m.group("threadName"));
            entry.setMessage(m.group("message"));
            entry.setLineId(String.valueOf(lineCount.incrementAndGet()));
        }
        return entry;
    }

    private static boolean entryMessageIsStartingTaskFromKnownTask(BrooklynLogEntry entry, Set<String> knownTasks) {
        if (entry == null || entry.getMessage() == null || !entry.getMessage().startsWith("Starting task ")) {
            return false;
        }
        String msg = entry.getMessage();
        int fromTaskIndex = msg.lastIndexOf("from task ");
        if (fromTaskIndex < 0) {
            return false;
        }
        String fromTask = Strings.getFirstWord((String)msg.substring(fromTaskIndex + 10));
        return knownTasks.contains(fromTask);
    }

    @Override
    public Set<String> enumerateTaskIds(Set<?> parents, int maxTasks) {
        MutableSet all = MutableSet.of();
        if (parents != null) {
            MutableSet next = MutableSet.copyOf((Iterable)parents.stream().map(t -> {
                Object s = t;
                if (s instanceof Task) {
                    s = ((Task)s).getId();
                }
                if (s instanceof String) {
                    return (String)s;
                }
                return null;
            }).filter(x -> x != null).collect(Collectors.toSet()));
            while (!next.isEmpty() && all.size() < maxTasks) {
                MutableSet current = MutableSet.copyOf((Iterable)next);
                next.clear();
                all.addAll(current);
                AtomicInteger lineCount = new AtomicInteger();
                try {
                    Stream<String> stream = Files.lines(this.path);
                    Throwable throwable = null;
                    try {
                        stream.forEach(arg_0 -> this.lambda$enumerateTaskIds$5(lineCount, (Set)current, (Set)all, maxTasks, (Set)next, arg_0));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }
        return all;
    }

    private /* synthetic */ void lambda$enumerateTaskIds$5(AtomicInteger lineCount, Set current, Set all, int maxTasks, Set next, String line) {
        BrooklynLogEntry entry = this.parseLogLine(line, lineCount);
        if (FileLogStore.entryMessageIsStartingTaskFromKnownTask(entry, current)) {
            String newTaskId = entry.getMessage();
            int nextWord = (newTaskId = Strings.removeFromStart((String)newTaskId, (String)"Starting task ")).indexOf(32);
            if (nextWord > 0 && all.add(newTaskId = newTaskId.substring(0, nextWord))) {
                if (all.size() >= maxTasks) {
                    return;
                }
                current.add(newTaskId);
            }
        }
    }

    private static /* synthetic */ boolean lambda$query$1(LogBookQueryParams params, Date dateTimeFrom, Date dateTimeTo, Set childTaskIds, BrooklynLogEntry brooklynLogEntry) {
        if (brooklynLogEntry == null || brooklynLogEntry.getDatetime() == null) {
            return false;
        }
        if (!(params.getLevels().isEmpty() || params.getLevels().contains("ALL") || params.getLevels().contains(brooklynLogEntry.getLevel()))) {
            return false;
        }
        if (!(Objects.isNull(dateTimeFrom) || brooklynLogEntry.getDatetime() != null && brooklynLogEntry.getDatetime().compareTo(dateTimeFrom) >= 0)) {
            return false;
        }
        if (!(Objects.isNull(dateTimeTo) || brooklynLogEntry.getDatetime() != null && brooklynLogEntry.getDatetime().compareTo(dateTimeTo) <= 0)) {
            return false;
        }
        if (!(!Strings.isNonBlank((CharSequence)params.getEntityId()) || !Strings.isBlank((CharSequence)brooklynLogEntry.getEntityIds()) && brooklynLogEntry.getEntityIds().contains(params.getEntityId()) || !Strings.isBlank((CharSequence)brooklynLogEntry.getMessage()) && brooklynLogEntry.getMessage().contains(params.getEntityId()))) {
            return false;
        }
        if (Strings.isNonBlank((CharSequence)params.getTaskId())) {
            boolean isSearchTaskIdMatch = false;
            boolean bl = isSearchTaskIdMatch = params.getTaskId().equals(brooklynLogEntry.getTaskId()) || Strings.isNonBlank((CharSequence)brooklynLogEntry.getMessage()) && brooklynLogEntry.getMessage().contains(params.getTaskId());
            if (params.isRecursive().booleanValue() && !isSearchTaskIdMatch && !childTaskIds.isEmpty()) {
                isSearchTaskIdMatch = childTaskIds.stream().anyMatch(id -> id.equals(brooklynLogEntry.getTaskId()) || Strings.isNonBlank((CharSequence)brooklynLogEntry.getMessage()) && brooklynLogEntry.getMessage().contains((CharSequence)id));
            }
            if (!isSearchTaskIdMatch) {
                return false;
            }
        }
        return !Strings.isNonBlank((CharSequence)params.getSearchPhrase()) || !Strings.isBlank((CharSequence)brooklynLogEntry.getMessage()) && brooklynLogEntry.getMessage().contains(params.getSearchPhrase());
    }

    static {
        boolean bl = $assertionsDisabled = !FileLogStore.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !FileLogStore.class.getName().equals(LogbookConfig.LOGBOOK_LOG_STORE_CLASSNAME.getDefaultValue())) {
            throw new AssertionError();
        }
        LOGBOOK_LOG_STORE_PATH = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(String.class, "brooklyn.logbook.fileLogStore.path").description("Log file path")).defaultValue((String)"data/log/brooklyn.debug.log")).constraint(Predicates.notNull())).build();
        LOGBOOK_LOG_STORE_REGEX = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(String.class, "brooklyn.logbook.fileLogStore.regexPattern").description("Log entry regex pattern")).defaultValue((String)"^(?<timestamp>\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.\\d{3}Z) (?<taskId>\\S+)?-(?<entityIds>\\S+)? (?<level>\\w{4} |\\w{5})\\W{1,4}(?<bundleId>\\d{1,3}) (?<class>(?:\\S\\.)*\\S*) \\[(?<threadName>\\S+)\\] (?<message>[\\s\\S]*?)\\n*(?=^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.\\d{3}|\\z)")).build();
        LOGBOOK_LOG_STORE_DATEFORMAT = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(String.class, "brooklyn.logbook.fileLogStore.dateFormat").description("Date format")).defaultValue((String)"yyyy-MM-dd'T'HH:mm:ss,SSS'Z'")).build();
        UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    }
}

