/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractJAXBProvider;
import org.apache.cxf.jaxrs.provider.json.utils.JSONUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXBUtils;
import org.apache.cxf.staxutils.DocumentDepthProperties;
import org.apache.cxf.staxutils.StaxUtils;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.SimpleConverter;
import org.codehaus.jettison.mapped.TypeConverter;
import org.codehaus.jettison.util.StringIndenter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Produces(value={"application/json", "application/*+json"})
@Consumes(value={"application/json", "application/*+json"})
@Provider
public class JSONProvider<T>
extends AbstractJAXBProvider<T> {
    private static final String MAPPED_CONVENTION = "mapped";
    private static final String BADGER_FISH_CONVENTION = "badgerfish";
    private static final String DROP_ROOT_CONTEXT_PROPERTY = "drop.json.root.element";
    private static final String ARRAY_KEYS_PROPERTY = "json.array.keys";
    private static final String ROOT_IS_ARRAY_PROPERTY = "json.root.is.array";
    private static final String DROP_ELEMENT_IN_XML_PROPERTY = "drop.xml.elements";
    private static final String IGNORE_EMPTY_JSON_ARRAY_VALUES_PROPERTY = "ignore.empty.json.array.values";
    private ConcurrentHashMap<String, String> namespaceMap = new ConcurrentHashMap();
    private boolean serializeAsArray;
    private List<String> arrayKeys;
    private List<String> primitiveArrayKeys;
    private boolean unwrapped;
    private String wrapperName;
    private String namespaceSeparator;
    private Map<String, String> wrapperMap;
    private boolean dropRootElement;
    private boolean dropElementsInXmlStream = true;
    private boolean dropCollectionWrapperElement;
    private boolean ignoreMixedContent;
    private boolean ignoreEmptyArrayValues;
    private boolean writeXsiType = true;
    private boolean readXsiType = true;
    private boolean ignoreNamespaces;
    private String convention = "mapped";
    private TypeConverter typeConverter;
    private boolean attributesToElements;
    private boolean writeNullAsString = true;
    private boolean escapeForwardSlashesAlways;

    public void setAttributesToElements(boolean value) {
        this.attributesToElements = value;
    }

    public void setConvention(String value) {
        if (!MAPPED_CONVENTION.equals(value) && !BADGER_FISH_CONVENTION.equals(value)) {
            throw new IllegalArgumentException("Unsupported convention \"" + value);
        }
        this.convention = value;
    }

    public void setConvertTypesToStrings(boolean convert) {
        if (convert) {
            this.setTypeConverter((TypeConverter)new SimpleConverter());
        }
    }

    public void setTypeConverter(TypeConverter converter) {
        this.typeConverter = converter;
    }

    public void setIgnoreNamespaces(boolean ignoreNamespaces) {
        this.ignoreNamespaces = ignoreNamespaces;
    }

    @Context
    public void setMessageContext(MessageContext mc) {
        super.setContext(mc);
    }

    public void setDropRootElement(boolean drop) {
        this.dropRootElement = drop;
    }

    public void setDropCollectionWrapperElement(boolean drop) {
        this.dropCollectionWrapperElement = drop;
    }

    public void setIgnoreMixedContent(boolean ignore) {
        this.ignoreMixedContent = ignore;
    }

    public void setSupportUnwrapped(boolean unwrap) {
        this.unwrapped = unwrap;
    }

    public void setWrapperName(String wName) {
        this.wrapperName = wName;
    }

    public void setWrapperMap(Map<String, String> map) {
        this.wrapperMap = map;
    }

    public void setSerializeAsArray(boolean asArray) {
        this.serializeAsArray = asArray;
    }

    public void setArrayKeys(List<String> keys) {
        this.arrayKeys = keys;
    }

    public void setNamespaceMap(Map<String, String> namespaceMap) {
        this.namespaceMap.putAll(namespaceMap);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        return super.isReadable(type, genericType, anns, mt) || Document.class.isAssignableFrom(type);
    }

    /*
     * Exception decompiling
     */
    public T readFrom(Class<T> type, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 25[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected XMLStreamReader createReader(Class<?> type, InputStream is, boolean isCollection, String enc) throws Exception {
        XMLStreamReader reader = this.createReader(type, is, enc);
        return isCollection ? new AbstractJAXBProvider.JAXBCollectionWrapperReader(reader) : reader;
    }

    protected XMLStreamReader createReader(Class<?> type, InputStream is, String enc) throws Exception {
        XMLStreamReader reader = null;
        reader = BADGER_FISH_CONVENTION.equals(this.convention) ? JSONUtils.createBadgerFishReader(is, enc) : JSONUtils.createStreamReader(is, this.readXsiType, this.namespaceMap, this.namespaceSeparator, this.primitiveArrayKeys, this.getDepthProperties(), enc);
        reader = this.createTransformReaderIfNeeded(reader, is);
        return reader;
    }

    protected InputStream getInputStream(Class<T> cls, Type type, InputStream is) throws Exception {
        if (this.unwrapped) {
            String rootName = this.getRootName(cls, type);
            ByteArrayInputStream isBefore = new ByteArrayInputStream(rootName.getBytes());
            String after = "}";
            ByteArrayInputStream isAfter = new ByteArrayInputStream(after.getBytes());
            final InputStream[] streams = new InputStream[]{isBefore, is, isAfter};
            Enumeration<InputStream> list = new Enumeration<InputStream>(){
                private int index;

                @Override
                public boolean hasMoreElements() {
                    return this.index < streams.length;
                }

                @Override
                public InputStream nextElement() {
                    return streams[this.index++];
                }
            };
            return new SequenceInputStream((Enumeration<? extends InputStream>)list);
        }
        return is;
    }

    protected String getRootName(Class<T> cls, Type type) throws Exception {
        QName qname;
        String name = null;
        if (this.wrapperName != null) {
            name = this.wrapperName;
        } else if (this.wrapperMap != null) {
            name = this.wrapperMap.get(cls.getName());
        }
        if (name == null && (qname = this.getQName(cls, type, null)) != null) {
            name = qname.getLocalPart();
            String prefix = qname.getPrefix();
            if (prefix.length() > 0) {
                name = prefix + "." + name;
            }
        }
        if (name == null) {
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        return "{\"" + name + "\":";
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        return super.isWriteable(type, genericType, anns, mt) || Document.class.isAssignableFrom(type);
    }

    /*
     * Exception decompiling
     */
    public void writeTo(T obj, Class<?> cls, Type genericType, Annotation[] anns, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void copyReaderToWriter(XMLStreamReader reader, XMLStreamWriter writer) throws Exception {
        writer.writeStartDocument();
        StaxUtils.copy((XMLStreamReader)reader, (XMLStreamWriter)writer);
        writer.writeEndDocument();
    }

    protected void marshalCollection(Class<?> originalCls, Object collection, Type genericType, String encoding, OutputStream os, MediaType m, Annotation[] anns) throws Exception {
        Class actualClass = InjectionUtils.getActualType((Type)genericType);
        actualClass = this.getActualType(actualClass, genericType, anns);
        List<Object> c = originalCls.isArray() ? Arrays.asList((Object[])collection) : (List<Object>)collection;
        Iterator it = c.iterator();
        Object firstObj = it.hasNext() ? (Object)it.next() : null;
        String startTag = null;
        String endTag = null;
        if (!this.dropCollectionWrapperElement) {
            QName qname = null;
            if (firstObj instanceof JAXBElement) {
                JAXBElement el = (JAXBElement)firstObj;
                qname = el.getName();
                actualClass = el.getDeclaredType();
            } else {
                qname = this.getCollectionWrapperQName(actualClass, genericType, firstObj, false);
            }
            String prefix = "";
            if (!this.ignoreNamespaces) {
                prefix = this.namespaceMap.get(qname.getNamespaceURI());
                if (prefix != null) {
                    if (prefix.length() > 0) {
                        prefix = prefix + ".";
                    }
                } else if (qname.getNamespaceURI().length() > 0) {
                    prefix = "ns1.";
                }
            }
            prefix = prefix == null ? "" : prefix;
            startTag = "{\"" + prefix + qname.getLocalPart() + "\":[";
            endTag = "]}";
        } else if (this.serializeAsArray) {
            startTag = "[";
            endTag = "]";
        } else {
            startTag = "{";
            endTag = "}";
        }
        os.write(startTag.getBytes());
        if (firstObj != null) {
            XmlJavaTypeAdapter adapter = JAXBUtils.getAdapter(firstObj.getClass(), (Annotation[])anns);
            this.marshalCollectionMember(JAXBUtils.useAdapter((Object)firstObj, (XmlJavaTypeAdapter)adapter, (boolean)true), actualClass, genericType, encoding, os);
            while (it.hasNext()) {
                os.write(",".getBytes());
                this.marshalCollectionMember(JAXBUtils.useAdapter(it.next(), (XmlJavaTypeAdapter)adapter, (boolean)true), actualClass, genericType, encoding, os);
            }
        }
        os.write(endTag.getBytes());
    }

    protected void marshalCollectionMember(Object obj, Class<?> cls, Type genericType, String enc, OutputStream os) throws Exception {
        if ((obj = obj instanceof JAXBElement ? ((JAXBElement)obj).getValue() : this.convertToJaxbElementIfNeeded(obj, cls, genericType)) instanceof JAXBElement && cls != JAXBElement.class) {
            cls = JAXBElement.class;
        }
        Marshaller ms = this.createMarshaller(obj, cls, genericType, enc);
        this.marshal(ms, obj, cls, genericType, enc, os, true);
    }

    protected void marshal(Marshaller ms, Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os, boolean isCollection) throws Exception {
        OutputStream actualOs = os;
        MessageContext mc = this.getContext();
        if (mc != null && PropertyUtils.isTrue((Object)mc.get((Object)"jaxb.formatted.output"))) {
            actualOs = new CachedOutputStream();
        }
        XMLStreamWriter writer = this.createWriter(actualObject, actualClass, genericType, enc, actualOs, isCollection);
        if (this.namespaceMap.size() > 1 || this.namespaceMap.size() == 1 && !this.namespaceMap.containsKey("http://www.w3.org/2001/XMLSchema-instance")) {
            this.setNamespaceMapper(ms, this.namespaceMap);
        }
        org.apache.cxf.common.jaxb.JAXBUtils.setNoEscapeHandler((Marshaller)ms);
        ms.marshal(actualObject, writer);
        writer.close();
        if (os != actualOs) {
            StringIndenter formatter = new StringIndenter(IOUtils.newStringFromBytes((byte[])((CachedOutputStream)actualOs).getBytes()));
            OutputStreamWriter outWriter = new OutputStreamWriter(os, enc);
            IOUtils.copy((Reader)new StringReader(formatter.result()), (Writer)outWriter, (int)2048);
            ((Writer)outWriter).close();
        }
    }

    protected XMLStreamWriter createWriter(Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os, boolean isCollection) throws Exception {
        boolean dropRootInJsonStream;
        boolean ignoreEmpty;
        QName qname;
        if (BADGER_FISH_CONVENTION.equals(this.convention)) {
            return JSONUtils.createBadgerFishWriter(os, enc);
        }
        boolean dropElementsInXmlStreamProp = this.getBooleanJsonProperty(DROP_ELEMENT_IN_XML_PROPERTY, this.dropElementsInXmlStream);
        boolean dropRootNeeded = this.getBooleanJsonProperty(DROP_ROOT_CONTEXT_PROPERTY, this.dropRootElement);
        boolean dropRootInXmlNeeded = dropRootNeeded && dropElementsInXmlStreamProp;
        QName qName = qname = actualClass == Document.class ? DOMUtils.getElementQName((Element)((Document)actualObject).getDocumentElement()) : this.getQName(actualClass, genericType, actualObject);
        if (qname != null && this.ignoreNamespaces && (isCollection || dropRootInXmlNeeded)) {
            qname = new QName(qname.getLocalPart());
        }
        Configuration config = JSONUtils.createConfiguration(this.namespaceMap, this.writeXsiType && !this.ignoreNamespaces, this.attributesToElements, this.typeConverter);
        if (this.namespaceSeparator != null) {
            config.setJsonNamespaceSeparator(this.namespaceSeparator);
        }
        if (!dropElementsInXmlStreamProp && this.outDropElements != null) {
            config.setIgnoredElements(this.outDropElements);
        }
        if (!this.writeNullAsString) {
            config.setWriteNullAsString(this.writeNullAsString);
        }
        if (ignoreEmpty = this.getBooleanJsonProperty(IGNORE_EMPTY_JSON_ARRAY_VALUES_PROPERTY, this.ignoreEmptyArrayValues)) {
            config.setIgnoreEmptyArrayValues(ignoreEmpty);
        }
        if (this.escapeForwardSlashesAlways) {
            config.setEscapeForwardSlashAlways(this.escapeForwardSlashesAlways);
        }
        boolean bl = dropRootInJsonStream = dropRootNeeded && !dropElementsInXmlStreamProp;
        if (dropRootInJsonStream) {
            config.setDropRootElement(true);
        }
        List<String> theArrayKeys = this.getArrayKeys();
        boolean rootIsArray = this.isRootArray(theArrayKeys);
        if (this.ignoreNamespaces && rootIsArray && (theArrayKeys == null || dropRootInJsonStream)) {
            if (theArrayKeys == null) {
                theArrayKeys = new LinkedList<String>();
            } else if (dropRootInJsonStream) {
                theArrayKeys = new LinkedList<String>(theArrayKeys);
            }
            if (qname != null) {
                theArrayKeys.add(qname.getLocalPart());
            }
        }
        XMLStreamWriter writer = JSONUtils.createStreamWriter(os, qname, this.writeXsiType && !this.ignoreNamespaces, config, rootIsArray, theArrayKeys, isCollection || dropRootInXmlNeeded, enc);
        writer = JSONUtils.createIgnoreMixedContentWriterIfNeeded(writer, this.ignoreMixedContent);
        writer = JSONUtils.createIgnoreNsWriterIfNeeded(writer, this.ignoreNamespaces, !this.writeXsiType);
        return this.createTransformWriterIfNeeded(writer, os, dropElementsInXmlStreamProp);
    }

    protected List<String> getArrayKeys() {
        Object prop;
        MessageContext mc = this.getContext();
        if (mc != null && (prop = mc.get((Object)ARRAY_KEYS_PROPERTY)) instanceof List) {
            return CastUtils.cast((List)((List)prop));
        }
        return this.arrayKeys;
    }

    protected boolean isRootArray(List<String> theArrayKeys) {
        return theArrayKeys != null || this.getBooleanJsonProperty(ROOT_IS_ARRAY_PROPERTY, this.serializeAsArray);
    }

    protected boolean getBooleanJsonProperty(String name, boolean defaultValue) {
        Object prop;
        MessageContext mc = this.getContext();
        if (mc != null && (prop = mc.get((Object)name)) != null) {
            return PropertyUtils.isTrue((Object)prop);
        }
        return defaultValue;
    }

    protected void marshal(Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os) throws Exception {
        if ((actualObject = this.convertToJaxbElementIfNeeded(actualObject, actualClass, genericType)) instanceof JAXBElement && actualClass != JAXBElement.class) {
            actualClass = JAXBElement.class;
        }
        Marshaller ms = this.createMarshaller(actualObject, actualClass, genericType, enc);
        this.marshal(ms, actualObject, actualClass, genericType, enc, os, false);
    }

    private QName getQName(Class<?> cls, Type type, Object object) throws Exception {
        QName qname = this.getJaxbQName(cls, type, object, false);
        if (qname != null) {
            String prefix = this.getPrefix(qname.getNamespaceURI());
            return new QName(qname.getNamespaceURI(), qname.getLocalPart(), prefix);
        }
        return null;
    }

    private String getPrefix(String namespace) {
        String prefix = this.namespaceMap.get(namespace);
        return prefix == null ? "" : prefix;
    }

    public void setWriteXsiType(boolean writeXsiType) {
        this.writeXsiType = writeXsiType;
    }

    public void setReadXsiType(boolean readXsiType) {
        this.readXsiType = readXsiType;
    }

    public void setPrimitiveArrayKeys(List<String> primitiveArrayKeys) {
        this.primitiveArrayKeys = primitiveArrayKeys;
    }

    public void setDropElementsInXmlStream(boolean drop) {
        this.dropElementsInXmlStream = drop;
    }

    public void setWriteNullAsString(boolean writeNullAsString) {
        this.writeNullAsString = writeNullAsString;
    }

    public void setIgnoreEmptyArrayValues(boolean ignoreEmptyArrayElements) {
        this.ignoreEmptyArrayValues = ignoreEmptyArrayElements;
    }

    protected DocumentDepthProperties getDepthProperties() {
        DocumentDepthProperties depthProperties = super.getDepthProperties();
        if (depthProperties != null) {
            return depthProperties;
        }
        if (this.getContext() != null) {
            String totalElementCountStr = (String)this.getContext().getContextualProperty((Object)"depthTotalElementCountThreshold");
            String innerElementCountStr = (String)this.getContext().getContextualProperty((Object)"depthInnerElementCountThreshold");
            String elementLevelStr = (String)this.getContext().getContextualProperty((Object)"depthInnerElementLevelThreshold");
            if (totalElementCountStr != null || innerElementCountStr != null || elementLevelStr != null) {
                try {
                    int totalElementCount = totalElementCountStr != null ? Integer.parseInt(totalElementCountStr) : -1;
                    int elementLevel = elementLevelStr != null ? Integer.parseInt(elementLevelStr) : -1;
                    int innerElementCount = innerElementCountStr != null ? Integer.parseInt(innerElementCountStr) : -1;
                    return new DocumentDepthProperties(totalElementCount, elementLevel, innerElementCount);
                }
                catch (Exception ex) {
                    throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
                }
            }
        }
        return null;
    }

    public void setEscapeForwardSlashesAlways(boolean escape) {
        this.escapeForwardSlashesAlways = escape;
    }

    public void setNamespaceSeparator(String namespaceSeparator) {
        this.namespaceSeparator = namespaceSeparator;
    }

    static {
        new SimpleConverter();
    }
}

