/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.providers.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Map;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;

public class UpdateProviderMetadataFromProperties
implements Function<Properties, ProviderMetadata> {
    private final ApiMetadata apiMetadata;
    private final Optional<ProviderMetadata> providerMetadata;

    public UpdateProviderMetadataFromProperties(ProviderMetadata providerMetadata) {
        this(((ProviderMetadata)Preconditions.checkNotNull((Object)providerMetadata, (Object)"providerMetadata")).getApiMetadata(), (Optional<ProviderMetadata>)Optional.of((Object)providerMetadata));
    }

    public UpdateProviderMetadataFromProperties(ApiMetadata apiMetadata) {
        this((ApiMetadata)Preconditions.checkNotNull((Object)apiMetadata, (Object)"apiMetadata"), (Optional<ProviderMetadata>)Optional.absent());
    }

    public UpdateProviderMetadataFromProperties(ApiMetadata apiMetadata, Optional<ProviderMetadata> providerMetadata) {
        this.apiMetadata = (ApiMetadata)Preconditions.checkNotNull((Object)apiMetadata, (Object)"apiMetadata");
        this.providerMetadata = (Optional)Preconditions.checkNotNull(providerMetadata, (Object)"providerMetadata");
    }

    public ProviderMetadata apply(Properties input) {
        Properties mutable = new Properties();
        mutable.putAll((Map<?, ?>)input);
        ApiMetadata apiMetadata = this.apiMetadata.toBuilder().name(UpdateProviderMetadataFromProperties.getAndRemove(mutable, "jclouds.api", this.apiMetadata.getName())).version(UpdateProviderMetadataFromProperties.getAndRemove(mutable, "jclouds.api-version", this.apiMetadata.getVersion())).buildVersion(UpdateProviderMetadataFromProperties.getAndRemove(mutable, "jclouds.build-version", (String)this.apiMetadata.getBuildVersion().orNull())).build();
        String endpoint = UpdateProviderMetadataFromProperties.getAndRemove(mutable, "jclouds.endpoint", this.providerMetadata.isPresent() ? ((ProviderMetadata)this.providerMetadata.get()).getEndpoint() : null);
        String providerId = UpdateProviderMetadataFromProperties.getAndRemove(mutable, "jclouds.provider", this.providerMetadata.isPresent() ? ((ProviderMetadata)this.providerMetadata.get()).getId() : apiMetadata.getId());
        String isoCodes = UpdateProviderMetadataFromProperties.getAndRemove(mutable, "jclouds.iso3166-codes", this.providerMetadata.isPresent() ? Joiner.on((char)',').join(((ProviderMetadata)this.providerMetadata.get()).getIso3166Codes()) : "");
        ProviderMetadata providerMetadata = ((ProviderMetadata)this.providerMetadata.or((Object)AnonymousProviderMetadata.forApiWithEndpoint(apiMetadata, (String)Preconditions.checkNotNull((Object)endpoint, (Object)"jclouds.endpoint")))).toBuilder().apiMetadata(apiMetadata).id(providerId).iso3166Codes(Splitter.on((char)',').omitEmptyStrings().split((CharSequence)isoCodes)).endpoint(endpoint).defaultProperties(mutable).build();
        return providerMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAndRemove(Properties expanded, String key, String defaultVal) {
        try {
            String string = expanded.getProperty(key, defaultVal);
            return string;
        }
        finally {
            expanded.remove(key);
        }
    }
}

