/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher.common;

import com.google.common.base.Supplier;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.util.exceptions.FatalRuntimeException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.io.FileUtil;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynPropertiesFactoryHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynPropertiesFactoryHelper.class);
    private final String globalBrooklynPropertiesFile;
    private final String localBrooklynPropertiesFile;
    private final Supplier<Map<?, ?>> propertiesSupplier;
    private final BrooklynProperties brooklynProperties;

    public BrooklynPropertiesFactoryHelper(String globalBrooklynPropertiesFile, String localBrooklynPropertiesFile) {
        this(globalBrooklynPropertiesFile, localBrooklynPropertiesFile, null, null);
    }

    public BrooklynPropertiesFactoryHelper(BrooklynProperties brooklynProperties) {
        this(null, null, brooklynProperties, null);
    }

    public BrooklynPropertiesFactoryHelper(String globalBrooklynPropertiesFile, String localBrooklynPropertiesFile, BrooklynProperties brooklynProperties) {
        this(globalBrooklynPropertiesFile, localBrooklynPropertiesFile, brooklynProperties, null);
    }

    public BrooklynPropertiesFactoryHelper(String globalBrooklynPropertiesFile, String localBrooklynPropertiesFile, Supplier<Map<?, ?>> propertiesSupplier) {
        this(globalBrooklynPropertiesFile, localBrooklynPropertiesFile, null, propertiesSupplier);
    }

    public BrooklynPropertiesFactoryHelper(String globalBrooklynPropertiesFile, String localBrooklynPropertiesFile, BrooklynProperties brooklynProperties, Supplier<Map<?, ?>> propertiesSupplier) {
        this.globalBrooklynPropertiesFile = globalBrooklynPropertiesFile;
        this.localBrooklynPropertiesFile = localBrooklynPropertiesFile;
        this.brooklynProperties = brooklynProperties;
        this.propertiesSupplier = propertiesSupplier;
    }

    public BrooklynProperties.Factory.Builder createPropertiesBuilder() {
        if (this.brooklynProperties == null) {
            BrooklynProperties.Factory.Builder builder = BrooklynProperties.Factory.builderDefault();
            if (Strings.isNonEmpty((CharSequence)this.globalBrooklynPropertiesFile)) {
                File globalProperties = new File(Os.tidyPath((String)this.globalBrooklynPropertiesFile));
                if (globalProperties.exists()) {
                    globalProperties = this.resolveSymbolicLink(globalProperties);
                    this.checkFileReadable(globalProperties);
                    this.checkFilePermissionsX00(globalProperties);
                    LOG.debug("Using global properties file " + globalProperties);
                } else {
                    LOG.debug("Global properties file " + globalProperties + " does not exist, will ignore");
                }
                builder.globalPropertiesFile(globalProperties.getAbsolutePath());
            } else {
                LOG.debug("Global properties file disabled");
                builder.globalPropertiesFile(null);
            }
            if (Strings.isNonEmpty((CharSequence)this.localBrooklynPropertiesFile)) {
                File localProperties = new File(Os.tidyPath((String)this.localBrooklynPropertiesFile));
                localProperties = this.resolveSymbolicLink(localProperties);
                this.checkFileReadable(localProperties);
                this.checkFilePermissionsX00(localProperties);
                builder.localPropertiesFile(localProperties.getAbsolutePath());
            }
            if (this.propertiesSupplier != null) {
                builder.propertiesSupplier(this.propertiesSupplier);
            }
            return builder;
        }
        if (this.globalBrooklynPropertiesFile != null) {
            LOG.info("Ignoring globalBrooklynPropertiesFile " + this.globalBrooklynPropertiesFile + " because explicit brooklynProperties supplied");
        }
        if (this.localBrooklynPropertiesFile != null) {
            LOG.info("Ignoring localBrooklynPropertiesFile " + this.localBrooklynPropertiesFile + " because explicit brooklynProperties supplied");
        }
        return BrooklynProperties.Factory.Builder.fromProperties((BrooklynProperties)this.brooklynProperties);
    }

    private File resolveSymbolicLink(File f) {
        File f2 = f;
        try {
            f2 = f.getCanonicalFile();
            if (Files.isSymbolicLink(f.toPath())) {
                LOG.debug("Resolved symbolic link: {} -> {}", (Object)f, (Object)f2);
            }
        }
        catch (IOException e) {
            LOG.warn("Could not determine canonical name of file " + f + "; returning original file", (Throwable)e);
        }
        return f2;
    }

    private void checkFileReadable(File f) {
        if (!f.exists()) {
            throw new FatalRuntimeException("File " + f + " does not exist");
        }
        if (!f.isFile()) {
            throw new FatalRuntimeException(f + " is not a file");
        }
        if (!f.canRead()) {
            throw new FatalRuntimeException(f + " is not readable");
        }
    }

    private void checkFilePermissionsX00(File f) {
        Maybe permission = FileUtil.getFilePermissions((File)f);
        if (permission.isAbsent()) {
            LOG.debug("Could not determine permissions of file; assuming ok: " + f);
        } else if (!((String)permission.get()).subSequence(4, 10).equals("------")) {
            throw new FatalRuntimeException("Invalid permissions for file " + f + "; expected ?00 but was " + (String)permission.get());
        }
    }
}

