/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCBackendRef;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilter;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilterBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilterFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GRPCBackendRefFluent<A extends GRPCBackendRefFluent<A>>
extends BaseFluent<A> {
    private ArrayList<GRPCRouteFilterBuilder> filters = new ArrayList();
    private String group;
    private String kind;
    private String name;
    private String namespace;
    private Integer port;
    private Integer weight;
    private Map<String, Object> additionalProperties;

    public GRPCBackendRefFluent() {
    }

    public GRPCBackendRefFluent(GRPCBackendRef instance) {
        GRPCBackendRef gRPCBackendRef = instance = instance != null ? instance : new GRPCBackendRef();
        if (instance != null) {
            this.withFilters(instance.getFilters());
            this.withGroup(instance.getGroup());
            this.withKind(instance.getKind());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withPort(instance.getPort());
            this.withWeight(instance.getWeight());
            this.withFilters(instance.getFilters());
            this.withGroup(instance.getGroup());
            this.withKind(instance.getKind());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withPort(instance.getPort());
            this.withWeight(instance.getWeight());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToFilters(int index, GRPCRouteFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get((Object)"filters").add(index, builder);
            this.filters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToFilters(int index, GRPCRouteFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get((Object)"filters").set(index, builder);
            this.filters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToFilters(GRPCRouteFilter ... items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToFilters(Collection<GRPCRouteFilter> items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromFilters(GRPCRouteFilter ... items) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").remove((Object)builder);
            this.filters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFilters(Collection<GRPCRouteFilter> items) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").remove((Object)builder);
            this.filters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromFilters(Predicate<GRPCRouteFilterBuilder> predicate) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        Iterator<GRPCRouteFilterBuilder> each = this.filters.iterator();
        List visitables = this._visitables.get((Object)"filters");
        while (each.hasNext()) {
            GRPCRouteFilterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GRPCRouteFilter> buildFilters() {
        return this.filters != null ? GRPCBackendRefFluent.build(this.filters) : null;
    }

    public GRPCRouteFilter buildFilter(int index) {
        return this.filters.get(index).build();
    }

    public GRPCRouteFilter buildFirstFilter() {
        return this.filters.get(0).build();
    }

    public GRPCRouteFilter buildLastFilter() {
        return this.filters.get(this.filters.size() - 1).build();
    }

    public GRPCRouteFilter buildMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
        for (GRPCRouteFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
        for (GRPCRouteFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFilters(List<GRPCRouteFilter> filters) {
        if (this.filters != null) {
            this._visitables.get((Object)"filters").clear();
        }
        if (filters != null) {
            this.filters = new ArrayList();
            for (GRPCRouteFilter item : filters) {
                this.addToFilters(item);
            }
        } else {
            this.filters = null;
        }
        return (A)((Object)this);
    }

    public A withFilters(GRPCRouteFilter ... filters) {
        if (this.filters != null) {
            this.filters.clear();
            this._visitables.remove((Object)"filters");
        }
        if (filters != null) {
            for (GRPCRouteFilter item : filters) {
                this.addToFilters(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public FiltersNested<A> addNewFilter() {
        return new FiltersNested(-1, null);
    }

    public FiltersNested<A> addNewFilterLike(GRPCRouteFilter item) {
        return new FiltersNested(-1, item);
    }

    public FiltersNested<A> setNewFilterLike(int index, GRPCRouteFilter item) {
        return new FiltersNested(index, item);
    }

    public FiltersNested<A> editFilter(int index) {
        if (this.filters.size() <= index) {
            throw new RuntimeException("Can't edit filters. Index exceeds size.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editFirstFilter() {
        if (this.filters.size() == 0) {
            throw new RuntimeException("Can't edit first filters. The list is empty.");
        }
        return this.setNewFilterLike(0, this.buildFilter(0));
    }

    public FiltersNested<A> editLastFilter() {
        int index = this.filters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last filters. The list is empty.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!predicate.test(this.filters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching filters. No match found.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group = group;
        return (A)((Object)this);
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public Integer getPort() {
        return this.port;
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public A withWeight(Integer weight) {
        this.weight = weight;
        return (A)((Object)this);
    }

    public boolean hasWeight() {
        return this.weight != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GRPCBackendRefFluent that = (GRPCBackendRefFluent)((Object)o);
        if (!Objects.equals(this.filters, that.filters)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.weight, that.weight)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.filters, this.group, this.kind, this.name, this.namespace, this.port, this.weight, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters != null && !this.filters.isEmpty()) {
            sb.append("filters:");
            sb.append(this.filters + ",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.weight != null) {
            sb.append("weight:");
            sb.append(this.weight + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class FiltersNested<N>
    extends GRPCRouteFilterFluent<FiltersNested<N>>
    implements Nested<N> {
        GRPCRouteFilterBuilder builder;
        int index;

        FiltersNested(int index, GRPCRouteFilter item) {
            this.index = index;
            this.builder = new GRPCRouteFilterBuilder(this, item);
        }

        public N and() {
            return (N)GRPCBackendRefFluent.this.setToFilters(this.index, this.builder.build());
        }

        public N endFilter() {
            return this.and();
        }
    }
}

