/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.binders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.functions.ListOfMapsToListOfKeyValuesDelimitedByBlankLines;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindServerToPlainTextString
implements Binder {
    private final Function<Server, Map<String, String>> createServerRequestToMap;
    private final ListOfMapsToListOfKeyValuesDelimitedByBlankLines listOfMapsToListOfKeyValuesDelimitedByBlankLines;

    @Inject
    public BindServerToPlainTextString(Function<Server, Map<String, String>> createServerRequestToMap, ListOfMapsToListOfKeyValuesDelimitedByBlankLines listOfMapsToListOfKeyValuesDelimitedByBlankLines) {
        this.createServerRequestToMap = createServerRequestToMap;
        this.listOfMapsToListOfKeyValuesDelimitedByBlankLines = listOfMapsToListOfKeyValuesDelimitedByBlankLines;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        Preconditions.checkArgument((boolean)(payload instanceof Server), (Object)"this binder is only valid for Server!");
        Server create = (Server)Server.class.cast(payload);
        Map map = (Map)this.createServerRequestToMap.apply((Object)create);
        request.setPayload(this.listOfMapsToListOfKeyValuesDelimitedByBlankLines.apply((Iterable<Map<String, String>>)ImmutableSet.of((Object)map)));
        request.getPayload().getContentMetadata().setContentType("text/plain");
        return request;
    }
}

