/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.mysql;

import com.google.common.base.Function;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.entity.database.mysql.MySqlDriver;
import org.apache.brooklyn.entity.database.mysql.MySqlNode;
import org.apache.brooklyn.entity.database.mysql.MySqlNodeEffectors;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshFeed;
import org.apache.brooklyn.feed.ssh.SshPollConfig;
import org.apache.brooklyn.feed.ssh.SshPollValue;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlNodeImpl
extends SoftwareProcessImpl
implements MySqlNode {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlNodeImpl.class);
    String DEFAULT_USERNAME = "root";
    private SshFeed feed;

    public Class<?> getDriverInterface() {
        return MySqlDriver.class;
    }

    public MySqlDriver getDriver() {
        return (MySqlDriver)super.getDriver();
    }

    public void init() {
        super.init();
        this.getMutableEntityType().addEffector(EXECUTE_SCRIPT, (EffectorBody)new EffectorBody<String>(){

            public String call(ConfigBag parameters) {
                return MySqlNodeImpl.this.executeScript((String)parameters.getStringKey("commands"));
            }
        });
        this.getMutableEntityType().addEffector(MySqlNodeEffectors.EXPORT_DUMP);
        this.getMutableEntityType().addEffector(MySqlNodeEffectors.IMPORT_DUMP);
        this.getMutableEntityType().addEffector(MySqlNodeEffectors.CHANGE_PASSWORD);
    }

    protected void connectSensors() {
        super.connectSensors();
        this.sensors().set(DATASTORE_URL, (Object)String.format("mysql://%s:%s/", this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)MYSQL_PORT)));
        this.sensors().set(USER, (Object)this.getUser());
        Maybe machine = Locations.findUniqueSshMachineLocation((Iterable)this.getLocations());
        boolean retrieveUsageMetrics = (Boolean)this.getConfig(RETRIEVE_USAGE_METRICS);
        if (machine.isPresent()) {
            String cmd = this.getDriver().getStatusCmd();
            this.feed = (SshFeed)((SshFeed.Builder)((SshFeed.Builder)((SshFeed.Builder)SshFeed.builder().entity((Entity)this)).period((Duration)this.config().get(SERVICE_PROCESS_IS_RUNNING_POLL_PERIOD))).machine((MachineLocation)machine.get())).poll((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)new SshPollConfig(QUERIES_PER_SECOND_FROM_MYSQL).command(cmd).onSuccess((Function)new Function<SshPollValue, Double>(){

                public Double apply(SshPollValue input) {
                    String q = Strings.getFirstWordAfter((String)input.getStdout(), (String)"Queries per second avg:");
                    if (q == null) {
                        return null;
                    }
                    return Double.parseDouble(q);
                }
            })).setOnFailureOrException(null)).enabled(retrieveUsageMetrics)).poll((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)new SshPollConfig(SERVICE_PROCESS_IS_RUNNING).command(cmd).setOnSuccess((Object)true)).setOnFailureOrException((Object)false)).suppressDuplicates(true)).build();
        } else {
            LOG.warn("Location(s) {} not an ssh-machine location, so not polling for status; setting serviceUp immediately", (Object)this.getLocations());
            this.sensors().set(SERVICE_UP, (Object)true);
        }
    }

    protected void disconnectSensors() {
        if (this.feed != null) {
            this.feed.stop();
        }
        super.disconnectSensors();
    }

    public int getPort() {
        return (Integer)this.getAttribute((AttributeSensor)MYSQL_PORT);
    }

    public synchronized String getSocketUid() {
        String result = (String)this.getAttribute((AttributeSensor)MySqlNode.SOCKET_UID);
        if (Strings.isBlank((CharSequence)result)) {
            result = Identifiers.makeRandomId((int)6);
            this.sensors().set((AttributeSensor)MySqlNode.SOCKET_UID, (Object)result);
        }
        return result;
    }

    public String getUser() {
        return this.DEFAULT_USERNAME;
    }

    public String getPassword() {
        String result = (String)this.getAttribute((AttributeSensor)MySqlNode.PASSWORD);
        if (Strings.isBlank((CharSequence)result)) {
            result = Identifiers.makeRandomId((int)12);
            this.sensors().set((AttributeSensor)MySqlNode.PASSWORD, (Object)result);
        }
        return result;
    }

    public String getShortName() {
        return "MySQL";
    }

    @Override
    public String executeScript(String commands) {
        return this.getDriver().executeScriptAsync(commands).block().getStdout();
    }
}

