/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.entity.drivers.downloads.DownloadResolver;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.software.base.VanillaSoftwareProcess;
import org.apache.brooklyn.entity.software.base.VanillaSoftwareProcessDriver;
import org.apache.brooklyn.entity.software.base.lifecycle.ScriptHelper;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.file.ArchiveUtils;
import org.apache.brooklyn.util.core.file.BrooklynOsCommands;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommandsConfigurable;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;

public class VanillaSoftwareProcessSshDriver
extends AbstractSoftwareProcessSshDriver
implements VanillaSoftwareProcessDriver {
    String downloadedFilename = null;

    public VanillaSoftwareProcessSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    @Override
    protected String getInstallLabelExtraSalt() {
        Integer hash = this.hashCodeIfResolved(new ConfigKey[]{SoftwareProcess.DOWNLOAD_URL.getConfigKey(), VanillaSoftwareProcess.INSTALL_COMMAND, SoftwareProcess.SHELL_ENVIRONMENT});
        if (hash == null) {
            return Identifiers.makeRandomId((int)8);
        }
        if (hash == 0) {
            return "default";
        }
        return Identifiers.makeIdFromHash((long)hash.intValue());
    }

    private Integer hashCodeIfResolved(ConfigKey<?> ... keys) {
        int hash = 0;
        for (ConfigKey<?> k : keys) {
            Maybe value = ((BrooklynObjectInternal.ConfigurationSupportInternal)this.getEntity().config()).getNonBlocking(k);
            if (!value.isPresent()) continue;
            hash = hash * 31 + (value.get() == null ? 0 : value.get().hashCode());
        }
        return hash;
    }

    @Override
    public void install() {
        Maybe url = ((EntityInternal)this.getEntity()).config().getRaw(SoftwareProcess.DOWNLOAD_URL);
        if (url.isPresentAndNonNull()) {
            DownloadResolver resolver = Entities.newDownloader((EntityDriver)this);
            List urls = resolver.getTargets();
            this.downloadedFilename = resolver.getFilename();
            LinkedList commands = new LinkedList();
            BashCommandsConfigurable bash = BrooklynOsCommands.bash((Location)this.getMachine());
            commands.addAll(bash.commandsToDownloadUrlsAs(urls, this.downloadedFilename));
            commands.addAll(ArchiveUtils.installCommands((BashCommandsConfigurable)bash, (String)this.downloadedFilename));
            int result = this.newScript(ImmutableMap.of((Object)"installIncomplete", (Object)Boolean.valueOf((boolean)true)), (String)"installing").failOnNonZeroResultCode((boolean)false).body.append(commands).execute();
            if (result != 0) {
                for (String urlI : urls) {
                    result = ArchiveUtils.install((SshMachineLocation)this.getMachine(), (String)urlI, (String)Urls.mergePaths((String[])new String[]{this.getInstallDir(), this.downloadedFilename}));
                    if (result != 0) continue;
                    break;
                }
                if (result != 0) {
                    throw new IllegalStateException("Error installing archive: " + this.downloadedFilename);
                }
            }
        }
        String installCommand = (String)this.getEntity().getConfig(VanillaSoftwareProcess.INSTALL_COMMAND);
        if (url.isPresentAndNonNull() && Strings.isBlank((CharSequence)installCommand)) {
            installCommand = "# mark as complete";
        }
        if (Strings.isNonBlank((CharSequence)installCommand)) {
            this.newScript((String)"installing").failOnNonZeroResultCode().environmentVariablesReset(this.getShellEnvironment()).body.append((CharSequence)installCommand).execute();
        }
    }

    @Override
    public void customize() {
        String customizeCommand;
        if (this.downloadedFilename != null) {
            this.newScript((String)"customizing").failOnNonZeroResultCode().environmentVariablesReset().body.append(ArchiveUtils.extractCommands((String)this.downloadedFilename, (String)this.getInstallDir())).execute();
        }
        if (Strings.isNonBlank((CharSequence)(customizeCommand = (String)this.getEntity().getConfig(VanillaSoftwareProcess.CUSTOMIZE_COMMAND)))) {
            this.newScript((String)"customizing").failOnNonZeroResultCode().body.append((CharSequence)customizeCommand).execute();
        }
    }

    @Override
    public Map<String, String> getShellEnvironment() {
        return MutableMap.copyOf(super.getShellEnvironment()).add((Object)"PID_FILE", (Object)this.getPidFile());
    }

    public String getPidFile() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "pid.txt"});
    }

    @Override
    public void launch() {
        String launchCommand = (String)this.getEntity().getConfig(VanillaSoftwareProcess.LAUNCH_COMMAND);
        if (Strings.isNonBlank((CharSequence)launchCommand)) {
            this.newScript((String)"launching").failOnNonZeroResultCode().body.append((CharSequence)launchCommand).execute();
        }
    }

    @Override
    public boolean isRunning() {
        String customCommand = (String)this.getEntity().getConfig(VanillaSoftwareProcess.CHECK_RUNNING_COMMAND);
        ScriptHelper script = null;
        script = customCommand == null ? this.newScript((Map<String, ?>)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "check-running") : this.newScript((String)"check-running").body.append((CharSequence)customCommand);
        return script.execute() == 0;
    }

    @Override
    public void stop() {
        String customCommand = (String)this.getEntity().getConfig(VanillaSoftwareProcess.STOP_COMMAND);
        ScriptHelper script = null;
        script = customCommand == null ? this.newScript((Map<String, ?>)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "stopping") : this.newScript((String)"stopping").body.append((CharSequence)customCommand);
        script.execute();
    }
}

