/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.javax.annotation.Nullable;

public class Template
implements Comparable<Template> {
    private final String id;
    private final String displayText;
    private final String domain;
    private final String domainId;
    private final String account;
    private final String accountId;
    private final String zone;
    private final String zoneId;
    private final String OSType;
    private final String OSTypeId;
    private final String name;
    private final Type type;
    private final Status status;
    private final Format format;
    private final String hypervisor;
    private final Long size;
    private final Date created;
    private final Date removed;
    private final boolean crossZones;
    private final boolean bootable;
    private final boolean extractable;
    private final boolean featured;
    private final boolean ispublic;
    private final boolean ready;
    private final boolean passwordEnabled;
    private final String jobId;
    private final String jobStatus;
    private final String checksum;
    private final String hostId;
    private final String hostName;
    private final String sourceTemplateId;
    private final String templateTag;
    private final Set<Tag> tags;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromTemplate(this);
    }

    @ConstructorProperties(value={"id", "displaytext", "domain", "domainid", "account", "accountid", "zonename", "zoneid", "ostypename", "ostypeid", "name", "templatetype", "status", "format", "hypervisor", "size", "created", "removed", "crossZones", "bootable", "isextractable", "isfeatured", "ispublic", "isready", "passwordenabled", "jobid", "jobstatus", "checksum", "hostId", "hostname", "sourcetemplateid", "templatetag", "tags"})
    protected Template(String id, @Nullable String displayText, @Nullable String domain, @Nullable String domainId, @Nullable String account, @Nullable String accountId, @Nullable String zone, @Nullable String zoneId, @Nullable String OSType2, @Nullable String OSTypeId, @Nullable String name, @Nullable Type type, @Nullable Status status, @Nullable Format format, @Nullable String hypervisor, @Nullable Long size, @Nullable Date created, @Nullable Date removed, boolean crossZones, boolean bootable, boolean extractable, boolean featured, boolean ispublic, boolean ready, boolean passwordEnabled, @Nullable String jobId, @Nullable String jobStatus, @Nullable String checksum, @Nullable String hostId, @Nullable String hostName, @Nullable String sourceTemplateId, @Nullable String templateTag, @Nullable Set<Tag> tags) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.displayText = displayText;
        this.domain = domain;
        this.domainId = domainId;
        this.account = account;
        this.accountId = accountId;
        this.zone = zone;
        this.zoneId = zoneId;
        this.OSType = OSType2;
        this.OSTypeId = OSTypeId;
        this.name = name;
        this.type = type;
        this.status = status;
        this.format = format;
        this.hypervisor = hypervisor;
        this.size = size;
        this.created = created;
        this.removed = removed;
        this.crossZones = crossZones;
        this.bootable = bootable;
        this.extractable = extractable;
        this.featured = featured;
        this.ispublic = ispublic;
        this.ready = ready;
        this.passwordEnabled = passwordEnabled;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.checksum = checksum;
        this.hostId = hostId;
        this.hostName = hostName;
        this.sourceTemplateId = sourceTemplateId;
        this.templateTag = templateTag;
        this.tags = tags == null ? ImmutableSet.of() : ImmutableSet.copyOf(tags);
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getDisplayText() {
        return this.displayText;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public String getAccountId() {
        return this.accountId;
    }

    @Nullable
    public String getZone() {
        return this.zone;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    @Nullable
    public String getOSType() {
        return this.OSType;
    }

    @Nullable
    public String getOSTypeId() {
        return this.OSTypeId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    @Nullable
    public Status getStatus() {
        return this.status;
    }

    @Nullable
    public Format getFormat() {
        return this.format;
    }

    @Nullable
    public String getHypervisor() {
        return this.hypervisor;
    }

    @Nullable
    public Long getSize() {
        return this.size;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public Date getRemoved() {
        return this.removed;
    }

    public boolean isCrossZones() {
        return this.crossZones;
    }

    public boolean isBootable() {
        return this.bootable;
    }

    public boolean isExtractable() {
        return this.extractable;
    }

    public boolean isFeatured() {
        return this.featured;
    }

    public boolean ispublic() {
        return this.ispublic;
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isPasswordEnabled() {
        return this.passwordEnabled;
    }

    @Nullable
    public String getJobId() {
        return this.jobId;
    }

    @Nullable
    public String getJobStatus() {
        return this.jobStatus;
    }

    @Nullable
    public String getChecksum() {
        return this.checksum;
    }

    @Nullable
    public String getHostId() {
        return this.hostId;
    }

    @Nullable
    public String getHostName() {
        return this.hostName;
    }

    @Nullable
    public String getSourceTemplateId() {
        return this.sourceTemplateId;
    }

    @Nullable
    public String getTemplateTag() {
        return this.templateTag;
    }

    @Nullable
    public Set<Tag> getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.displayText, this.domain, this.domainId, this.account, this.accountId, this.zone, this.zoneId, this.OSType, this.OSTypeId, this.name, this.type, this.status, this.format, this.hypervisor, this.size, this.created, this.removed, this.crossZones, this.bootable, this.extractable, this.featured, this.ispublic, this.ready, this.passwordEnabled, this.jobId, this.jobStatus, this.checksum, this.hostId, this.hostName, this.sourceTemplateId, this.templateTag, this.tags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Template that = (Template)Template.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.displayText, (Object)that.displayText) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.account, (Object)that.account) && Objects.equal((Object)this.accountId, (Object)that.accountId) && Objects.equal((Object)this.zone, (Object)that.zone) && Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal((Object)this.OSType, (Object)that.OSType) && Objects.equal((Object)this.OSTypeId, (Object)that.OSTypeId) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)((Object)this.status), (Object)((Object)that.status)) && Objects.equal((Object)((Object)this.format), (Object)((Object)that.format)) && Objects.equal((Object)this.hypervisor, (Object)that.hypervisor) && Objects.equal((Object)this.size, (Object)that.size) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.removed, (Object)that.removed) && Objects.equal((Object)this.crossZones, (Object)that.crossZones) && Objects.equal((Object)this.bootable, (Object)that.bootable) && Objects.equal((Object)this.extractable, (Object)that.extractable) && Objects.equal((Object)this.featured, (Object)that.featured) && Objects.equal((Object)this.ispublic, (Object)that.ispublic) && Objects.equal((Object)this.ready, (Object)that.ready) && Objects.equal((Object)this.passwordEnabled, (Object)that.passwordEnabled) && Objects.equal((Object)this.jobId, (Object)that.jobId) && Objects.equal((Object)this.jobStatus, (Object)that.jobStatus) && Objects.equal((Object)this.checksum, (Object)that.checksum) && Objects.equal((Object)this.hostId, (Object)that.hostId) && Objects.equal((Object)this.hostName, (Object)that.hostName) && Objects.equal((Object)this.sourceTemplateId, (Object)that.sourceTemplateId) && Objects.equal((Object)this.templateTag, (Object)that.templateTag) && Objects.equal(this.tags, that.tags);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("displayText", (Object)this.displayText).add("domain", (Object)this.domain).add("domainId", (Object)this.domainId).add("account", (Object)this.account).add("accountId", (Object)this.accountId).add("zone", (Object)this.zone).add("zoneId", (Object)this.zoneId).add("OSType", (Object)this.OSType).add("OSTypeId", (Object)this.OSTypeId).add("name", (Object)this.name).add("type", (Object)this.type).add("status", (Object)this.status).add("format", (Object)this.format).add("hypervisor", (Object)this.hypervisor).add("size", (Object)this.size).add("created", (Object)this.created).add("removed", (Object)this.removed).add("crossZones", this.crossZones).add("bootable", this.bootable).add("extractable", this.extractable).add("featured", this.featured).add("ispublic", this.ispublic).add("ready", this.ready).add("passwordEnabled", this.passwordEnabled).add("jobId", (Object)this.jobId).add("jobStatus", (Object)this.jobStatus).add("checksum", (Object)this.checksum).add("hostId", (Object)this.hostId).add("hostName", (Object)this.hostName).add("sourceTemplateId", (Object)this.sourceTemplateId).add("templateTag", (Object)this.templateTag).add("tags", this.tags);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Template o) {
        return this.id.compareTo(o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String displayText;
        protected String domain;
        protected String domainId;
        protected String account;
        protected String accountId;
        protected String zone;
        protected String zoneId;
        protected String OSType;
        protected String OSTypeId;
        protected String name;
        protected Type type;
        protected Status status;
        protected Format format;
        protected String hypervisor;
        protected Long size;
        protected Date created;
        protected Date removed;
        protected boolean crossZones;
        protected boolean bootable;
        protected boolean extractable;
        protected boolean featured;
        protected boolean isPublic;
        protected boolean ready;
        protected boolean passwordEnabled;
        protected String jobId;
        protected String jobStatus;
        protected String checksum;
        protected String hostId;
        protected String hostName;
        protected String sourceTemplateId;
        protected String templateTag;
        protected Set<Tag> tags = ImmutableSet.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T displayText(String displayText) {
            this.displayText = displayText;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T accountId(String accountId) {
            this.accountId = accountId;
            return this.self();
        }

        public T zone(String zone) {
            this.zone = zone;
            return this.self();
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T OSType(String OSType2) {
            this.OSType = OSType2;
            return this.self();
        }

        public T OSTypeId(String OSTypeId) {
            this.OSTypeId = OSTypeId;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T type(Type type) {
            this.type = type;
            return this.self();
        }

        public T status(Status status) {
            this.status = status;
            return this.self();
        }

        public T format(Format format) {
            this.format = format;
            return this.self();
        }

        public T hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this.self();
        }

        public T size(Long size) {
            this.size = size;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T removed(Date removed) {
            this.removed = removed;
            return this.self();
        }

        public T crossZones(boolean crossZones) {
            this.crossZones = crossZones;
            return this.self();
        }

        public T bootable(boolean bootable) {
            this.bootable = bootable;
            return this.self();
        }

        public T extractable(boolean extractable) {
            this.extractable = extractable;
            return this.self();
        }

        public T featured(boolean featured) {
            this.featured = featured;
            return this.self();
        }

        public T isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this.self();
        }

        public T ready(boolean ready) {
            this.ready = ready;
            return this.self();
        }

        public T passwordEnabled(boolean passwordEnabled) {
            this.passwordEnabled = passwordEnabled;
            return this.self();
        }

        public T jobId(String jobId) {
            this.jobId = jobId;
            return this.self();
        }

        public T jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this.self();
        }

        public T checksum(String checksum) {
            this.checksum = checksum;
            return this.self();
        }

        public T hostId(String hostId) {
            this.hostId = hostId;
            return this.self();
        }

        public T hostName(String hostName) {
            this.hostName = hostName;
            return this.self();
        }

        public T sourceTemplateId(String sourceTemplateId) {
            this.sourceTemplateId = sourceTemplateId;
            return this.self();
        }

        public T templateTag(String templateTag) {
            this.templateTag = templateTag;
            return this.self();
        }

        public T tags(Set<Tag> tags) {
            this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this.self();
        }

        public T tags(Tag ... in) {
            return this.tags((Set<Tag>)ImmutableSet.copyOf((Object[])in));
        }

        public Template build() {
            return new Template(this.id, this.displayText, this.domain, this.domainId, this.account, this.accountId, this.zone, this.zoneId, this.OSType, this.OSTypeId, this.name, this.type, this.status, this.format, this.hypervisor, this.size, this.created, this.removed, this.crossZones, this.bootable, this.extractable, this.featured, this.isPublic, this.ready, this.passwordEnabled, this.jobId, this.jobStatus, this.checksum, this.hostId, this.hostName, this.sourceTemplateId, this.templateTag, this.tags);
        }

        public T fromTemplate(Template in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).displayText(in.getDisplayText())).domain(in.getDomain())).domainId(in.getDomainId())).account(in.getAccount())).accountId(in.getAccountId())).zone(in.getZone())).zoneId(in.getZoneId())).OSType(in.getOSType())).OSTypeId(in.getOSTypeId())).name(in.getName())).type(in.getType())).status(in.getStatus())).format(in.getFormat())).hypervisor(in.getHypervisor())).size(in.getSize())).created(in.getCreated())).removed(in.getRemoved())).crossZones(in.isCrossZones())).bootable(in.isBootable())).extractable(in.isExtractable())).featured(in.isFeatured())).isPublic(in.ispublic())).ready(in.isReady())).passwordEnabled(in.isPasswordEnabled())).jobId(in.getJobId())).jobStatus(in.getJobStatus())).checksum(in.getChecksum())).hostId(in.getHostId())).hostName(in.getHostName())).sourceTemplateId(in.getSourceTemplateId())).templateTag(in.getTemplateTag())).tags(in.getTags());
        }
    }

    public static enum Format {
        VHD,
        QCOW2,
        OVA,
        UNRECOGNIZED;


        public static Format fromValue(String format) {
            try {
                return Format.valueOf((String)Preconditions.checkNotNull((Object)format, (Object)"format"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Type {
        USER,
        BUILTIN,
        UNRECOGNIZED;


        public static Type fromValue(String type) {
            try {
                return Type.valueOf((String)Preconditions.checkNotNull((Object)type, (Object)"type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Status {
        UNKNOWN,
        ABANDONED,
        DOWNLOAD_ERROR,
        NOT_DOWNLOADED,
        DOWNLOAD_IN_PROGRESS,
        DOWNLOADED,
        UPLOADED,
        NOT_UPLOADED,
        UPLOAD_ERROR,
        UPLOAD_IN_PROGRESS,
        UNRECOGNIZED;


        public static Status fromValue(String state) {
            if (Strings.isNullOrEmpty((String)state)) {
                return UNKNOWN;
            }
            if (state.equals("Processing")) {
                return DOWNLOAD_IN_PROGRESS;
            }
            if (state.endsWith("% Downloaded")) {
                return DOWNLOAD_IN_PROGRESS;
            }
            if (state.equals("Installing Template")) {
                return DOWNLOAD_IN_PROGRESS;
            }
            if (state.equals("Installing ISO")) {
                return DOWNLOAD_IN_PROGRESS;
            }
            if (state.equals("Download Complete")) {
                return DOWNLOADED;
            }
            try {
                return Status.valueOf((String)Preconditions.checkNotNull((Object)state, (Object)"state"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

