/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.binders;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.openstack.nova.v2_0.domain.Console;
import org.jclouds.rest.binders.BindToJsonPayload;

@Singleton
public class BindConsoleToJsonPayload
extends BindToJsonPayload {
    @Inject
    public BindConsoleToJsonPayload(Json jsonBinder) {
        super(jsonBinder);
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        String action;
        Console.Type type = (Console.Type)((Object)postParams.get("type"));
        switch (type) {
            case NOVNC: 
            case XVPVNC: {
                action = "os-getVNCConsole";
                break;
            }
            case SPICE_HTML5: {
                action = "os-getSPICEConsole";
                break;
            }
            case RDP_HTML5: {
                action = "os-getRDPConsole";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + (Object)((Object)type));
            }
        }
        return this.bindToRequest(request, (Map<String, Object>)ImmutableMap.of((Object)action, (Object)ImmutableSortedMap.copyOf(postParams)));
    }
}

