/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.domain.internal;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.payloads.BaseMutableContentMetadata;
import org.jclouds.s3.domain.CanonicalUser;
import org.jclouds.s3.domain.MutableObjectMetadata;
import org.jclouds.s3.domain.ObjectMetadata;

public class MutableObjectMetadataImpl
implements MutableObjectMetadata {
    private String key;
    private String bucket;
    private URI uri;
    private Date lastModified;
    private String eTag;
    private CanonicalUser owner;
    private ObjectMetadata.StorageClass storageClass;
    private String cacheControl;
    private Map<String, String> userMetadata = Maps.newHashMap();
    private MutableContentMetadata contentMetadata;

    public MutableObjectMetadataImpl() {
        this.storageClass = ObjectMetadata.StorageClass.STANDARD;
        this.contentMetadata = new BaseMutableContentMetadata();
    }

    public MutableObjectMetadataImpl(ObjectMetadata from) {
        this.storageClass = ObjectMetadata.StorageClass.STANDARD;
        this.contentMetadata = new BaseMutableContentMetadata();
        HttpUtils.copy((ContentMetadata)from.getContentMetadata(), (MutableContentMetadata)this.contentMetadata);
        this.key = from.getKey();
        this.uri = from.getUri();
        this.bucket = from.getBucket();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public CanonicalUser getOwner() {
        return this.owner;
    }

    @Override
    public ObjectMetadata.StorageClass getStorageClass() {
        return this.storageClass;
    }

    @Override
    @Deprecated
    public String getCacheControl() {
        return this.contentMetadata.getCacheControl();
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    @Override
    public int compareTo(ObjectMetadata o) {
        return this == o ? 0 : this.getKey().compareTo(o.getKey());
    }

    @Override
    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    @Override
    @Deprecated
    public void setCacheControl(String cacheControl) {
        this.contentMetadata.setCacheControl(cacheControl);
    }

    @Override
    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public void setOwner(CanonicalUser owner) {
        this.owner = owner;
    }

    @Override
    public void setStorageClass(ObjectMetadata.StorageClass storageClass) {
        this.storageClass = storageClass;
    }

    @Override
    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    @Override
    public MutableContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }

    @Override
    public void setContentMetadata(MutableContentMetadata contentMetadata) {
        this.contentMetadata = contentMetadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableObjectMetadataImpl other = (MutableObjectMetadataImpl)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public String toString() {
        return String.format("[key=%s, bucket=%s, uri=%s, eTag=%s, cacheControl=%s, contentMetadata=%s, lastModified=%s, owner=%s, storageClass=%s, userMetadata=%s]", new Object[]{this.key, this.bucket, this.uri, this.eTag, this.cacheControl, this.contentMetadata, this.lastModified, this.owner, this.storageClass, this.userMetadata});
    }
}

