/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.effector.ParameterType;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.util.core.config.ConfigBag;

@Beta
public abstract class AddEffectorInitializerAbstractProto
extends EntityInitializers.InitializerPatternWithConfigKeys {
    public static final ConfigKey<String> EFFECTOR_NAME = ConfigKeys.newStringConfigKey("name");
    public static final ConfigKey<String> EFFECTOR_DESCRIPTION = ConfigKeys.newStringConfigKey("description");
    public static final ConfigKey<Map<String, Object>> EFFECTOR_PARAMETER_DEFS = new MapConfigKey<Object>(Object.class, "parameters");

    protected AddEffectorInitializerAbstractProto(ConfigBag params) {
        super(params);
    }

    protected AddEffectorInitializerAbstractProto() {
    }

    protected abstract Effector<?> effector();

    public void apply(EntityLocal entity) {
        ((EntityInternal)entity).getMutableEntityType().addEffector(this.effector());
    }

    public static ConfigBag getMergedParams(Effector<?> eff, ConfigBag params) {
        ConfigBag result = ConfigBag.newInstanceCopying(params);
        for (ParameterType param : eff.getParameters()) {
            ConfigKey key = Effectors.asConfigKey(param);
            if (result.containsKey(key)) continue;
            result.configure(key, params.get(key));
        }
        return result;
    }

    protected static <T> Effectors.EffectorBuilder<T> newEffectorBuilder(Class<T> type, ConfigBag params) {
        String name = (String)Preconditions.checkNotNull((Object)params.get(EFFECTOR_NAME), (String)"name must be supplied when defining an effector: %s", (Object)params);
        Effectors.EffectorBuilder eff = Effectors.effector(type, name);
        eff.description(params.get(EFFECTOR_DESCRIPTION));
        BrooklynClassLoadingContext loader = null;
        Effectors.parseParameters(params.get(EFFECTOR_PARAMETER_DEFS), loader).forEach(p -> eff.parameter((ParameterType<?>)p));
        return eff;
    }
}

