/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity.drivers.downloads;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.entity.drivers.downloads.DownloadResolver;
import org.apache.brooklyn.api.entity.drivers.downloads.DownloadResolverManager;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.entity.drivers.downloads.BasicDownloadRequirement;
import org.apache.brooklyn.core.entity.drivers.downloads.BasicDownloadResolver;
import org.apache.brooklyn.core.entity.drivers.downloads.DownloadProducerFromCloudsoftRepo;
import org.apache.brooklyn.core.entity.drivers.downloads.DownloadProducerFromLocalRepo;
import org.apache.brooklyn.core.entity.drivers.downloads.DownloadProducerFromProperties;
import org.apache.brooklyn.core.entity.drivers.downloads.DownloadProducerFromUrlAttribute;
import org.apache.brooklyn.core.entity.drivers.downloads.FilenameProducers;
import org.apache.brooklyn.util.text.Strings;

public class BasicDownloadsManager
implements DownloadResolverManager {
    private final List<Function<? super DownloadResolverManager.DownloadRequirement, ? extends DownloadResolverManager.DownloadTargets>> producers = Lists.newCopyOnWriteArrayList();
    private final List<Function<? super DownloadResolverManager.DownloadRequirement, String>> filenameProducers = Lists.newCopyOnWriteArrayList();

    public static BasicDownloadsManager newDefault(StringConfigMap config) {
        BasicDownloadsManager result = new BasicDownloadsManager();
        DownloadProducerFromLocalRepo localRepoProducer = new DownloadProducerFromLocalRepo(config);
        DownloadProducerFromProperties propertiesProducer = new DownloadProducerFromProperties(config);
        DownloadProducerFromUrlAttribute attributeProducer = new DownloadProducerFromUrlAttribute();
        DownloadProducerFromCloudsoftRepo cloudsoftRepoProducer = new DownloadProducerFromCloudsoftRepo(config);
        result.registerProducer(localRepoProducer);
        result.registerProducer(propertiesProducer);
        result.registerProducer(attributeProducer);
        result.registerProducer(cloudsoftRepoProducer);
        result.registerFilenameProducer(FilenameProducers.fromFilenameProperty());
        result.registerFilenameProducer(FilenameProducers.firstPrimaryTargetOf(propertiesProducer));
        result.registerFilenameProducer(FilenameProducers.firstPrimaryTargetOf(attributeProducer));
        return result;
    }

    public static BasicDownloadsManager newEmpty() {
        return new BasicDownloadsManager();
    }

    public void registerPrimaryProducer(Function<? super DownloadResolverManager.DownloadRequirement, ? extends DownloadResolverManager.DownloadTargets> producer) {
        this.producers.add(0, (Function<? super DownloadResolverManager.DownloadRequirement, ? extends DownloadResolverManager.DownloadTargets>)Preconditions.checkNotNull(producer, (Object)"resolver"));
    }

    public void registerProducer(Function<? super DownloadResolverManager.DownloadRequirement, ? extends DownloadResolverManager.DownloadTargets> producer) {
        this.producers.add((Function<? super DownloadResolverManager.DownloadRequirement, ? extends DownloadResolverManager.DownloadTargets>)Preconditions.checkNotNull(producer, (Object)"resolver"));
    }

    public void registerFilenameProducer(Function<? super DownloadResolverManager.DownloadRequirement, String> producer) {
        this.filenameProducers.add((Function<? super DownloadResolverManager.DownloadRequirement, String>)Preconditions.checkNotNull(producer, (Object)"producer"));
    }

    public DownloadResolver newDownloader(EntityDriver driver) {
        return this.newDownloader(new BasicDownloadRequirement(driver));
    }

    public DownloadResolver newDownloader(EntityDriver driver, Map<String, ?> properties) {
        return this.newDownloader(new BasicDownloadRequirement(driver, properties));
    }

    public DownloadResolver newDownloader(EntityDriver driver, String addonName, Map<String, ?> addonProperties) {
        return this.newDownloader(new BasicDownloadRequirement(driver, addonName, addonProperties));
    }

    private DownloadResolver newDownloader(DownloadResolverManager.DownloadRequirement req) {
        Function<? super DownloadResolverManager.DownloadRequirement, String> filenameProducer;
        String filename = null;
        Iterator<Function<? super DownloadResolverManager.DownloadRequirement, String>> iterator = this.filenameProducers.iterator();
        while (iterator.hasNext() && Strings.isBlank((CharSequence)(filename = (String)(filenameProducer = iterator.next()).apply((Object)req)))) {
        }
        Object wrappedReq = filename == null ? req : BasicDownloadRequirement.copy(req, ImmutableMap.of((Object)"filename", filename));
        ArrayList primaries = Lists.newArrayList();
        ArrayList fallbacks = Lists.newArrayList();
        for (Function<? super DownloadResolverManager.DownloadRequirement, ? extends DownloadResolverManager.DownloadTargets> producer : this.producers) {
            DownloadResolverManager.DownloadTargets vals = (DownloadResolverManager.DownloadTargets)producer.apply(wrappedReq);
            primaries.addAll(vals.getPrimaryLocations());
            fallbacks.addAll(vals.getFallbackLocations());
            if (vals.canContinueResolving()) continue;
            break;
        }
        LinkedHashSet result = Sets.newLinkedHashSet();
        result.addAll(primaries);
        result.addAll(fallbacks);
        if (result.isEmpty()) {
            throw new IllegalArgumentException("No downloads matched for " + req);
        }
        if (filename == null) {
            String target;
            Iterator iterator2 = result.iterator();
            while (iterator2.hasNext() && Strings.isBlank((CharSequence)(filename = FilenameProducers.inferFilename(target = (String)iterator2.next())))) {
            }
        }
        if (Strings.isBlank((CharSequence)filename)) {
            throw new IllegalArgumentException("No filenames matched for " + req + " (targets " + result + ")");
        }
        return new BasicDownloadResolver(result, filename);
    }
}

