/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location.cloud;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.location.cloud.AvailabilityZoneExtension;

@Beta
public abstract class AbstractAvailabilityZoneExtension
implements AvailabilityZoneExtension {
    protected final ManagementContext managementContext;
    protected final AtomicReference<List<Location>> subLocations = new AtomicReference();
    private final Object mutex = new Object();

    public AbstractAvailabilityZoneExtension(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    @Override
    public List<Location> getSubLocations(int max) {
        List<Location> all = this.getAllSubLocations();
        return all.subList(0, Math.min(max, all.size()));
    }

    @Override
    public List<Location> getSubLocationsByName(Predicate<? super String> namePredicate, int max) {
        ArrayList result = Lists.newArrayList();
        List<Location> all = this.getAllSubLocations();
        for (Location loc : all) {
            if (!this.isNameMatch(loc, namePredicate)) continue;
            result.add(loc);
        }
        return Collections.unmodifiableList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Location> getAllSubLocations() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.subLocations.get() == null) {
                List<Location> result = this.doGetAllSubLocations();
                this.subLocations.set((List<Location>)ImmutableList.copyOf(result));
            }
        }
        return this.subLocations.get();
    }

    protected abstract List<Location> doGetAllSubLocations();

    protected abstract boolean isNameMatch(Location var1, Predicate<? super String> var2);
}

