/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.entity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.framework.FrameworkLookup;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.resolve.entity.AbstractEntitySpecResolver;
import org.apache.brooklyn.core.resolve.entity.EntitySpecResolver;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.PropagatedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingEntitySpecResolver
extends AbstractEntitySpecResolver {
    private static final String RESOLVER_PREFIX_CATALOG = "catalog:";
    private static final String RESOLVER_PREFIX_JAVA = "java:";
    private static final Logger log = LoggerFactory.getLogger(DelegatingEntitySpecResolver.class);
    private static final String RESOLVER_NAME = "brooklyn";
    private Collection<EntitySpecResolver> resolvers;

    public DelegatingEntitySpecResolver(@Nonnull List<EntitySpecResolver> resolvers) {
        super(RESOLVER_NAME);
        this.resolvers = resolvers;
    }

    protected static ImmutableList<EntitySpecResolver> getRegisteredResolvers() {
        return ImmutableList.copyOf((Iterable)FrameworkLookup.lookupAll(EntitySpecResolver.class));
    }

    @Override
    public boolean accepts(String type, BrooklynClassLoadingContext loader) {
        return this.accepts("", type, loader) || this.accepts(RESOLVER_PREFIX_CATALOG, type, loader) || this.accepts(RESOLVER_PREFIX_JAVA, type, loader);
    }

    private boolean accepts(String prefix, String type, BrooklynClassLoadingContext loader) {
        for (EntitySpecResolver resolver : this.resolvers) {
            String localType = this.getLocalType(type);
            if (!resolver.accepts(prefix + localType, loader)) continue;
            return true;
        }
        return false;
    }

    @Override
    public EntitySpec<?> resolve(String type, BrooklynClassLoadingContext loader, Set<String> encounteredTypes) {
        String localType = this.getLocalType(type);
        EntitySpec<?> spec = this.resolve(this.resolvers, localType, loader, encounteredTypes);
        if (spec != null) {
            return spec;
        }
        spec = this.resolve(this.resolvers, RESOLVER_PREFIX_CATALOG + localType, loader, encounteredTypes);
        if (spec != null) {
            return spec;
        }
        return this.resolve(this.resolvers, RESOLVER_PREFIX_JAVA + localType, loader, encounteredTypes);
    }

    private EntitySpec<?> resolve(Collection<EntitySpecResolver> resolvers, String localType, BrooklynClassLoadingContext loader, Set<String> encounteredTypes) {
        ArrayList<String> resolversWhoDontSupport = new ArrayList<String>();
        ArrayList<PropagatedRuntimeException> otherProblemsFromResolvers = new ArrayList<PropagatedRuntimeException>();
        for (EntitySpecResolver resolver : resolvers) {
            if (!resolver.accepts(localType, loader)) continue;
            try {
                EntitySpec<?> spec = resolver.resolve(localType, loader, encounteredTypes);
                if (spec != null) {
                    return spec;
                }
                resolversWhoDontSupport.add(resolver.getName() + " (returned null)");
            }
            catch (Exception e) {
                otherProblemsFromResolvers.add(new PropagatedRuntimeException("Transformer for " + resolver.getName() + " gave an error creating this plan: ", Exceptions.collapseText((Throwable)e), (Throwable)e));
            }
        }
        if (!otherProblemsFromResolvers.isEmpty()) {
            if (BasicBrooklynCatalog.currentlyResolvingType.get() == null) {
                log.debug("Type " + localType + " could not be resolved; failure will be propagated (other transformers tried = " + resolversWhoDontSupport + "): " + otherProblemsFromResolvers);
            }
            throw otherProblemsFromResolvers.size() == 1 ? Exceptions.create(null, otherProblemsFromResolvers) : Exceptions.create((String)"ServiceSpecResolvers all failed", otherProblemsFromResolvers);
        }
        return null;
    }

    public String toString() {
        return this.getClass() + "[" + this.resolvers + "]";
    }
}

