/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.jackson;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.google.common.annotations.Beta;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.resolve.jackson.JacksonBetterDelegatingDeserializer;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynJacksonSerializationUtils {
    private static final Logger log = LoggerFactory.getLogger(BrooklynJacksonSerializationUtils.class);
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    public static final String DEFAULT = "default";

    @Beta
    public static JsonDeserializer<Object> createBeanDeserializer(DeserializationContext ctxt, JavaType t) throws JsonMappingException {
        return BrooklynJacksonSerializationUtils.createBeanDeserializer(ctxt, t, null, false, true);
    }

    @Beta
    public static JsonDeserializer<Object> createBeanDeserializer(DeserializationContext ctxt, JavaType t, BeanDescription optionalBeanDescription, boolean beanFactoryBuildPossible, boolean resolve) throws JsonMappingException {
        if (optionalBeanDescription == null) {
            optionalBeanDescription = ctxt.getConfig().introspect(t);
        }
        DeserializerFactory f = ctxt.getFactory();
        JsonDeserializer deser = beanFactoryBuildPossible || f instanceof BeanDeserializerFactory ? ((BeanDeserializerFactory)f).buildBeanDeserializer(ctxt, t, optionalBeanDescription) : ctxt.getFactory().createBeanDeserializer(ctxt, t, optionalBeanDescription);
        if (resolve && deser instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)deser).resolve(ctxt);
        }
        return deser;
    }

    static void dumpParser(String header, JsonParser p) {
        try {
            System.out.println(header);
            do {
                System.out.println(p.getCurrentToken() + " - " + p.currentName() + " - " + p.getValueAsString());
            } while (p.nextToken() != null);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    @Beta
    public static TokenBuffer createBufferForParserCurrentObject(JsonParser parser, DeserializationContext optionalCtxtForFeatures) throws IOException {
        TokenBuffer pb = new TokenBuffer(parser, optionalCtxtForFeatures);
        while (parser.currentToken() == JsonToken.FIELD_NAME) {
            pb.copyCurrentStructure(parser);
            parser.nextToken();
        }
        pb.copyCurrentStructure(parser);
        return pb;
    }

    public static JsonParser createParserFromTokenBufferAndParser(TokenBuffer tb, JsonParser p) throws IOException {
        JsonParserSequence pp = JsonParserSequence.createFlattened((boolean)false, (JsonParser)tb.asParser(p), (JsonParser)p);
        pp.nextToken();
        return pp;
    }

    public static Object readObject(DeserializationContext ctxt, JsonParser p) throws IOException {
        if (p.currentToken() == JsonToken.END_OBJECT) {
            return new Object();
        }
        return ctxt.findRootValueDeserializer(ctxt.constructType(Object.class)).deserialize(p, ctxt);
    }

    public static class JsonDeserializerForCommonBrooklynThings
    extends JacksonBetterDelegatingDeserializer {
        public static BiFunction<ManagementContext, Object, Object> BROOKLYN_PARSE_DSL_FUNCTION = null;
        private final ManagementContext mgmt;

        public JsonDeserializerForCommonBrooklynThings(ManagementContext mgmt, JsonDeserializer<?> delagatee) {
            super(delagatee, (JsonDeserializer<?> d) -> new JsonDeserializerForCommonBrooklynThings(mgmt, (JsonDeserializer<?>)d));
            this.mgmt = mgmt;
        }

        @Override
        protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
            if (newDelegatee instanceof RecontextualDeserializer) {
                newDelegatee = ((RecontextualDeserializer)newDelegatee).recreateContextual();
            }
            return super.newDelegatingInstance(newDelegatee);
        }

        public void resolve(DeserializationContext ctxt) throws JsonMappingException {
            try {
                super.resolve(ctxt);
            }
            catch (JsonMappingException e) {
                throw (JsonMappingException)new JsonMappingException(null, (Strings.isBlank((CharSequence)e.getMessage()) ? e.toString() : e.getMessage()) + (this.handledType() != null ? ", processing " + this.handledType() : ""), (JsonLocation)null).initCause((Throwable)e);
            }
        }

        @Override
        protected Object deserializeWrapper(JsonParser jp, DeserializationContext ctxt, JacksonBetterDelegatingDeserializer.BiFunctionThrowsIoException<JsonParser, DeserializationContext, Object> nestedDeserialize) throws IOException {
            String v = jp.getCurrentToken() == JsonToken.VALUE_STRING ? jp.getValueAsString() : null;
            try {
                Object result = nestedDeserialize.apply(jp, ctxt);
                if (BROOKLYN_PARSE_DSL_FUNCTION != null && this.mgmt != null && result instanceof Map) {
                    Map rm = (Map)result;
                    if (Object.class.equals((Object)this._valueClass) || this._valueClass == null) {
                        Object brooklynLiteral = rm.get("$brooklyn:literal");
                        if (brooklynLiteral != null) {
                            return BROOKLYN_PARSE_DSL_FUNCTION.apply(this.mgmt, brooklynLiteral);
                        }
                        Object type = rm.get(BrooklynJacksonSerializationUtils.TYPE);
                        if (type instanceof String && ((String)type).startsWith("org.apache.brooklyn.camp.brooklyn.spi.dsl.")) {
                            log.debug("Data " + result + " looks like DSL but has no literal entry; probably it is a nested DSL expression, or otherwise it may be left as a map after deserialization");
                        }
                    }
                }
                return result;
            }
            catch (Exception e) {
                Maybe coercion;
                if ((String.class.equals((Object)this._valueClass) || Boxing.isPrimitiveOrBoxedClass((Class)this._valueClass)) && v == null && jp.getCurrentToken() == JsonToken.END_OBJECT) {
                    try {
                        return this._valueClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e2) {
                        Exceptions.propagateIfFatal((Throwable)e2);
                    }
                }
                if (v != null && this.handledType() != null && (coercion = TypeCoercions.tryCoerce((Object)v, this.handledType())).isPresent()) {
                    return coercion.get();
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw Exceptions.propagate((Throwable)e);
            }
        }
    }

    static interface RecontextualDeserializer {
        public JsonDeserializer<?> recreateContextual();
    }

    public static class NestedLoggingDeserializer
    extends JacksonBetterDelegatingDeserializer {
        private final StringBuilder prefix;

        public NestedLoggingDeserializer(StringBuilder prefix, JsonDeserializer<?> deserializer) {
            super(deserializer, (JsonDeserializer<?> d) -> new NestedLoggingDeserializer(prefix, (JsonDeserializer<?>)d));
            this.prefix = prefix;
        }

        @Override
        protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
            this.prefix.append(".");
            try {
                JsonDeserializer jsonDeserializer = (JsonDeserializer)this.constructor.apply(newDelegatee);
                return jsonDeserializer;
            }
            finally {
                this.prefix.setLength(this.prefix.length() - 1);
            }
        }

        @Override
        protected Object deserializeWrapper(JsonParser jp, DeserializationContext ctxt, JacksonBetterDelegatingDeserializer.BiFunctionThrowsIoException<JsonParser, DeserializationContext, Object> nestedDeserialize) throws IOException {
            String v = jp.getCurrentToken() == JsonToken.VALUE_STRING ? jp.getValueAsString() : null;
            try {
                this.prefix.append("  ");
                log.info(this.prefix + "> " + jp.getCurrentToken());
                Object result = nestedDeserialize.apply(jp, ctxt);
                log.info(this.prefix + "< " + result);
                Object object = result;
                return object;
            }
            catch (Exception e) {
                log.info(this.prefix + "< " + e);
                throw e;
            }
            finally {
                this.prefix.setLength(this.prefix.length() - 2);
            }
        }
    }

    static class JsonDeserializerInvokingPostConstruct
    extends JacksonBetterDelegatingDeserializer {
        final List<Function<Object, Object>> postConstructFunctions;

        public JsonDeserializerInvokingPostConstruct(List<Function<Object, Object>> postConstructFunctions, JsonDeserializer<?> deserializer) {
            super(deserializer, (JsonDeserializer<?> d) -> new JsonDeserializerInvokingPostConstruct(postConstructFunctions, (JsonDeserializer<?>)d));
            this.postConstructFunctions = postConstructFunctions;
        }

        @Override
        protected Object deserializeWrapper(JsonParser jp, DeserializationContext ctxt, JacksonBetterDelegatingDeserializer.BiFunctionThrowsIoException<JsonParser, DeserializationContext, Object> nestedDeserialize) throws IOException {
            return this.postConstructFunctions.stream().reduce(Function::andThen).orElse(x -> x).apply(nestedDeserialize.apply(jp, ctxt));
        }
    }

    public static class ConfigurableBeanDeserializerModifier
    extends BeanDeserializerModifier {
        List<Function<JsonDeserializer<?>, JsonDeserializer<?>>> deserializerWrappers = MutableList.of();
        List<Function<Object, Object>> postConstructFunctions = MutableList.of();

        public ConfigurableBeanDeserializerModifier addDeserializerWrapper(Function<JsonDeserializer<?>, JsonDeserializer<?>> ... f) {
            for (Function<JsonDeserializer<?>, JsonDeserializer<?>> fi : f) {
                this.deserializerWrappers.add(fi);
            }
            return this;
        }

        public ConfigurableBeanDeserializerModifier addPostConstructFunction(Function<Object, Object> f) {
            this.postConstructFunctions.add(f);
            return this;
        }

        public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
            for (Function<JsonDeserializer<?>, JsonDeserializer<?>> d : this.deserializerWrappers) {
                deserializer = d.apply((JsonDeserializer<?>)deserializer);
            }
            if (!this.postConstructFunctions.isEmpty()) {
                deserializer = new JsonDeserializerInvokingPostConstruct(this.postConstructFunctions, (JsonDeserializer<?>)deserializer);
            }
            return deserializer;
        }

        public <T extends ObjectMapper> T apply(T mapper) {
            SimpleModule module = new SimpleModule();
            module.setDeserializerModifier((BeanDeserializerModifier)this);
            return (T)mapper.registerModule((Module)module);
        }
    }
}

