/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.appmodel;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.resolve.jackson.JsonPassThroughDeserializer;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.variables.SetVariableWorkflowStep;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;

public interface HasBlueprintWorkflowStep {
    public static final ConfigKey<Object> BLUEPRINT = ConfigKeys.newConfigKey(Object.class, "blueprint");
    public static final ConfigKey<String> TYPE = ConfigKeys.newStringConfigKey("type");
    public static final ConfigKey<SetVariableWorkflowStep.InterpolationMode> INTERPOLATION_MODE = ConfigKeys.newConfigKeyWithDefault(SetVariableWorkflowStep.INTERPOLATION_MODE, SetVariableWorkflowStep.InterpolationMode.FULL);
    public static final ConfigKey<TemplateProcessor.InterpolationErrorMode> INTERPOLATION_ERRORS = ConfigKeys.newConfigKeyWithDefault(SetVariableWorkflowStep.INTERPOLATION_ERRORS, TemplateProcessor.InterpolationErrorMode.IGNORE);

    public Map<String, Object> getInput();

    public Logger logger();

    default public void validateStepBlueprint(@Nullable ManagementContext mgmt, @Nullable WorkflowExecutionContext workflow) {
        boolean hasBlueprint = this.getInput().containsKey(BLUEPRINT.getName());
        boolean hasType = this.getInput().containsKey(TYPE.getName());
        if (!hasBlueprint && !hasType) {
            throw new IllegalArgumentException("A '" + BLUEPRINT.getName() + "' must be defined or a type supplied");
        }
        if (hasBlueprint && hasType) {
            throw new IllegalArgumentException("Cannot provide both a '" + BLUEPRINT.getName() + "' and a '" + TYPE.getName() + "'");
        }
    }

    default public Object resolveBlueprint(WorkflowStepInstanceExecutionContext context) {
        return this.resolveBlueprint(context, () -> {
            String type = context.getInput(TYPE);
            if (Strings.isBlank((CharSequence)type)) {
                throw new IllegalStateException("blueprint or type must be supplied");
            }
            return "type: " + StringEscapes.JavaStringEscapes.wrapJavaString((String)type);
        }, null, null);
    }

    default public Object resolveBlueprint(WorkflowStepInstanceExecutionContext context, Supplier<String> defaultValue, SetVariableWorkflowStep.InterpolationMode interpolationMode, TemplateProcessor.InterpolationErrorMode interpolationErrorMode) {
        Object blueprint = this.getInput().get(BLUEPRINT.getName());
        if (blueprint == null) {
            return defaultValue.get();
        }
        this.logger().debug("Blueprint (pre-resolution) is: " + blueprint);
        Object result = new SetVariableWorkflowStep.ConfigurableInterpolationEvaluation(context, null, blueprint, interpolationMode != null ? interpolationMode : context.getInputOrDefault(INTERPOLATION_MODE), interpolationErrorMode != null ? interpolationErrorMode : context.getInputOrDefault(INTERPOLATION_ERRORS)).evaluate();
        this.logger().debug("Blueprint (post-resolution: " + (Object)((Object)context.getInputOrDefault(INTERPOLATION_MODE)) + "/" + (Object)((Object)context.getInputOrDefault(INTERPOLATION_ERRORS)) + ") is: " + result);
        if (result instanceof String && ((String)result).matches("[^\\s]+")) {
            result = "type: " + StringEscapes.JavaStringEscapes.wrapJavaString((String)((String)result));
        }
        return result;
    }

    public <T> void setInput(ConfigKey<T> var1, T var2);

    @JsonDeserialize(using=JsonPassThroughDeserializer.class)
    default public void setBlueprint(Object blueprint) {
        this.setInput(BLUEPRINT, blueprint);
    }
}

