/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock;

import com.google.common.base.Function;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.enricher.stock.AbstractTransformer;
import org.apache.brooklyn.util.time.Duration;

@Catalog(name="YAML Rolling Average", description="Transforms sensor data into a rolling average based on a time window.")
public class YamlRollingTimeWindowMeanEnricher<T extends Number>
extends AbstractTransformer<T, Double> {
    public static ConfigKey<Duration> WINDOW_DURATION = ConfigKeys.newConfigKey(Duration.class, "enricher.window.duration", "Duration for which this window should store data, default one minute", Duration.ONE_MINUTE);
    public static ConfigKey<Double> CONFIDENCE_REQUIRED_TO_PUBLISH = ConfigKeys.newDoubleConfigKey("enricher.window.confidenceRequired", "Minimum confidence level (ie period covered) required to publish a rolling average", 0.8);
    private final LinkedList<T> values = new LinkedList();
    private final LinkedList<Long> timestamps = new LinkedList();
    volatile ConfidenceQualifiedNumber lastAverage = new ConfidenceQualifiedNumber(0.0, 0.0);

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.getRequiredConfig(SOURCE_SENSOR);
    }

    @Override
    protected Function<SensorEvent<T>, Double> getTransformation() {
        return new Function<SensorEvent<T>, Double>(){

            public Double apply(SensorEvent<T> event) {
                long eventTime = event.getTimestamp();
                if (event.getValue() == null) {
                    return null;
                }
                YamlRollingTimeWindowMeanEnricher.this.values.addLast(event.getValue());
                YamlRollingTimeWindowMeanEnricher.this.timestamps.addLast(eventTime);
                if (eventTime > 0L) {
                    ConfidenceQualifiedNumber average = YamlRollingTimeWindowMeanEnricher.this.getAverage(eventTime, 0L);
                    if (average.confidence > YamlRollingTimeWindowMeanEnricher.this.getConfig(CONFIDENCE_REQUIRED_TO_PUBLISH)) {
                        return average.value;
                    }
                }
                return null;
            }
        };
    }

    public ConfidenceQualifiedNumber getAverage(long fromTime, long graceAllowed) {
        if (this.timestamps.isEmpty()) {
            this.lastAverage = new ConfidenceQualifiedNumber(this.lastAverage.value, 0.0);
            return this.lastAverage;
        }
        long firstTimestamp = -1L;
        Iterator ti = this.timestamps.iterator();
        while (ti.hasNext() && (firstTimestamp = ((Long)ti.next()).longValue()) <= 0L) {
        }
        if (firstTimestamp <= 0L) {
            this.lastAverage = new ConfidenceQualifiedNumber(((Number)this.values.get(this.values.size() - 1)).doubleValue(), 0.0);
            return this.lastAverage;
        }
        long lastTimestamp = this.timestamps.get(this.timestamps.size() - 1);
        long now = fromTime;
        if (lastTimestamp > fromTime - graceAllowed) {
            now = lastTimestamp;
        }
        this.pruneValues(now);
        Duration timePeriod = this.getConfig(WINDOW_DURATION);
        long windowStart = Math.max(now - timePeriod.toMilliseconds(), firstTimestamp);
        long windowEnd = Math.max(now - timePeriod.toMilliseconds(), lastTimestamp);
        Double confidence = (double)(windowEnd - windowStart) / (double)timePeriod.toMilliseconds();
        if (confidence <= 1.0E-7) {
            double lastValue = ((Number)this.values.get(this.values.size() - 1)).doubleValue();
            this.lastAverage = new ConfidenceQualifiedNumber(lastValue, 0.0);
            return this.lastAverage;
        }
        long start = windowStart;
        double weightedAverage = 0.0;
        Iterator valuesIter = this.values.iterator();
        Iterator timestampsIter = this.timestamps.iterator();
        while (valuesIter.hasNext()) {
            Number val = (Number)valuesIter.next();
            Long timestamp = (Long)timestampsIter.next();
            if (val == null || timestamp < start) continue;
            long end = timestamp;
            weightedAverage += (double)(end - start) / (confidence * (double)timePeriod.toMilliseconds()) * val.doubleValue();
            start = timestamp;
        }
        this.lastAverage = new ConfidenceQualifiedNumber(weightedAverage, confidence);
        return this.lastAverage;
    }

    private void pruneValues(long now) {
        Duration timePeriod = this.getConfig(WINDOW_DURATION);
        while (this.timestamps.size() > 1 && this.timestamps.get(1) < now - timePeriod.toMilliseconds()) {
            this.timestamps.removeFirst();
            this.values.removeFirst();
        }
    }

    public static class ConfidenceQualifiedNumber {
        final Double value;
        final double confidence;

        public ConfidenceQualifiedNumber(Double value, double confidence) {
            this.value = value;
            this.confidence = confidence;
        }

        public String toString() {
            return "" + this.value + " (" + (int)(this.confidence * 100.0) + "%)";
        }
    }
}

