/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.logging.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.logging.Logger;

public class BindLoggersAnnotatedWithResource
implements TypeListener {
    private final Logger.LoggerFactory loggerFactory;

    @Inject
    public BindLoggersAnnotatedWithResource(Logger.LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
    }

    public <I> void hear(TypeLiteral<I> injectableType, TypeEncounter<I> encounter) {
        Class type = injectableType.getRawType();
        Set<Field> loggerFields = this.getLoggerFieldsAnnotatedWithResource(type);
        if (loggerFields.isEmpty()) {
            return;
        }
        Logger logger = this.loggerFactory.getLogger(type.getName());
        for (Field field : loggerFields) {
            if (field.isAnnotationPresent(Named.class)) {
                Named name = field.getAnnotation(Named.class);
                encounter.register(new AssignLoggerToField(this.loggerFactory.getLogger(name.value()), field));
                continue;
            }
            encounter.register(new AssignLoggerToField(logger, field));
        }
    }

    @VisibleForTesting
    Set<Field> getLoggerFieldsAnnotatedWithResource(Class<?> declaredType) {
        HashSet fields = Sets.newHashSet();
        for (Class<?> type = declaredType; type != null; type = type.getSuperclass()) {
            fields.addAll(Arrays.asList(type.getDeclaredFields()));
        }
        return Sets.filter((Set)fields, (Predicate)new LoggerFieldsAnnotatedWithResource());
    }

    static class LoggerFieldsAnnotatedWithResource
    implements Predicate<Field> {
        LoggerFieldsAnnotatedWithResource() {
        }

        public boolean apply(Field from) {
            Resource inject = from.getAnnotation(Resource.class);
            return inject != null && from.getType().isAssignableFrom(Logger.class);
        }
    }

    static class AssignLoggerToField<I>
    implements InjectionListener<I> {
        private final Logger logger;
        private final Field field;

        AssignLoggerToField(Logger logger, Field field) {
            this.logger = logger;
            this.field = field;
        }

        public void afterInjection(I injectee) {
            try {
                this.field.setAccessible(true);
                this.field.set(injectee, this.logger);
            }
            catch (IllegalAccessException e) {
                throw new ProvisionException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

