/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.http.executor;

import com.google.common.annotations.Beta;

@Beta
public class HttpConfig {
    private final boolean laxRedirect;
    private final boolean trustAll;
    private final boolean trustSelfSigned;

    public static Builder builder() {
        return new Builder();
    }

    protected HttpConfig() {
        this(HttpConfig.builder());
    }

    protected HttpConfig(Builder builder) {
        this.laxRedirect = builder.laxRedirect;
        this.trustAll = builder.trustAll;
        this.trustSelfSigned = builder.trustSelfSigned;
    }

    public boolean laxRedirect() {
        return this.laxRedirect;
    }

    public boolean trustAll() {
        return this.trustAll;
    }

    public boolean trustSelfSigned() {
        return this.trustSelfSigned;
    }

    @Beta
    public static class Builder {
        private boolean laxRedirect;
        private boolean trustAll;
        private boolean trustSelfSigned;

        public Builder laxRedirect(boolean val) {
            this.laxRedirect = val;
            return this;
        }

        public Builder trustAll(boolean val) {
            this.trustAll = val;
            return this;
        }

        public Builder trustSelfSigned(boolean val) {
            this.trustSelfSigned = val;
            return this;
        }

        public HttpConfig build() {
            return new HttpConfig(this);
        }
    }
}

