/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp.nginx;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;

public class UpstreamSyncPolicy
extends AbstractMembershipTrackingPolicy {
    public static ConfigKey<Entity> NGINX_NODE = ConfigKeys.newConfigKey(Entity.class, (String)"nginxNode");
    public static ConfigKey<String> GROUP_NAME = ConfigKeys.newStringConfigKey((String)"groupName");

    protected void onEntityEvent(AbstractMembershipTrackingPolicy.EventType type, Entity entity) {
        this.defaultHighlightAction(type, entity);
        Entity nginx = (Entity)this.config().get(NGINX_NODE);
        Boolean nginxIsUp = (Boolean)nginx.sensors().get(Startable.SERVICE_UP);
        if (!Boolean.TRUE.equals(nginxIsUp)) {
            return;
        }
        String groupName = (String)this.config().get(GROUP_NAME);
        List serverAddresses = this.getEntity().getChildren().stream().map(e -> {
            Boolean serviceUp = (Boolean)e.sensors().get(Startable.SERVICE_UP);
            String hostName = (String)e.sensors().get(Sensors.newStringSensor((String)"host.name"));
            String port = (String)e.sensors().get(Sensors.newStringSensor((String)"http.port"));
            if (!Boolean.TRUE.equals(serviceUp) || hostName == null || port == null) {
                return null;
            }
            return hostName + ":" + port;
        }).filter((Predicate<String>)Predicates.notNull()).collect(Collectors.toList());
        Maybe renderTargets = nginx.getEntityType().getEffectorByName("render-targets");
        Entities.invokeEffectorWithArgs((Entity)this.getEntity(), (Entity)nginx, (Effector)((Effector)renderTargets.get()), (Object[])new Object[]{groupName, Strings.join(serverAddresses, (String)" ")});
    }
}

