/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.brooklyn.core.catalog.internal;

import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;


public class CatalogEnricherItemDto extends CatalogItemDtoAbstract<Enricher,EnricherSpec<?>> {
    
    @Override
    public CatalogItemType getCatalogItemType() {
        return CatalogItemType.ENRICHER;
    }

    @Override
    public Class<Enricher> getCatalogItemJavaType() {
        return Enricher.class;
    }

    @SuppressWarnings({ "rawtypes", "unchecked" })
    @Override
    public Class<EnricherSpec<?>> getSpecType() {
        return (Class)EnricherSpec.class;
    }

}
