/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.brooklyn.core.internal;

import java.util.concurrent.atomic.AtomicBoolean;

import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.util.core.crypto.SecureKeys;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.net.Networking;

import com.google.common.annotations.Beta;

/** Various static initialization tasks are routed through this class,
 * to give us better traceability of their invocation. */ 
@Beta
public class BrooklynInitialization {

    private static AtomicBoolean done = new AtomicBoolean(false);
    
    public static void initTypeCoercionStandardAdapters() {
        TypeCoercions.initStandardAdapters();
    }

    public static void initSecureKeysBouncyCastleProvider() {
        SecureKeys.initBouncyCastleProvider();
    }

    public static void initNetworking() {
        Networking.init();
    }
    
    public static void initPortRanges() {
        PortRanges.init();
    }

    /* other things:
     * 
     * RendererHints - done by the entity classes which need them, including Sensors
     * 
     */
    
    public static void initAll() {
        if (done.compareAndSet(false, true)) {
            initTypeCoercionStandardAdapters();
            initSecureKeysBouncyCastleProvider();
            initNetworking();
            initPortRanges();
        }
    }

    public synchronized static void reinitAll() {
        done.set(false);
        initAll();
    }
}
