/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1alpha1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1alpha1"
	camelv1alpha1 "github.com/apache/camel-k/v2/pkg/client/camel/applyconfiguration/camel/v1alpha1"
	autoscalingv1 "k8s.io/api/autoscaling/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeKameletBindings implements KameletBindingInterface
type FakeKameletBindings struct {
	Fake *FakeCamelV1alpha1
	ns   string
}

var kameletbindingsResource = v1alpha1.SchemeGroupVersion.WithResource("kameletbindings")

var kameletbindingsKind = v1alpha1.SchemeGroupVersion.WithKind("KameletBinding")

// Get takes name of the kameletBinding, and returns the corresponding kameletBinding object, and an error if there is any.
func (c *FakeKameletBindings) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.KameletBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(kameletbindingsResource, c.ns, name), &v1alpha1.KameletBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.KameletBinding), err
}

// List takes label and field selectors, and returns the list of KameletBindings that match those selectors.
func (c *FakeKameletBindings) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.KameletBindingList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(kameletbindingsResource, kameletbindingsKind, c.ns, opts), &v1alpha1.KameletBindingList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.KameletBindingList{ListMeta: obj.(*v1alpha1.KameletBindingList).ListMeta}
	for _, item := range obj.(*v1alpha1.KameletBindingList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested kameletBindings.
func (c *FakeKameletBindings) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(kameletbindingsResource, c.ns, opts))

}

// Create takes the representation of a kameletBinding and creates it.  Returns the server's representation of the kameletBinding, and an error, if there is any.
func (c *FakeKameletBindings) Create(ctx context.Context, kameletBinding *v1alpha1.KameletBinding, opts v1.CreateOptions) (result *v1alpha1.KameletBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(kameletbindingsResource, c.ns, kameletBinding), &v1alpha1.KameletBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.KameletBinding), err
}

// Update takes the representation of a kameletBinding and updates it. Returns the server's representation of the kameletBinding, and an error, if there is any.
func (c *FakeKameletBindings) Update(ctx context.Context, kameletBinding *v1alpha1.KameletBinding, opts v1.UpdateOptions) (result *v1alpha1.KameletBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(kameletbindingsResource, c.ns, kameletBinding), &v1alpha1.KameletBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.KameletBinding), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeKameletBindings) UpdateStatus(ctx context.Context, kameletBinding *v1alpha1.KameletBinding, opts v1.UpdateOptions) (*v1alpha1.KameletBinding, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(kameletbindingsResource, "status", c.ns, kameletBinding), &v1alpha1.KameletBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.KameletBinding), err
}

// Delete takes name of the kameletBinding and deletes it. Returns an error if one occurs.
func (c *FakeKameletBindings) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(kameletbindingsResource, c.ns, name, opts), &v1alpha1.KameletBinding{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeKameletBindings) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(kameletbindingsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.KameletBindingList{})
	return err
}

// Patch applies the patch and returns the patched kameletBinding.
func (c *FakeKameletBindings) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.KameletBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(kameletbindingsResource, c.ns, name, pt, data, subresources...), &v1alpha1.KameletBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.KameletBinding), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied kameletBinding.
func (c *FakeKameletBindings) Apply(ctx context.Context, kameletBinding *camelv1alpha1.KameletBindingApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.KameletBinding, err error) {
	if kameletBinding == nil {
		return nil, fmt.Errorf("kameletBinding provided to Apply must not be nil")
	}
	data, err := json.Marshal(kameletBinding)
	if err != nil {
		return nil, err
	}
	name := kameletBinding.Name
	if name == nil {
		return nil, fmt.Errorf("kameletBinding.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(kameletbindingsResource, c.ns, *name, types.ApplyPatchType, data), &v1alpha1.KameletBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.KameletBinding), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeKameletBindings) ApplyStatus(ctx context.Context, kameletBinding *camelv1alpha1.KameletBindingApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.KameletBinding, err error) {
	if kameletBinding == nil {
		return nil, fmt.Errorf("kameletBinding provided to Apply must not be nil")
	}
	data, err := json.Marshal(kameletBinding)
	if err != nil {
		return nil, err
	}
	name := kameletBinding.Name
	if name == nil {
		return nil, fmt.Errorf("kameletBinding.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(kameletbindingsResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1alpha1.KameletBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.KameletBinding), err
}

// GetScale takes name of the kameletBinding, and returns the corresponding scale object, and an error if there is any.
func (c *FakeKameletBindings) GetScale(ctx context.Context, kameletBindingName string, options v1.GetOptions) (result *autoscalingv1.Scale, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetSubresourceAction(kameletbindingsResource, c.ns, "scale", kameletBindingName), &autoscalingv1.Scale{})

	if obj == nil {
		return nil, err
	}
	return obj.(*autoscalingv1.Scale), err
}

// UpdateScale takes the representation of a scale and updates it. Returns the server's representation of the scale, and an error, if there is any.
func (c *FakeKameletBindings) UpdateScale(ctx context.Context, kameletBindingName string, scale *autoscalingv1.Scale, opts v1.UpdateOptions) (result *autoscalingv1.Scale, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(kameletbindingsResource, "scale", c.ns, scale), &autoscalingv1.Scale{})

	if obj == nil {
		return nil, err
	}
	return obj.(*autoscalingv1.Scale), err
}
