/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// BuilderTaskApplyConfiguration represents a declarative configuration of the BuilderTask type for use
// with apply.
type BuilderTaskApplyConfiguration struct {
	BaseTaskApplyConfiguration `json:",inline"`
	BaseImage                  *string                           `json:"baseImage,omitempty"`
	Runtime                    *RuntimeSpecApplyConfiguration    `json:"runtime,omitempty"`
	Dependencies               []string                          `json:"dependencies,omitempty"`
	Steps                      []string                          `json:"steps,omitempty"`
	Maven                      *MavenBuildSpecApplyConfiguration `json:"maven,omitempty"`
	BuildDir                   *string                           `json:"buildDir,omitempty"`
	Sources                    []SourceSpecApplyConfiguration    `json:"sources,omitempty"`
	Git                        *GitConfigSpecApplyConfiguration  `json:"git,omitempty"`
}

// BuilderTaskApplyConfiguration constructs a declarative configuration of the BuilderTask type for use with
// apply.
func BuilderTask() *BuilderTaskApplyConfiguration {
	return &BuilderTaskApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *BuilderTaskApplyConfiguration) WithName(value string) *BuilderTaskApplyConfiguration {
	b.BaseTaskApplyConfiguration.Name = &value
	return b
}

// WithConfiguration sets the Configuration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Configuration field is set to the value of the last call.
func (b *BuilderTaskApplyConfiguration) WithConfiguration(value *BuildConfigurationApplyConfiguration) *BuilderTaskApplyConfiguration {
	b.BaseTaskApplyConfiguration.Configuration = value
	return b
}

// WithBaseImage sets the BaseImage field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BaseImage field is set to the value of the last call.
func (b *BuilderTaskApplyConfiguration) WithBaseImage(value string) *BuilderTaskApplyConfiguration {
	b.BaseImage = &value
	return b
}

// WithRuntime sets the Runtime field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Runtime field is set to the value of the last call.
func (b *BuilderTaskApplyConfiguration) WithRuntime(value *RuntimeSpecApplyConfiguration) *BuilderTaskApplyConfiguration {
	b.Runtime = value
	return b
}

// WithDependencies adds the given value to the Dependencies field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Dependencies field.
func (b *BuilderTaskApplyConfiguration) WithDependencies(values ...string) *BuilderTaskApplyConfiguration {
	for i := range values {
		b.Dependencies = append(b.Dependencies, values[i])
	}
	return b
}

// WithSteps adds the given value to the Steps field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Steps field.
func (b *BuilderTaskApplyConfiguration) WithSteps(values ...string) *BuilderTaskApplyConfiguration {
	for i := range values {
		b.Steps = append(b.Steps, values[i])
	}
	return b
}

// WithMaven sets the Maven field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Maven field is set to the value of the last call.
func (b *BuilderTaskApplyConfiguration) WithMaven(value *MavenBuildSpecApplyConfiguration) *BuilderTaskApplyConfiguration {
	b.Maven = value
	return b
}

// WithBuildDir sets the BuildDir field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BuildDir field is set to the value of the last call.
func (b *BuilderTaskApplyConfiguration) WithBuildDir(value string) *BuilderTaskApplyConfiguration {
	b.BuildDir = &value
	return b
}

// WithSources adds the given value to the Sources field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Sources field.
func (b *BuilderTaskApplyConfiguration) WithSources(values ...*SourceSpecApplyConfiguration) *BuilderTaskApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithSources")
		}
		b.Sources = append(b.Sources, *values[i])
	}
	return b
}

// WithGit sets the Git field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Git field is set to the value of the last call.
func (b *BuilderTaskApplyConfiguration) WithGit(value *GitConfigSpecApplyConfiguration) *BuilderTaskApplyConfiguration {
	b.Git = value
	return b
}
