/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// CamelArtifactApplyConfiguration represents a declarative configuration of the CamelArtifact type for use
// with apply.
type CamelArtifactApplyConfiguration struct {
	CamelArtifactDependencyApplyConfiguration `json:",inline"`
	Schemes                                   []CamelSchemeApplyConfiguration             `json:"schemes,omitempty"`
	Languages                                 []string                                    `json:"languages,omitempty"`
	DataFormats                               []string                                    `json:"dataformats,omitempty"`
	Dependencies                              []CamelArtifactDependencyApplyConfiguration `json:"dependencies,omitempty"`
	JavaTypes                                 []string                                    `json:"javaTypes,omitempty"`
}

// CamelArtifactApplyConfiguration constructs a declarative configuration of the CamelArtifact type for use with
// apply.
func CamelArtifact() *CamelArtifactApplyConfiguration {
	return &CamelArtifactApplyConfiguration{}
}

// WithGroupID sets the GroupID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GroupID field is set to the value of the last call.
func (b *CamelArtifactApplyConfiguration) WithGroupID(value string) *CamelArtifactApplyConfiguration {
	b.MavenArtifactApplyConfiguration.GroupID = &value
	return b
}

// WithArtifactID sets the ArtifactID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ArtifactID field is set to the value of the last call.
func (b *CamelArtifactApplyConfiguration) WithArtifactID(value string) *CamelArtifactApplyConfiguration {
	b.MavenArtifactApplyConfiguration.ArtifactID = &value
	return b
}

// WithType sets the Type field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Type field is set to the value of the last call.
func (b *CamelArtifactApplyConfiguration) WithType(value string) *CamelArtifactApplyConfiguration {
	b.MavenArtifactApplyConfiguration.Type = &value
	return b
}

// WithVersion sets the Version field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Version field is set to the value of the last call.
func (b *CamelArtifactApplyConfiguration) WithVersion(value string) *CamelArtifactApplyConfiguration {
	b.MavenArtifactApplyConfiguration.Version = &value
	return b
}

// WithClassifier sets the Classifier field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Classifier field is set to the value of the last call.
func (b *CamelArtifactApplyConfiguration) WithClassifier(value string) *CamelArtifactApplyConfiguration {
	b.MavenArtifactApplyConfiguration.Classifier = &value
	return b
}

// WithExclusions adds the given value to the Exclusions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Exclusions field.
func (b *CamelArtifactApplyConfiguration) WithExclusions(values ...*CamelArtifactExclusionApplyConfiguration) *CamelArtifactApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithExclusions")
		}
		b.CamelArtifactDependencyApplyConfiguration.Exclusions = append(b.CamelArtifactDependencyApplyConfiguration.Exclusions, *values[i])
	}
	return b
}

// WithSchemes adds the given value to the Schemes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Schemes field.
func (b *CamelArtifactApplyConfiguration) WithSchemes(values ...*CamelSchemeApplyConfiguration) *CamelArtifactApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithSchemes")
		}
		b.Schemes = append(b.Schemes, *values[i])
	}
	return b
}

// WithLanguages adds the given value to the Languages field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Languages field.
func (b *CamelArtifactApplyConfiguration) WithLanguages(values ...string) *CamelArtifactApplyConfiguration {
	for i := range values {
		b.Languages = append(b.Languages, values[i])
	}
	return b
}

// WithDataFormats adds the given value to the DataFormats field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the DataFormats field.
func (b *CamelArtifactApplyConfiguration) WithDataFormats(values ...string) *CamelArtifactApplyConfiguration {
	for i := range values {
		b.DataFormats = append(b.DataFormats, values[i])
	}
	return b
}

// WithDependencies adds the given value to the Dependencies field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Dependencies field.
func (b *CamelArtifactApplyConfiguration) WithDependencies(values ...*CamelArtifactDependencyApplyConfiguration) *CamelArtifactApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithDependencies")
		}
		b.Dependencies = append(b.Dependencies, *values[i])
	}
	return b
}

// WithJavaTypes adds the given value to the JavaTypes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the JavaTypes field.
func (b *CamelArtifactApplyConfiguration) WithJavaTypes(values ...string) *CamelArtifactApplyConfiguration {
	for i := range values {
		b.JavaTypes = append(b.JavaTypes, values[i])
	}
	return b
}
