/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class DbEntityValidator
extends ConfigurationNodeValidator {
    DbEntityValidator() {
    }

    void validate(DbEntity entity, ValidationResult validationResult) {
        this.validateName(entity, validationResult);
        this.validateAttributes(entity, validationResult);
        this.validatePK(entity, validationResult);
    }

    void validatePK(DbEntity entity, ValidationResult validationResult) {
        DataMap map;
        if (entity.getAttributes().size() > 0 && entity.getPrimaryKeys().size() == 0 && (map = entity.getDataMap()) != null && map.getMappedEntities(entity).size() > 0) {
            this.addFailure(validationResult, entity, "DbEntity '%s' has no primary key attributes defined", entity.getName());
        }
    }

    void validateAttributes(DbEntity entity, ValidationResult validationResult) {
        if (entity.getAttributes().size() == 0) {
            this.addFailure(validationResult, entity, "DbEntity '%s' has no attributes defined", entity.getName());
        }
    }

    void validateName(DbEntity entity, ValidationResult validationResult) {
        String name = entity.getName();
        if (Util.isEmptyString((CharSequence)name)) {
            this.addFailure(validationResult, entity, "Unnamed DbEntity", new Object[0]);
            return;
        }
        DataMap map = entity.getDataMap();
        if (map == null) {
            return;
        }
        for (DbEntity otherEntity : map.getDbEntities()) {
            if (otherEntity == entity || !name.equals(otherEntity.getName())) continue;
            this.addFailure(validationResult, entity, "Duplicate DbEntity name: %s", name);
            break;
        }
    }
}

