/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryMetadataProxy;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;

class IncrementalSelectQuery<T>
extends SelectQuery<T> {
    private SelectQuery<T> query;
    private String cacheKey;

    IncrementalSelectQuery(SelectQuery<T> delegate, String cacheKey) {
        this.query = delegate;
        this.cacheKey = cacheKey;
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        QueryMetadata metadata = this.query.getMetaData(resolver);
        return new QueryMetadataProxy(metadata){

            public Query getOriginatingQuery() {
                return null;
            }

            public String getCacheKey() {
                return IncrementalSelectQuery.this.cacheKey;
            }
        };
    }

    public void addOrdering(Ordering ordering) {
        this.query.addOrdering(ordering);
    }

    public void addOrdering(String sortPathSpec, SortOrder order) {
        this.query.addOrdering(sortPathSpec, order);
    }

    public void addOrderings(Collection<? extends Ordering> orderings) {
        this.query.addOrderings(orderings);
    }

    public PrefetchTreeNode addPrefetch(String prefetchPath) {
        return this.query.addPrefetch(prefetchPath);
    }

    public void andQualifier(Expression e) {
        this.query.andQualifier(e);
    }

    public void clearOrderings() {
        this.query.clearOrderings();
    }

    public void clearPrefetches() {
        this.query.clearPrefetches();
    }

    public SelectQuery<T> createQuery(Map<String, ?> parameters) {
        return this.query.createQuery(parameters);
    }

    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        return this.query.createSQLAction(visitor);
    }

    public boolean equals(Object obj) {
        return this.query.equals(obj);
    }

    public String getCacheGroup() {
        return super.getCacheGroup();
    }

    public int getFetchLimit() {
        return this.query.getFetchLimit();
    }

    public List<Ordering> getOrderings() {
        return this.query.getOrderings();
    }

    public int getPageSize() {
        return this.query.getPageSize();
    }

    public PrefetchTreeNode getPrefetchTree() {
        return this.query.getPrefetchTree();
    }

    public Expression getQualifier() {
        return this.query.getQualifier();
    }

    public Object getRoot() {
        return this.query.getRoot();
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    public void initWithProperties(Map<String, ?> properties) {
        this.query.initWithProperties(properties);
    }

    public boolean isDistinct() {
        return this.query.isDistinct();
    }

    public boolean isFetchingDataRows() {
        return this.query.isFetchingDataRows();
    }

    public void orQualifier(Expression e) {
        this.query.orQualifier(e);
    }

    public SelectQuery<T> queryWithParameters(Map<String, ?> parameters, boolean pruneMissing) {
        return this.query.queryWithParameters(parameters, pruneMissing);
    }

    public SelectQuery<T> queryWithParameters(Map<String, ?> parameters) {
        return this.query.queryWithParameters(parameters);
    }

    public void removeOrdering(Ordering ordering) {
        this.query.removeOrdering(ordering);
    }

    public void removePrefetch(String prefetchPath) {
        this.query.removePrefetch(prefetchPath);
    }

    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        this.query.route(router, resolver, substitutedQuery);
    }

    public void setCacheGroup(String cacheGroup) {
        this.query.setCacheGroup(cacheGroup);
    }

    public void setDistinct(boolean distinct) {
        this.query.setDistinct(distinct);
    }

    public void setFetchingDataRows(boolean flag) {
        this.query.setFetchingDataRows(flag);
    }

    public void setFetchLimit(int fetchLimit) {
        this.query.setFetchLimit(fetchLimit);
    }

    public void setPageSize(int pageSize) {
        this.query.setPageSize(pageSize);
    }

    public void setPrefetchTree(PrefetchTreeNode prefetchTree) {
        this.query.setPrefetchTree(prefetchTree);
    }

    public void setQualifier(Expression qualifier) {
        this.query.setQualifier(qualifier);
    }

    public void setRoot(Object value) {
        this.query.setRoot(value);
    }

    public String toString() {
        return this.query.toString();
    }

    public List<T> select(ObjectContext context) {
        return this.query.select(context);
    }

    public T selectOne(ObjectContext context) {
        return (T)this.query.selectOne(context);
    }

    public T selectFirst(ObjectContext context) {
        return (T)this.query.selectFirst(context);
    }

    public void iterate(ObjectContext context, ResultIteratorCallback<T> callback) {
        this.query.iterate(context, callback);
    }

    public ResultIterator<T> iterator(ObjectContext context) {
        return this.query.iterator(context);
    }

    public ResultBatchIterator<T> batchIterator(ObjectContext context, int size) {
        return this.query.batchIterator(context, size);
    }
}

