/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dbsync.merge.AbstractMerger;
import org.apache.cayenne.dbsync.merge.DbRelationshipDictionary;
import org.apache.cayenne.dbsync.merge.MergerDictionaryDiff;
import org.apache.cayenne.dbsync.merge.MergerDiffPair;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;

public class DbRelationshipMerger
extends AbstractMerger<DbEntity, DbRelationship> {
    private final boolean skipRelationshipsTokens;
    private final FiltersConfig filtersConfig;

    DbRelationshipMerger(MergerTokenFactory tokenFactory, boolean skipRelationshipsTokens, FiltersConfig filtersConfig) {
        super(tokenFactory);
        this.skipRelationshipsTokens = skipRelationshipsTokens;
        this.filtersConfig = filtersConfig;
    }

    @Override
    MergerDictionaryDiff<DbRelationship> createDiff(DbEntity original, DbEntity imported) {
        return new MergerDictionaryDiff.Builder<DbRelationship>().originalDictionary(new DbRelationshipDictionary(original, this.filtersConfig)).importedDictionary(new DbRelationshipDictionary(imported, this.filtersConfig)).build();
    }

    private DbEntity getOriginalSourceDbEntity(DbRelationship relationship) {
        return (DbEntity)this.getOriginalDictionary().getByName(relationship.getSourceEntity().getName().toUpperCase());
    }

    private DbEntity getOriginalTargetDbEntity(DbRelationship relationship) {
        return (DbEntity)this.getOriginalDictionary().getByName(relationship.getTargetEntityName().toUpperCase());
    }

    @Override
    Collection<MergerToken> createTokensForMissingOriginal(DbRelationship imported) {
        DbEntity originalDbEntity = this.getOriginalSourceDbEntity(imported);
        DbEntity targetEntity = this.getOriginalTargetDbEntity(imported);
        if (targetEntity != null) {
            imported.setTargetEntityName((Entity)targetEntity);
        }
        imported.setSourceEntity((Entity)originalDbEntity);
        for (DbJoin join : imported.getJoins()) {
            DbAttribute targetAttr;
            DbAttribute sourceAttr = this.findDbAttribute(originalDbEntity, join.getSourceName());
            if (sourceAttr != null) {
                join.setSourceName(sourceAttr.getName());
            }
            if ((targetAttr = this.findDbAttribute(targetEntity, join.getTargetName())) == null) continue;
            join.setTargetName(targetAttr.getName());
        }
        MergerToken token = this.getTokenFactory().createDropRelationshipToDb(originalDbEntity, imported);
        return Collections.singleton(token);
    }

    @Override
    Collection<MergerToken> createTokensForMissingImported(DbRelationship original) {
        if (this.skipRelationshipsTokens) {
            return null;
        }
        DbEntity originalDbEntity = this.getOriginalSourceDbEntity(original);
        MergerToken token = this.getTokenFactory().createAddRelationshipToDb(originalDbEntity, original);
        return Collections.singleton(token);
    }

    @Override
    Collection<MergerToken> createTokensForSame(MergerDiffPair<DbRelationship> same) {
        return null;
    }

    private DbAttribute findDbAttribute(DbEntity entity, String caseInsensitiveName) {
        if (entity == null) {
            return null;
        }
        for (DbAttribute a : entity.getAttributes()) {
            if (!a.getName().equalsIgnoreCase(caseInsensitiveName)) continue;
            return a;
        }
        return null;
    }

    @Override
    public List<MergerToken> createMergeTokens() {
        throw new UnsupportedOperationException();
    }
}

