/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.GeneratedMessageV3;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.meta.DiskFileInfo;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.meta.MemoryFileInfo;
import org.apache.celeborn.common.meta.ReduceFileMeta;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.protocol.PartitionSplitMode;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.service.deploy.worker.WorkerSource;
import org.apache.celeborn.service.deploy.worker.congestcontrol.CongestionController;
import org.apache.celeborn.service.deploy.worker.congestcontrol.UserCongestionControlContext;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor;
import org.apache.celeborn.service.deploy.worker.storage.DeviceObserver;
import org.apache.celeborn.service.deploy.worker.storage.DfsTierWriter;
import org.apache.celeborn.service.deploy.worker.storage.FlushNotifier;
import org.apache.celeborn.service.deploy.worker.storage.Flusher;
import org.apache.celeborn.service.deploy.worker.storage.LocalFlusher;
import org.apache.celeborn.service.deploy.worker.storage.MemoryTierWriter;
import org.apache.celeborn.service.deploy.worker.storage.PartitionDataWriterContext;
import org.apache.celeborn.service.deploy.worker.storage.PartitionMetaHandler;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.apache.celeborn.service.deploy.worker.storage.TierWriterBase;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class PartitionDataWriter
implements DeviceObserver {
    private static final Logger logger = LoggerFactory.getLogger(PartitionDataWriter.class);
    private final long splitThreshold;
    private final PartitionSplitMode splitMode;
    private final long memoryFileStorageMaxFileSize;
    private final AtomicInteger numPendingWrites = new AtomicInteger(0);
    private final PartitionDataWriterContext writerContext;
    protected final AbstractSource source;
    private final String writerString;
    private final StorageManager storageManager;
    private final FlushNotifier notifier = new FlushNotifier();
    private UserCongestionControlContext userCongestionControlContext = null;
    private volatile TierWriterBase currentTierWriter;

    public PartitionDataWriter(StorageManager storageManager, AbstractSource workerSource, CelebornConf conf, DeviceMonitor deviceMonitor, PartitionDataWriterContext writerContext) {
        this.memoryFileStorageMaxFileSize = conf.workerMemoryFileStorageMaxFileSize();
        this.writerContext = writerContext;
        this.source = workerSource;
        this.storageManager = storageManager;
        this.splitThreshold = writerContext.getSplitThreshold();
        this.splitMode = writerContext.getPartitionSplitMode();
        String shuffleKey = writerContext.getShuffleKey();
        String filename = writerContext.getPartitionLocation().getFileName();
        this.writerString = shuffleKey + "-" + filename + "-partition-writer";
        logger.debug("FileWriter {} split threshold {} mode {}", new Object[]{this, this.splitThreshold, this.splitMode});
        if (CongestionController.instance() != null) {
            this.userCongestionControlContext = CongestionController.instance().getUserCongestionContext(writerContext.getUserIdentifier());
        }
        writerContext.setPartitionDataWriter(this);
        writerContext.setDeviceMonitor(deviceMonitor);
        this.currentTierWriter = storageManager.storagePolicy().createFileWriter(writerContext, this.numPendingWrites, this.notifier);
    }

    public DiskFileInfo getDiskFileInfo() {
        FileInfo currentFileInfo = this.currentTierWriter.fileInfo();
        if (currentFileInfo instanceof DiskFileInfo) {
            return (DiskFileInfo)currentFileInfo;
        }
        return null;
    }

    public String getFilePath() {
        DiskFileInfo diskFileInfo = this.getDiskFileInfo();
        if (diskFileInfo != null) {
            return diskFileInfo.getFilePath();
        }
        return "";
    }

    public void incrementPendingWrites() {
        this.numPendingWrites.incrementAndGet();
    }

    public void decrementPendingWrites() {
        this.numPendingWrites.decrementAndGet();
    }

    @VisibleForTesting
    public synchronized void flush() {
        this.currentTierWriter.flush(false, false);
    }

    public synchronized boolean needHardSplitForMemoryShuffleStorage() {
        if (!(this.currentTierWriter instanceof MemoryTierWriter)) {
            return false;
        }
        return !this.storageManager.localOrDfsStorageAvailable() && (this.currentTierWriter.fileInfo().getFileLength() > this.memoryFileStorageMaxFileSize || !MemoryManager.instance().memoryFileStorageAvailable());
    }

    public synchronized void write(ByteBuf data) throws IOException {
        if (this.currentTierWriter.needEvict()) {
            this.evict(false);
        }
        this.currentTierWriter.write(data);
    }

    public RoaringBitmap getMapIdBitMap() {
        Option<RoaringBitmap> bitmapOpt = this.currentTierWriter.metaHandler().getMapIdBitmap();
        if (bitmapOpt.isDefined()) {
            return (RoaringBitmap)bitmapOpt.get();
        }
        return null;
    }

    public StorageInfo getStorageInfo() {
        StorageInfo storageInfo = null;
        FileInfo fileInfo = this.currentTierWriter.fileInfo();
        if (fileInfo instanceof DiskFileInfo) {
            DiskFileInfo diskFileInfo = (DiskFileInfo)fileInfo;
            if (diskFileInfo.isDFS()) {
                if (((DfsTierWriter)this.currentTierWriter).deleted()) {
                    return null;
                }
                storageInfo = diskFileInfo.isS3() ? new StorageInfo(StorageInfo.Type.S3, true, diskFileInfo.getFilePath()) : (diskFileInfo.isOSS() ? new StorageInfo(StorageInfo.Type.OSS, true, diskFileInfo.getFilePath()) : new StorageInfo(StorageInfo.Type.HDFS, true, diskFileInfo.getFilePath()));
            } else {
                LocalFlusher flusher = (LocalFlusher)this.currentTierWriter.getFlusher();
                storageInfo = new StorageInfo(flusher.diskType(), true, "");
            }
        } else if (fileInfo instanceof MemoryFileInfo) {
            storageInfo = new StorageInfo(StorageInfo.Type.MEMORY, true, "");
        }
        if (storageInfo != null && this.currentTierWriter.fileInfo().getFileMeta() instanceof ReduceFileMeta) {
            storageInfo.setFileSize(this.currentTierWriter.fileInfo().getFileLength());
            storageInfo.setChunkOffsets(((ReduceFileMeta)this.currentTierWriter.fileInfo().getFileMeta()).getChunkOffsets());
        }
        return storageInfo;
    }

    public boolean isClosed() {
        return this.currentTierWriter.closed();
    }

    public synchronized void evict(boolean checkClose) {
        if (checkClose && this.currentTierWriter.closed()) {
            return;
        }
        TierWriterBase newTierWriter = this.storageManager.storagePolicy().getEvictedFileWriter(this.currentTierWriter, this.writerContext, this.numPendingWrites, this.notifier);
        this.currentTierWriter.evict(newTierWriter);
        this.currentTierWriter = newTierWriter;
    }

    public synchronized void destroy(IOException ioException) {
        this.currentTierWriter.destroy(ioException);
    }

    public synchronized long close() {
        long length = this.currentTierWriter.close();
        this.source.updateHistogram(WorkerSource.PARTITION_FILE_SIZE(), length);
        return length;
    }

    public FileInfo getCurrentFileInfo() {
        return this.currentTierWriter.fileInfo();
    }

    public IOException getException() {
        if (this.notifier.hasException()) {
            return this.notifier.exception.get();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionDataWriter that = (PartitionDataWriter)o;
        return Objects.equals(this.writerString, that.writerString);
    }

    public int hashCode() {
        return Objects.hashCode(this.writerString);
    }

    public String toString() {
        return this.writerString;
    }

    public void flushOnMemoryPressure() throws IOException {
        this.flush();
    }

    public long getSplitThreshold() {
        return this.splitThreshold;
    }

    public PartitionSplitMode getSplitMode() {
        return this.splitMode;
    }

    @Override
    public void notifyError(String mountPoint, DiskStatus diskStatus) {
        this.destroy(new IOException("Destroy FileWriter " + this + " by device ERROR. Disk: " + mountPoint + " Status: " + diskStatus));
    }

    @Override
    public void notifyHealthy(String mountPoint) {
    }

    @Override
    public void notifyHighDiskUsage(String mountPoint) {
    }

    @Override
    public void notifyNonCriticalError(String mountPoint, DiskStatus diskStatus) {
    }

    public MemoryFileInfo getMemoryFileInfo() {
        return (MemoryFileInfo)this.currentTierWriter.fileInfo();
    }

    public UserCongestionControlContext getUserCongestionControlContext() {
        return this.userCongestionControlContext;
    }

    public void handleEvents(GeneratedMessageV3 message) {
        this.currentTierWriter.metaHandler().handleEvent(message);
    }

    public PartitionMetaHandler getMetaHandler() {
        return this.currentTierWriter.metaHandler();
    }

    public Flusher getFlusher() {
        return this.currentTierWriter.getFlusher();
    }
}

