/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.plugin.flink.AbstractRemoteShuffleInputGate;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentProvider;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.LocalConnectionManager;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferDecompressor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.metrics.groups.ShuffleIOMetricGroup;
import org.apache.flink.runtime.shuffle.ShuffleIOOwnerContext;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.throughput.ThroughputCalculator;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.apache.flink.util.function.SupplierWithException;

public class RemoteShuffleInputGate
extends AbstractRemoteShuffleInputGate {
    private final ResultPartitionType consumedPartitionType;

    public RemoteShuffleInputGate(CelebornConf celebornConf, ShuffleIOOwnerContext ownerContext, int gateIndex, InputGateDeploymentDescriptor gateDescriptor, SupplierWithException<BufferPool, IOException> bufferPoolFactory, BufferDecompressor bufferDecompressor, int numConcurrentReading, Map<Integer, ShuffleIOMetricGroup> shuffleIOMetricGroups) {
        super(celebornConf, ownerContext, gateIndex, gateDescriptor, bufferPoolFactory, bufferDecompressor, numConcurrentReading, shuffleIOMetricGroups);
        this.consumedPartitionType = gateDescriptor.getConsumedPartitionType();
    }

    @Override
    public InputChannel getChannel(int channelIndex) {
        return new FakedRemoteInputChannel(channelIndex);
    }

    @Override
    public Tuple2<Integer, Integer> getConsumedSubpartitionIndexRange(InputGateDeploymentDescriptor gateDescriptor) {
        IndexRange indexRange = gateDescriptor.getConsumedSubpartitionIndexRange();
        return Tuple2.of((Object)indexRange.getStartIndex(), (Object)indexRange.getEndIndex());
    }

    public ResultPartitionType getConsumedPartitionType() {
        return this.consumedPartitionType;
    }

    private static class FakedChannelStateWriter
    implements ChannelStateWriter {
        private FakedChannelStateWriter() {
        }

        public void start(long cpId, CheckpointOptions checkpointOptions) {
        }

        public void addInputData(long cpId, InputChannelInfo info, int startSeqNum, CloseableIterator<Buffer> data) {
        }

        public void addOutputData(long cpId, ResultSubpartitionInfo info, int startSeqNum, Buffer ... data) {
        }

        public void addOutputDataFuture(long l, ResultSubpartitionInfo resultSubpartitionInfo, int i, CompletableFuture<List<Buffer>> completableFuture) throws IllegalArgumentException {
        }

        public void finishInput(long checkpointId) {
        }

        public void finishOutput(long checkpointId) {
        }

        public void abort(long checkpointId, Throwable cause, boolean cleanup) {
        }

        public ChannelStateWriter.ChannelStateWriteResult getAndRemoveWriteResult(long checkpointId) {
            return null;
        }

        public void close() {
        }
    }

    private static class FakedMemorySegmentProvider
    implements MemorySegmentProvider {
        private FakedMemorySegmentProvider() {
        }

        public Collection<MemorySegment> requestUnpooledMemorySegments(int i) throws IOException {
            return null;
        }

        public void recycleUnpooledMemorySegments(Collection<MemorySegment> collection) throws IOException {
        }
    }

    private class FakedRemoteInputChannel
    extends RemoteInputChannel {
        FakedRemoteInputChannel(int channelIndex) {
            super(new SingleInputGate(RemoteShuffleInputGate.this.inputGateDelegation.getTaskName(), RemoteShuffleInputGate.this.inputGateDelegation.getGateIndex(), new IntermediateDataSetID(), ResultPartitionType.BLOCKING, 1, (a, b, c) -> {}, () -> null, null, (MemorySegmentProvider)new FakedMemorySegmentProvider(), 0, new ThroughputCalculator((Clock)SystemClock.getInstance()), null), channelIndex, new ResultPartitionID(), new ResultSubpartitionIndexSet(new IndexRange(0, 0)), new ConnectionID(new TaskManagerLocation(ResourceID.generate(), InetAddress.getLoopbackAddress(), 1), 0), (ConnectionManager)new LocalConnectionManager(), 0, 0, 0, 0, (Counter)new SimpleCounter(), (Counter)new SimpleCounter(), (ChannelStateWriter)new FakedChannelStateWriter());
        }
    }
}

