/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.sasl;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.common.network.sasl.SecretRegistry;
import org.apache.celeborn.common.util.JavaUtils;

public class SecretRegistryImpl
implements SecretRegistry {
    private final ConcurrentHashMap<String, String> secrets = JavaUtils.newConcurrentHashMap();

    @Override
    public void register(String appId, String secret) {
        this.secrets.compute(appId, (id, oldVal) -> {
            if (oldVal != null) {
                throw new IllegalArgumentException("AppId " + appId + " is already registered.");
            }
            return secret;
        });
    }

    @Override
    public void unregister(String appId) {
        this.secrets.remove(appId);
    }

    @Override
    public boolean isRegistered(String appId) {
        return this.secrets.containsKey(appId);
    }

    @Override
    public String getSecretKey(String appId) {
        return this.secrets.get(appId);
    }
}

