/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.shuffle.celeborn.PackedRecordPointer;
import org.apache.spark.shuffle.celeborn.SparkCommonUtils;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.util.collection.unsafe.sort.RadixSort;

public class ShuffleInMemorySorter {
    private final MemoryConsumer consumer;
    private LongArray array;
    private int pos = 0;
    private int usableCapacity = 0;
    private final int initialSize;

    public ShuffleInMemorySorter(MemoryConsumer consumer, int initialSize) {
        this.consumer = consumer;
        assert (initialSize > 0);
        this.initialSize = initialSize;
        this.array = consumer.allocateArray((long)initialSize);
        this.usableCapacity = this.getUsableCapacity();
    }

    private int getUsableCapacity() {
        return (int)(this.array.size() / 2L);
    }

    public long getInitialSize() {
        return this.initialSize;
    }

    public void freeMemory() {
        if (this.consumer != null) {
            if (this.array != null) {
                this.consumer.freeArray(this.array);
            }
            this.array = null;
            this.usableCapacity = 0;
        }
        this.pos = 0;
    }

    public int numRecords() {
        return this.pos;
    }

    public void expandPointerArray(LongArray newArray) {
        if (this.array != null) {
            if (newArray.size() < this.array.size()) {
                SparkCommonUtils.throwSparkOutOfMemoryError();
            }
            Platform.copyMemory((Object)this.array.getBaseObject(), (long)this.array.getBaseOffset(), (Object)newArray.getBaseObject(), (long)newArray.getBaseOffset(), (long)((long)this.pos * 8L));
            this.consumer.freeArray(this.array);
        }
        this.array = newArray;
        this.usableCapacity = this.getUsableCapacity();
    }

    public boolean hasSpaceForAnotherRecord() {
        return this.pos < this.usableCapacity;
    }

    public long getMemoryUsage() {
        if (this.array == null) {
            return 0L;
        }
        return this.array.size() * 8L;
    }

    public void insertRecord(long recordPointer, int partitionId) {
        if (!this.hasSpaceForAnotherRecord()) {
            throw new IllegalStateException("There is no space for new record");
        }
        this.array.set(this.pos, PackedRecordPointer.packPointer(recordPointer, partitionId));
        ++this.pos;
    }

    public ShuffleSorterIterator getSortedIterator() {
        if (this.numRecords() == 0) {
            return new ShuffleSorterIterator(0, this.array, 0);
        }
        int offset = RadixSort.sort((LongArray)this.array, (long)this.pos, (int)5, (int)7, (boolean)false, (boolean)false);
        return new ShuffleSorterIterator(this.pos, this.array, offset);
    }

    public static final class ShuffleSorterIterator {
        private final LongArray pointerArray;
        private final int limit;
        final PackedRecordPointer packedRecordPointer = new PackedRecordPointer();
        private int position = 0;

        ShuffleSorterIterator(int numRecords, LongArray pointerArray, int startingPosition) {
            this.limit = numRecords + startingPosition;
            this.pointerArray = pointerArray;
            this.position = startingPosition;
        }

        public boolean hasNext() {
            return this.position < this.limit;
        }

        public void loadNext() {
            this.packedRecordPointer.set(this.pointerArray.get(this.position));
            ++this.position;
        }
    }
}

