/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornRuntimeException;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.protocol.message.ControlMessages;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.KeyLock;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.reflect.DynConstructors;
import org.apache.celeborn.reflect.DynFields;
import org.apache.celeborn.reflect.DynMethods;
import org.apache.celeborn.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.celeborn.shaded.org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.spark.BarrierTaskContext;
import org.apache.spark.MapOutputTrackerMaster;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.scheduler.DAGScheduler;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.scheduler.ShuffleMapStage;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.TaskSetManager;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.celeborn.CelebornShuffleHandle;
import org.apache.spark.shuffle.celeborn.CelebornShuffleReader;
import org.apache.spark.shuffle.celeborn.ExecutorShuffleIdTracker;
import org.apache.spark.shuffle.celeborn.HashBasedShuffleWriter;
import org.apache.spark.shuffle.celeborn.SendBufferPool;
import org.apache.spark.shuffle.celeborn.SparkCommonUtils;
import org.apache.spark.shuffle.celeborn.SparkShuffleManager;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.sql.execution.UnsafeRowSerializer;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.storage.BlockManagerId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassManifestFactory;

public class SparkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SparkUtils.class);
    public static final String FETCH_FAILURE_ERROR_MSG = "Celeborn FetchFailure appShuffleId/shuffleId: ";
    private static final DynFields.UnboundField<SQLMetric> DATA_SIZE_METRIC_FIELD = DynFields.builder().hiddenImpl(UnsafeRowSerializer.class, "dataSize").defaultAlwaysNull().build();
    private static final DynMethods.UnboundMethod GET_READER_METHOD = DynMethods.builder("getReader").impl(SortShuffleManager.class, ShuffleHandle.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, TaskContext.class, ShuffleReadMetricsReporter.class).orNoop().build();
    private static final DynMethods.UnboundMethod LEGACY_GET_READER_METHOD = DynMethods.builder("getReader").impl(SortShuffleManager.class, ShuffleHandle.class, Integer.TYPE, Integer.TYPE, TaskContext.class, ShuffleReadMetricsReporter.class).orNoop().build();
    public static final String COLUMNAR_HASH_BASED_SHUFFLE_WRITER_CLASS = "org.apache.spark.shuffle.celeborn.ColumnarHashBasedShuffleWriter";
    static final DynConstructors.Builder COLUMNAR_HASH_BASED_SHUFFLE_WRITER_CONSTRUCTOR_BUILDER = DynConstructors.builder().impl("org.apache.spark.shuffle.celeborn.ColumnarHashBasedShuffleWriter", Integer.TYPE, CelebornShuffleHandle.class, TaskContext.class, CelebornConf.class, ShuffleClient.class, ShuffleWriteMetricsReporter.class, SendBufferPool.class);
    public static final String COLUMNAR_SHUFFLE_READER_CLASS = "org.apache.spark.shuffle.celeborn.CelebornColumnarShuffleReader";
    static final DynConstructors.Builder COLUMNAR_SHUFFLE_READER_CONSTRUCTOR_BUILDER = DynConstructors.builder().impl("org.apache.spark.shuffle.celeborn.CelebornColumnarShuffleReader", CelebornShuffleHandle.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, TaskContext.class, CelebornConf.class, ShuffleReadMetricsReporter.class, ExecutorShuffleIdTracker.class);
    private static final DynMethods.UnboundMethod UnregisterAllMapAndMergeOutput_METHOD = DynMethods.builder("unregisterAllMapAndMergeOutput").impl(MapOutputTrackerMaster.class, Integer.TYPE).orNoop().build();
    private static final DynMethods.UnboundMethod UnregisterAllMapOutput_METHOD = DynMethods.builder("unregisterAllMapOutput").impl(MapOutputTrackerMaster.class, Integer.TYPE).orNoop().build();
    private static final DynFields.UnboundField shuffleIdToMapStage_FIELD = DynFields.builder().hiddenImpl(DAGScheduler.class, "shuffleIdToMapStage").build();
    private static final DynFields.UnboundField<ConcurrentHashMap<Long, TaskSetManager>> TASK_ID_TO_TASK_SET_MANAGER_FIELD = DynFields.builder().hiddenImpl(TaskSchedulerImpl.class, "taskIdToTaskSetManager").defaultAlwaysNull().build();
    private static final DynFields.UnboundField<HashMap<Long, TaskInfo>> TASK_INFOS_FIELD = DynFields.builder().hiddenImpl(TaskSetManager.class, "taskInfos").defaultAlwaysNull().build();
    protected static Map<String, Set<Long>> reportedStageShuffleFetchFailureTaskIds = JavaUtils.newConcurrentHashMap();
    protected static volatile Long lastReportedShuffleFetchFailureTaskId = null;
    private static final DynMethods.UnboundMethod isCelebornSkewShuffle_METHOD = DynMethods.builder("isCelebornSkewedShuffle").hiddenImpl("org.apache.spark.celeborn.CelebornShuffleState", Integer.TYPE).orNoop().build();
    private static final KeyLock<Integer> shuffleBroadcastLock = new KeyLock();
    @VisibleForTesting
    public static AtomicInteger getReducerFileGroupResponseBroadcastNum = new AtomicInteger();
    @VisibleForTesting
    public static Map<Integer, Tuple2<Broadcast<TransportMessage>, byte[]>> getReducerFileGroupResponseBroadcasts = JavaUtils.newConcurrentHashMap();

    public static MapStatus createMapStatus(BlockManagerId loc, long[] uncompressedSizes, long mapTaskId) {
        return MapStatus$.MODULE$.apply(loc, uncompressedSizes, mapTaskId);
    }

    public static SQLMetric getDataSize(UnsafeRowSerializer serializer) {
        SQLMetric dataSizeMetric = DATA_SIZE_METRIC_FIELD.get(serializer);
        if (dataSizeMetric == null) {
            LOG.warn("Failed to get dataSize metric, AQE won't work properly.");
        }
        return dataSizeMetric;
    }

    public static long[] unwrap(LongAdder[] adders) {
        int adderCounter = adders.length;
        long[] res = new long[adderCounter];
        for (int i = 0; i < adderCounter; ++i) {
            res[i] = adders[i].longValue();
        }
        return res;
    }

    public static CelebornConf fromSparkConf(SparkConf conf) {
        CelebornConf tmpCelebornConf = new CelebornConf();
        for (Tuple2 kv : conf.getAll()) {
            if (!((String)kv._1).startsWith("spark.celeborn.")) continue;
            tmpCelebornConf.set(((String)kv._1).substring("spark.".length()), (String)kv._2);
        }
        return tmpCelebornConf;
    }

    public static String appUniqueId(SparkContext context) {
        return (String)context.applicationAttemptId().map(id -> context.applicationId() + "_" + id).getOrElse(() -> ((SparkContext)context).applicationId());
    }

    public static int celebornShuffleId(ShuffleClient client, CelebornShuffleHandle<?, ?, ?> handle, TaskContext context, Boolean isWriter) {
        if (handle.stageRerunEnabled()) {
            String appShuffleIdentifier = SparkCommonUtils.encodeAppShuffleIdentifier(handle.shuffleId(), context);
            Tuple2<Integer, Boolean> res = client.getShuffleId(handle.shuffleId(), appShuffleIdentifier, isWriter, context instanceof BarrierTaskContext);
            if (!((Boolean)res._2).booleanValue()) {
                throw new CelebornRuntimeException(String.format("Get invalid shuffle id %s", res._1));
            }
            return (Integer)res._1;
        }
        return handle.shuffleId();
    }

    public static <T> T instantiateClass(String className, SparkConf conf, Boolean isDriver) {
        DynConstructors.Ctor dynConstructor = DynConstructors.builder().impl(className, SparkConf.class, Boolean.TYPE).impl(className, SparkConf.class).impl(className, new Class[0]).build();
        return (T)dynConstructor.newInstance(conf, isDriver);
    }

    public static <K, C> ShuffleReader<K, C> getReader(SortShuffleManager sortShuffleManager, ShuffleHandle handle, Integer startPartition, Integer endPartition, Integer startMapIndex, Integer endMapIndex, TaskContext context, ShuffleReadMetricsReporter metrics) {
        ShuffleReader shuffleReader = (ShuffleReader)GET_READER_METHOD.bind(sortShuffleManager).invoke(handle, startMapIndex, endMapIndex, startPartition, endPartition, context, metrics);
        if (shuffleReader != null) {
            return shuffleReader;
        }
        shuffleReader = (ShuffleReader)LEGACY_GET_READER_METHOD.bind(sortShuffleManager).invoke(handle, startPartition, endPartition, context, metrics);
        assert (shuffleReader != null);
        return shuffleReader;
    }

    public static <K, V, C> HashBasedShuffleWriter<K, V, C> createColumnarHashBasedShuffleWriter(int shuffleId, CelebornShuffleHandle<K, V, C> handle, TaskContext taskContext, CelebornConf conf, ShuffleClient client, ShuffleWriteMetricsReporter metrics, SendBufferPool sendBufferPool) {
        return (HashBasedShuffleWriter)((Object)COLUMNAR_HASH_BASED_SHUFFLE_WRITER_CONSTRUCTOR_BUILDER.build().invoke(null, new Object[]{shuffleId, handle, taskContext, conf, client, metrics, sendBufferPool}));
    }

    public static <K, C> CelebornShuffleReader<K, C> createColumnarShuffleReader(CelebornShuffleHandle<K, ?, C> handle, int startPartition, int endPartition, int startMapIndex, int endMapIndex, TaskContext context, CelebornConf conf, ShuffleReadMetricsReporter metrics, ExecutorShuffleIdTracker shuffleIdTracker) {
        return (CelebornShuffleReader)COLUMNAR_SHUFFLE_READER_CONSTRUCTOR_BUILDER.build().invoke(null, new Object[]{handle, startPartition, endPartition, startMapIndex, endMapIndex, context, conf, metrics, shuffleIdTracker});
    }

    public static void unregisterAllMapOutput(MapOutputTrackerMaster mapOutputTracker, int shuffleId) {
        if (!UnregisterAllMapAndMergeOutput_METHOD.isNoop()) {
            UnregisterAllMapAndMergeOutput_METHOD.bind(mapOutputTracker).invoke(shuffleId);
            return;
        }
        if (!UnregisterAllMapOutput_METHOD.isNoop()) {
            UnregisterAllMapOutput_METHOD.bind(mapOutputTracker).invoke(shuffleId);
            return;
        }
        throw new UnsupportedOperationException("unexpected! neither methods unregisterAllMapAndMergeOutput/unregisterAllMapOutput are found in MapOutputTrackerMaster");
    }

    public static void addFailureListenerIfBarrierTask(ShuffleClient shuffleClient, TaskContext taskContext, CelebornShuffleHandle<?, ?, ?> handle) {
        if (!(taskContext instanceof BarrierTaskContext)) {
            return;
        }
        int appShuffleId = handle.shuffleId();
        String appShuffleIdentifier = SparkCommonUtils.encodeAppShuffleIdentifier(appShuffleId, taskContext);
        BarrierTaskContext barrierContext = (BarrierTaskContext)taskContext;
        barrierContext.addTaskFailureListener((context, error) -> shuffleClient.reportBarrierTaskFailure(appShuffleId, appShuffleIdentifier));
    }

    public static void cancelShuffle(int shuffleId, String reason) {
        if (SparkContext$.MODULE$.getActive().nonEmpty()) {
            DAGScheduler scheduler = ((SparkContext)SparkContext$.MODULE$.getActive().get()).dagScheduler();
            scala.collection.mutable.Map shuffleIdToMapStageValue = (scala.collection.mutable.Map)shuffleIdToMapStage_FIELD.bind(scheduler).get();
            Option shuffleMapStage = shuffleIdToMapStageValue.get((Object)shuffleId);
            if (shuffleMapStage.nonEmpty()) {
                scheduler.cancelStage(((ShuffleMapStage)shuffleMapStage.get()).id(), (Option)new Some((Object)reason));
            }
        } else {
            LOG.error("Can not get active SparkContext, skip cancelShuffle.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected static TaskSetManager getTaskSetManager(TaskSchedulerImpl taskScheduler, long taskId) {
        TaskSchedulerImpl taskSchedulerImpl = taskScheduler;
        synchronized (taskSchedulerImpl) {
            ConcurrentHashMap<Long, TaskSetManager> taskIdToTaskSetManager = TASK_ID_TO_TASK_SET_MANAGER_FIELD.bind(taskScheduler).get();
            return taskIdToTaskSetManager.get(taskId);
        }
    }

    @VisibleForTesting
    protected static Tuple2<TaskInfo, List<TaskInfo>> getTaskAttempts(TaskSetManager taskSetManager, long taskId) {
        if (taskSetManager != null) {
            Option taskInfoOption = TASK_INFOS_FIELD.bind(taskSetManager).get().get((Object)taskId);
            if (taskInfoOption.isDefined()) {
                TaskInfo taskInfo = (TaskInfo)taskInfoOption.get();
                List taskAttempts = JavaConverters.asJavaCollectionConverter((Iterable)taskSetManager.taskAttempts()[taskInfo.index()]).asJavaCollection().stream().collect(Collectors.toList());
                return Tuple2.apply((Object)taskInfo, taskAttempts);
            }
            LOG.error("Can not get TaskInfo for taskId: {}", (Object)taskId);
            return null;
        }
        LOG.error("Can not get TaskSetManager for taskId: {}", (Object)taskId);
        return null;
    }

    protected static void removeStageReportedShuffleFetchFailureTaskIds(int stageId, int stageAttemptId) {
        reportedStageShuffleFetchFailureTaskIds.remove(stageId + "-" + stageAttemptId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldReportShuffleFetchFailure(long taskId) {
        TaskSchedulerImpl taskScheduler;
        SparkContext sparkContext = (SparkContext)SparkContext$.MODULE$.getActive().getOrElse(null);
        if (sparkContext == null) {
            LOG.error("Can not get active SparkContext.");
            return true;
        }
        TaskSchedulerImpl taskSchedulerImpl = taskScheduler = (TaskSchedulerImpl)sparkContext.taskScheduler();
        synchronized (taskSchedulerImpl) {
            TaskSetManager taskSetManager = SparkUtils.getTaskSetManager(taskScheduler, taskId);
            if (taskSetManager != null) {
                int stageId = taskSetManager.stageId();
                int stageAttemptId = taskSetManager.taskSet().stageAttemptId();
                int maxTaskFails = taskSetManager.maxTaskFailures();
                String stageUniqId = stageId + "-" + stageAttemptId;
                Set reportedStageTaskIds = reportedStageShuffleFetchFailureTaskIds.computeIfAbsent(stageUniqId, k -> new HashSet());
                reportedStageTaskIds.add(taskId);
                lastReportedShuffleFetchFailureTaskId = taskId;
                Tuple2<TaskInfo, List<TaskInfo>> taskAttempts = SparkUtils.getTaskAttempts(taskSetManager, taskId);
                if (taskAttempts == null) {
                    return true;
                }
                TaskInfo taskInfo = (TaskInfo)taskAttempts._1();
                int failedTaskAttempts = 1;
                boolean hasRunningAttempt = false;
                for (TaskInfo ti : (List)taskAttempts._2()) {
                    if (ti.taskId() == taskId) continue;
                    if (reportedStageTaskIds.contains(ti.taskId())) {
                        LOG.info("StageId={} index={} taskId={} attempt={} another attempt {} has reported shuffle fetch failure.", new Object[]{stageId, taskInfo.index(), taskId, taskInfo.attemptNumber(), ti.attemptNumber()});
                        ++failedTaskAttempts;
                        continue;
                    }
                    if (ti.successful()) {
                        LOG.info("StageId={} index={} taskId={} attempt={} another attempt {} is successful.", new Object[]{stageId, taskInfo.index(), taskId, taskInfo.attemptNumber(), ti.attemptNumber()});
                        return false;
                    }
                    if (ti.running()) {
                        LOG.info("StageId={} index={} taskId={} attempt={} another attempt {} is running.", new Object[]{stageId, taskInfo.index(), taskId, taskInfo.attemptNumber(), ti.attemptNumber()});
                        hasRunningAttempt = true;
                        continue;
                    }
                    if (!"FAILED".equals(ti.status()) && !"UNKNOWN".equals(ti.status())) continue;
                    LOG.info("StageId={} index={} taskId={} attempt={} another attempt {} status={}.", new Object[]{stageId, taskInfo.index(), taskId, taskInfo.attemptNumber(), ti.attemptNumber(), ti.status()});
                    ++failedTaskAttempts;
                }
                if (failedTaskAttempts >= maxTaskFails || !hasRunningAttempt) {
                    LOG.warn("StageId={}, index={}, taskId={}, attemptNumber={}: Task failure count {} reached maximum allowed failures {} or no running attempt exists.", new Object[]{stageId, taskInfo.index(), taskId, taskInfo.attemptNumber(), failedTaskAttempts, maxTaskFails});
                    return true;
                }
                return false;
            }
            LOG.error("Can not get TaskSetManager for taskId: {}, ignore it. (This typically occurs when:  task completed/cleaned up, executor marked as failed, or stage cancelled/completed)", (Object)taskId);
            return false;
        }
    }

    public static void addSparkListener(SparkListener listener) {
        SparkContext sparkContext = (SparkContext)SparkContext$.MODULE$.getActive().getOrElse(null);
        if (sparkContext != null) {
            sparkContext.addSparkListener((SparkListenerInterface)listener);
        }
    }

    public static boolean isCelebornSkewShuffleOrChildShuffle(int appShuffleId) {
        if (!isCelebornSkewShuffle_METHOD.isNoop()) {
            return (Boolean)isCelebornSkewShuffle_METHOD.asStatic().invoke(appShuffleId);
        }
        return false;
    }

    public static byte[] serializeGetReducerFileGroupResponse(Integer shuffleId, ControlMessages.GetReducerFileGroupResponse response) {
        SparkContext sparkContext = (SparkContext)SparkContext$.MODULE$.getActive().getOrElse(null);
        if (sparkContext == null) {
            LOG.error("Can not get active SparkContext.");
            return null;
        }
        return shuffleBroadcastLock.withLock(shuffleId, () -> {
            Tuple2<Broadcast<TransportMessage>, byte[]> cachedSerializeGetReducerFileGroupResponse = getReducerFileGroupResponseBroadcasts.get(shuffleId);
            if (cachedSerializeGetReducerFileGroupResponse != null) {
                return (byte[])cachedSerializeGetReducerFileGroupResponse._2;
            }
            try {
                LOG.info("Broadcasting GetReducerFileGroupResponse for shuffle: {}", (Object)shuffleId);
                TransportMessage transportMessage = (TransportMessage)Utils.toTransportMessage(response);
                Broadcast broadcast = sparkContext.broadcast((Object)transportMessage, ClassManifestFactory.fromClass(TransportMessage.class));
                CompressionCodec codec = CompressionCodec$.MODULE$.createCodec(sparkContext.conf());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try (ObjectOutputStream oos = new ObjectOutputStream(codec.compressedOutputStream((OutputStream)out));){
                    oos.writeObject(broadcast);
                }
                byte[] _serializeResult = out.toByteArray();
                getReducerFileGroupResponseBroadcasts.put(shuffleId, (Tuple2<Broadcast<TransportMessage>, byte[]>)Tuple2.apply((Object)broadcast, (Object)_serializeResult));
                getReducerFileGroupResponseBroadcastNum.incrementAndGet();
                return _serializeResult;
            }
            catch (Throwable e) {
                LOG.error("Failed to serialize GetReducerFileGroupResponse for shuffle: {}", (Object)shuffleId, (Object)e);
                return null;
            }
        });
    }

    public static ControlMessages.GetReducerFileGroupResponse deserializeGetReducerFileGroupResponse(Integer shuffleId, byte[] bytes) {
        SparkEnv sparkEnv = SparkEnv$.MODULE$.get();
        if (sparkEnv == null) {
            LOG.error("Can not get SparkEnv.");
            return null;
        }
        return shuffleBroadcastLock.withLock(shuffleId, () -> {
            ControlMessages.GetReducerFileGroupResponse response = null;
            LOG.info("Deserializing GetReducerFileGroupResponse broadcast for shuffle: {}", (Object)shuffleId);
            try {
                CompressionCodec codec = CompressionCodec$.MODULE$.createCodec(sparkEnv.conf());
                try (ObjectInputStream objIn = new ObjectInputStream(codec.compressedInputStream((InputStream)new ByteArrayInputStream(bytes)));){
                    Broadcast broadcast = (Broadcast)objIn.readObject();
                    response = (ControlMessages.GetReducerFileGroupResponse)Utils.fromTransportMessage(broadcast.value());
                }
            }
            catch (Throwable e) {
                LOG.error("Failed to deserialize GetReducerFileGroupResponse for shuffle: " + shuffleId, e);
            }
            return response;
        });
    }

    public static void invalidateSerializedGetReducerFileGroupResponse(Integer shuffleId) {
        shuffleBroadcastLock.withLock(shuffleId, () -> {
            try {
                Tuple2<Broadcast<TransportMessage>, byte[]> cachedSerializeGetReducerFileGroupResponse = getReducerFileGroupResponseBroadcasts.remove(shuffleId);
                if (cachedSerializeGetReducerFileGroupResponse != null) {
                    ((Broadcast)cachedSerializeGetReducerFileGroupResponse._1()).destroy();
                }
            }
            catch (Throwable e) {
                LOG.error("Failed to invalidate serialized GetReducerFileGroupResponse for shuffle: " + shuffleId, e);
            }
            return null;
        });
    }

    public static void addWriterShuffleIdsToBeCleaned(SparkShuffleManager sparkShuffleManager, String appShuffleIdentifier) {
        sparkShuffleManager.getFailedShuffleCleaner().addShuffleIdToBeCleaned(appShuffleIdentifier);
    }

    public static void removeCleanedShuffleId(SparkShuffleManager sparkShuffleManager, int celebornShuffleId) {
        sparkShuffleManager.getFailedShuffleCleaner().removeCleanedShuffleId(celebornShuffleId);
    }

    public static boolean isLocalMaster(SparkConf conf) {
        String master = conf.get("spark.master", "");
        return master.equals("local") || master.startsWith("local[");
    }
}

