/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.junit;

import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RunTag
extends TagSupport {
    private static final Log log = LogFactory.getLog(RunTag.class);
    private Test test;
    private TestResult result;
    private TestListener listener;

    public void doTag(XMLOutput output) throws JellyTagException {
        TestListener listener;
        Test test = this.getTest();
        if (test == null) {
            test = (Test)this.context.getVariable("org.apache.commons.jelly.junit.suite");
        }
        if (test == null) {
            throw new MissingAttributeException("test");
        }
        TestResult result = this.getResult();
        if (result == null) {
            result = this.createResult(output);
        }
        if ((listener = this.getListener()) == null) {
            listener = this.createTestListener(output);
        }
        result.addListener(listener);
        test.run(result);
    }

    public TestResult getResult() {
        return this.result;
    }

    public Test getTest() {
        return this.test;
    }

    public void setResult(TestResult result) {
        this.result = result;
    }

    public void setTest(Test test) {
        this.test = test;
    }

    public TestListener getListener() {
        return this.listener;
    }

    public void setListener(TestListener listener) {
        this.listener = listener;
    }

    protected TestResult createResult(XMLOutput output) {
        return new TestResult();
    }

    protected TestListener createTestListener(final XMLOutput output) {
        return new TestListener(){

            public void addError(Test test, Throwable t) {
                try {
                    output.startElement("error");
                    output.startElement("message");
                    output.write(t.getMessage());
                    output.endElement("message");
                    output.startElement("stack");
                    output.write(RunTag.this.stackTraceToString(t));
                    output.endElement("stack");
                    output.endElement("error");
                }
                catch (SAXException e) {
                    RunTag.this.handleSAXException(e);
                }
            }

            public void addFailure(Test test, AssertionFailedError t) {
                try {
                    output.startElement("failure");
                    output.startElement("message");
                    output.write(t.getMessage());
                    output.endElement("message");
                    output.startElement("stack");
                    output.write(RunTag.this.stackTraceToString((Throwable)t));
                    output.endElement("stack");
                    output.endElement("failure");
                }
                catch (SAXException e) {
                    RunTag.this.handleSAXException(e);
                }
            }

            public void endTest(Test test) {
                try {
                    output.endElement("test");
                }
                catch (SAXException e) {
                    RunTag.this.handleSAXException(e);
                }
            }

            public void startTest(Test test) {
                try {
                    String name = test.toString();
                    AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute("", "name", "name", "CDATA", name);
                    output.startElement("test", (Attributes)attributes);
                }
                catch (SAXException e) {
                    RunTag.this.handleSAXException(e);
                }
            }
        };
    }

    protected String stackTraceToString(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    protected void handleSAXException(SAXException e) {
        log.error((Object)("Caught: " + e), (Throwable)e);
    }
}

