/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassLoaderUtils {
    private static final Log log = LogFactory.getLog(ClassLoaderUtils.class);

    public static ClassLoader getClassLoader(ClassLoader specifiedLoader, boolean useContextClassLoader, Class callingClass) {
        ClassLoader classLoader;
        if (specifiedLoader != null) {
            return specifiedLoader;
        }
        if (useContextClassLoader && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return classLoader;
        }
        return ClassLoaderUtils.getClassLoader(callingClass);
    }

    public static ClassLoader getClassLoader(ClassLoader specifiedLoader, Class callingClass) {
        if (specifiedLoader != null) {
            return specifiedLoader;
        }
        return ClassLoaderUtils.getClassLoader(callingClass);
    }

    public static ClassLoader getClassLoader(Class clazz) {
        ClassLoader callersLoader = clazz.getClassLoader();
        if (callersLoader == null) {
            callersLoader = ClassLoader.getSystemClassLoader();
        }
        return callersLoader;
    }

    public static Class loadClass(String className, Class callingClass) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            return ClassLoaderUtils.getClassLoader(callingClass).loadClass(className);
        }
        return loader.loadClass(className);
    }

    public static Class loadClass(String className, ClassLoader specifiedLoader, boolean useContextLoader, Class callingClass) throws ClassNotFoundException {
        ClassLoader contextLoader;
        Class<?> clazz = null;
        if (specifiedLoader != null) {
            try {
                clazz = specifiedLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                log.debug((Object)"couldn't find class in specified loader", (Throwable)e);
            }
        }
        if (clazz == null && useContextLoader && (contextLoader = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                clazz = contextLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                log.debug((Object)"couldn't find class in specified loader", (Throwable)e);
            }
        }
        if (clazz == null) {
            ClassLoader loader = ClassLoaderUtils.getClassLoader(callingClass);
            clazz = loader.loadClass(className);
        }
        return clazz;
    }
}

