/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.TrivariateFunction;
import org.apache.commons.math3.analysis.interpolation.TricubicInterpolatingFunction;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public final class TricubicInterpolatingFunctionTest {
    @Test
    public void testPreconditions() {
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.5};
        double[] zval = new double[]{-12.0, -8.0, -5.5, -3.0, 0.0, 2.5};
        double[][][] fval = new double[xval.length][yval.length][zval.length];
        TricubicInterpolatingFunction tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, fval, fval, fval);
        double[] wxval = new double[]{3.0, 2.0, 5.0, 6.5};
        try {
            tcf = new TricubicInterpolatingFunction(wxval, yval, zval, fval, fval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[] wyval = new double[]{-4.0, -1.0, -1.0, 2.5};
        try {
            tcf = new TricubicInterpolatingFunction(xval, wyval, zval, fval, fval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[] wzval = new double[]{-12.0, -8.0, -9.0, -3.0, 0.0, 2.5};
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, wzval, fval, fval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[][][] wfval = new double[xval.length - 1][yval.length - 1][zval.length];
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, wfval, fval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, wfval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, wfval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, wfval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, wfval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, wfval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, fval, wfval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, fval, fval, wfval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        wfval = new double[xval.length][yval.length - 1][zval.length];
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, wfval, fval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, wfval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, wfval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, wfval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, wfval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, wfval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, fval, wfval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, fval, fval, wfval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        wfval = new double[xval.length][yval.length][zval.length - 1];
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, wfval, fval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, wfval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, wfval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, wfval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, wfval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, wfval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, fval, wfval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, fval, fval, wfval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
    }

    private void testInterpolation(double minimumX, double maximumX, double minimumY, double maximumY, double minimumZ, double maximumZ, int numberOfElements, int numberOfSamples, TrivariateFunction f, TrivariateFunction dfdx, TrivariateFunction dfdy, TrivariateFunction dfdz, TrivariateFunction d2fdxdy, TrivariateFunction d2fdxdz, TrivariateFunction d2fdydz, TrivariateFunction d3fdxdydz, double meanRelativeTolerance, double maxRelativeTolerance, double onDataMaxAbsoluteTolerance, boolean print) {
        double actual;
        double expected;
        double currentZ;
        double currentY;
        double currentX;
        double deltaX = (maximumX - minimumX) / (double)numberOfElements;
        double deltaY = (maximumY - minimumY) / (double)numberOfElements;
        double deltaZ = (maximumZ - minimumZ) / (double)numberOfElements;
        double[] xValues = new double[numberOfElements];
        double[] yValues = new double[numberOfElements];
        double[] zValues = new double[numberOfElements];
        double[][][] fValues = new double[numberOfElements][numberOfElements][numberOfElements];
        double[][][] dfdxValues = new double[numberOfElements][numberOfElements][numberOfElements];
        double[][][] dfdyValues = new double[numberOfElements][numberOfElements][numberOfElements];
        double[][][] dfdzValues = new double[numberOfElements][numberOfElements][numberOfElements];
        double[][][] d2fdxdyValues = new double[numberOfElements][numberOfElements][numberOfElements];
        double[][][] d2fdxdzValues = new double[numberOfElements][numberOfElements][numberOfElements];
        double[][][] d2fdydzValues = new double[numberOfElements][numberOfElements][numberOfElements];
        double[][][] d3fdxdydzValues = new double[numberOfElements][numberOfElements][numberOfElements];
        for (int i = 0; i < numberOfElements; ++i) {
            xValues[i] = minimumX + deltaX * (double)i;
            double x = xValues[i];
            for (int j = 0; j < numberOfElements; ++j) {
                yValues[j] = minimumY + deltaY * (double)j;
                double y = yValues[j];
                for (int k = 0; k < numberOfElements; ++k) {
                    zValues[k] = minimumZ + deltaZ * (double)k;
                    double z = zValues[k];
                    fValues[i][j][k] = f.value(x, y, z);
                    dfdxValues[i][j][k] = dfdx.value(x, y, z);
                    dfdyValues[i][j][k] = dfdy.value(x, y, z);
                    dfdzValues[i][j][k] = dfdz.value(x, y, z);
                    d2fdxdyValues[i][j][k] = d2fdxdy.value(x, y, z);
                    d2fdxdzValues[i][j][k] = d2fdxdz.value(x, y, z);
                    d2fdydzValues[i][j][k] = d2fdydz.value(x, y, z);
                    d3fdxdydzValues[i][j][k] = d3fdxdydz.value(x, y, z);
                }
            }
        }
        TricubicInterpolatingFunction interpolation = new TricubicInterpolatingFunction(xValues, yValues, zValues, fValues, dfdxValues, dfdyValues, dfdzValues, d2fdxdyValues, d2fdxdzValues, d2fdydzValues, d3fdxdydzValues);
        for (int i = 0; i < numberOfElements; ++i) {
            currentX = xValues[i];
            for (int j = 0; j < numberOfElements; ++j) {
                currentY = yValues[j];
                for (int k = 0; k < numberOfElements; ++k) {
                    currentZ = zValues[k];
                    expected = f.value(currentX, currentY, currentZ);
                    actual = interpolation.value(currentX, currentY, currentZ);
                    Assert.assertTrue((String)("On data point: " + expected + " != " + actual), (boolean)Precision.equals((double)expected, (double)actual, (double)onDataMaxAbsoluteTolerance));
                }
            }
        }
        Well19937c rng = new Well19937c(1234567L);
        UniformRealDistribution distX = new UniformRealDistribution((RandomGenerator)rng, xValues[0], xValues[xValues.length - 1]);
        UniformRealDistribution distY = new UniformRealDistribution((RandomGenerator)rng, yValues[0], yValues[yValues.length - 1]);
        UniformRealDistribution distZ = new UniformRealDistribution((RandomGenerator)rng, zValues[0], zValues[zValues.length - 1]);
        double sumError = 0.0;
        for (int i = 0; i < numberOfSamples; ++i) {
            currentX = distX.sample();
            currentY = distY.sample();
            currentZ = distZ.sample();
            expected = f.value(currentX, currentY, currentZ);
            actual = interpolation.value(currentX, currentY, currentZ);
            double relativeError = FastMath.abs((double)(actual - expected)) / FastMath.max((double)FastMath.abs((double)actual), (double)FastMath.abs((double)expected));
            sumError += relativeError;
            if (print) {
                System.out.println(currentX + " " + currentY + " " + currentZ + " " + actual + " " + expected + " " + (expected - actual));
            }
            Assert.assertEquals((double)0.0, (double)relativeError, (double)maxRelativeTolerance);
        }
        double meanError = sumError / (double)numberOfSamples;
        Assert.assertEquals((double)0.0, (double)meanError, (double)meanRelativeTolerance);
    }

    @Test
    public void testPlane() {
        TrivariateFunction f = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 2.0 * x - 3.0 * y - 4.0 * z + 5.0;
            }
        };
        TrivariateFunction dfdx = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 2.0;
            }
        };
        TrivariateFunction dfdy = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return -3.0;
            }
        };
        TrivariateFunction dfdz = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return -4.0;
            }
        };
        TrivariateFunction zero = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 0.0;
            }
        };
        this.testInterpolation(-10.0, 3.0, 4.5, 6.0, -150.0, -117.0, 7, 1000, f, dfdx, dfdy, dfdz, zero, zero, zero, zero, 1.0E-12, 1.0E-11, 1.0E-10, false);
    }

    @Test
    public void testQuadric() {
        TrivariateFunction f = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 2.0 * x * x - 3.0 * y * y - 4.0 * z * z + 5.0 * x * y + 6.0 * x * z - 2.0 * y * z + 3.0;
            }
        };
        TrivariateFunction dfdx = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 4.0 * x + 5.0 * y + 6.0 * z;
            }
        };
        TrivariateFunction dfdy = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return -6.0 * y + 5.0 * x - 2.0 * z;
            }
        };
        TrivariateFunction dfdz = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return -8.0 * z + 6.0 * x - 2.0 * y;
            }
        };
        TrivariateFunction d2fdxdy = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 5.0;
            }
        };
        TrivariateFunction d2fdxdz = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 6.0;
            }
        };
        TrivariateFunction d2fdydz = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return -2.0;
            }
        };
        TrivariateFunction d3fdxdydz = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 0.0;
            }
        };
        this.testInterpolation(-10.0, 3.0, 4.5, 6.0, -150.0, -117.0, 7, 5000, f, dfdx, dfdy, dfdz, d2fdxdy, d2fdxdz, d2fdydz, d3fdxdydz, 1.0E-12, 1.0E-11, 1.0E-8, false);
    }

    @Test
    public void testWave() {
        double a = 5.0;
        double omega = 0.3;
        double kx = 0.8;
        double ky = 1.0;
        final TrivariateFunction arg = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 0.3 * z - 0.8 * x - 1.0 * y;
            }
        };
        TrivariateFunction f = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 5.0 * FastMath.cos((double)arg.value(x, y, z));
            }
        };
        TrivariateFunction dfdx = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 4.0 * FastMath.sin((double)arg.value(x, y, z));
            }
        };
        TrivariateFunction dfdy = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 5.0 * FastMath.sin((double)arg.value(x, y, z));
            }
        };
        TrivariateFunction dfdz = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return -1.5 * FastMath.sin((double)arg.value(x, y, z));
            }
        };
        TrivariateFunction d2fdxdy = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return -4.0 * FastMath.cos((double)arg.value(x, y, z));
            }
        };
        TrivariateFunction d2fdxdz = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 1.2 * FastMath.cos((double)arg.value(x, y, z));
            }
        };
        TrivariateFunction d2fdydz = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 1.5 * FastMath.cos((double)arg.value(x, y, z));
            }
        };
        TrivariateFunction d3fdxdydz = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 1.2 * FastMath.sin((double)arg.value(x, y, z));
            }
        };
        this.testInterpolation(-10.0, 3.0, 4.5, 6.0, -150.0, -117.0, 30, 5000, f, dfdx, dfdy, dfdz, d2fdxdy, d2fdxdz, d2fdydz, d3fdxdydz, 0.001, 0.01, 1.0E-12, false);
    }
}

