/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.events;

import java.util.ArrayList;
import org.apache.commons.math3.analysis.solvers.PegasusSolver;
import org.apache.commons.math3.analysis.solvers.UnivariateSolver;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.events.EventHandler;
import org.apache.commons.math3.ode.nonstiff.DormandPrince853Integrator;
import org.junit.Assert;
import org.junit.Test;

public class OverlappingEventsTest
implements FirstOrderDifferentialEquations {
    private static final double[] EVENT_TIMES1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
    private static final double[] EVENT_TIMES2 = new double[]{0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5};

    @Test
    public void testOverlappingEvents0() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        this.test(0);
    }

    @Test
    public void testOverlappingEvents1() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        this.test(1);
    }

    public void test(int eventType) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        int i;
        double e = 1.0E-15;
        DormandPrince853Integrator integrator = new DormandPrince853Integrator(e, 100.0, 1.0E-7, 1.0E-7);
        PegasusSolver rootSolver = new PegasusSolver(e, e);
        Event evt1 = new Event(0, eventType);
        Event evt2 = new Event(1, eventType);
        integrator.addEventHandler((EventHandler)evt1, 0.1, e, 999, (UnivariateSolver)rootSolver);
        integrator.addEventHandler((EventHandler)evt2, 0.1, e, 999, (UnivariateSolver)rootSolver);
        double t = 0.0;
        double tEnd = 10.0;
        double[] y = new double[]{0.0, 0.0};
        ArrayList<Double> events1 = new ArrayList<Double>();
        ArrayList<Double> events2 = new ArrayList<Double>();
        while (t < tEnd) {
            t = integrator.integrate((FirstOrderDifferentialEquations)this, t, y, tEnd, y);
            if (y[0] >= 1.0) {
                y[0] = 0.0;
                events1.add(t);
            }
            if (!(y[1] >= 1.0)) continue;
            y[1] = 0.0;
            events2.add(t);
        }
        Assert.assertEquals((long)EVENT_TIMES1.length, (long)events1.size());
        Assert.assertEquals((long)EVENT_TIMES2.length, (long)events2.size());
        for (i = 0; i < EVENT_TIMES1.length; ++i) {
            Assert.assertEquals((double)EVENT_TIMES1[i], (double)((Double)events1.get(i)), (double)1.0E-7);
        }
        for (i = 0; i < EVENT_TIMES2.length; ++i) {
            Assert.assertEquals((double)EVENT_TIMES2[i], (double)((Double)events2.get(i)), (double)1.0E-7);
        }
    }

    public int getDimension() {
        return 2;
    }

    public void computeDerivatives(double t, double[] y, double[] yDot) {
        yDot[0] = 1.0;
        yDot[1] = 2.0;
    }

    private class Event
    implements EventHandler {
        private final int idx;
        private final int eventType;

        public Event(int idx, int eventType) {
            this.idx = idx;
            this.eventType = eventType;
        }

        public void init(double t0, double[] y0, double t) {
        }

        public double g(double t, double[] y) {
            return this.eventType == 0 ? (y[this.idx] >= 1.0 ? 1.0 : -1.0) : y[this.idx] - 1.0;
        }

        public EventHandler.Action eventOccurred(double t, double[] y, boolean increasing) {
            return EventHandler.Action.STOP;
        }

        public void resetState(double t, double[] y) {
        }
    }
}

