/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar.noderiv;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.SimpleBounds;
import org.apache.commons.math3.optim.SimpleValueChecker;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.MultiDirectionalSimplex;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.NelderMeadSimplex;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.SimplexOptimizer;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class SimplexOptimizerMultiDirectionalTest {
    private int count;

    @Test(expected=MathUnsupportedOperationException.class)
    public void testBoundsUnsupported() {
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-10, 1.0E-30);
        FourExtrema fourExtrema = new FourExtrema();
        optimizer.optimize(new OptimizationData[]{new MaxEval(100), new ObjectiveFunction((MultivariateFunction)fourExtrema), GoalType.MINIMIZE, new InitialGuess(new double[]{-3.0, 0.0}), new NelderMeadSimplex(new double[]{0.2, 0.2}), new SimpleBounds(new double[]{-5.0, -1.0}, new double[]{5.0, 1.0})});
    }

    @Test
    public void testMinimize1() {
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-11, 1.0E-30);
        FourExtrema fourExtrema = new FourExtrema();
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(200), new ObjectiveFunction((MultivariateFunction)fourExtrema), GoalType.MINIMIZE, new InitialGuess(new double[]{-3.0, 0.0}), new MultiDirectionalSimplex(new double[]{0.2, 0.2})});
        Assert.assertEquals((double)fourExtrema.xM, (double)optimum.getPoint()[0], (double)4.0E-6);
        Assert.assertEquals((double)fourExtrema.yP, (double)optimum.getPoint()[1], (double)3.0E-6);
        Assert.assertEquals((double)fourExtrema.valueXmYp, (double)((Double)optimum.getValue()), (double)8.0E-13);
        Assert.assertTrue((optimizer.getEvaluations() > 120 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 150 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getIterations() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMinimize2() {
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-11, 1.0E-30);
        FourExtrema fourExtrema = new FourExtrema();
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(200), new ObjectiveFunction((MultivariateFunction)fourExtrema), GoalType.MINIMIZE, new InitialGuess(new double[]{1.0, 0.0}), new MultiDirectionalSimplex(new double[]{0.2, 0.2})});
        Assert.assertEquals((double)fourExtrema.xP, (double)optimum.getPoint()[0], (double)2.0E-8);
        Assert.assertEquals((double)fourExtrema.yM, (double)optimum.getPoint()[1], (double)3.0E-6);
        Assert.assertEquals((double)fourExtrema.valueXpYm, (double)((Double)optimum.getValue()), (double)2.0E-12);
        Assert.assertTrue((optimizer.getEvaluations() > 120 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 150 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getIterations() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMaximize1() {
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-11, 1.0E-30);
        FourExtrema fourExtrema = new FourExtrema();
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(200), new ObjectiveFunction((MultivariateFunction)fourExtrema), GoalType.MAXIMIZE, new InitialGuess(new double[]{-3.0, 0.0}), new MultiDirectionalSimplex(new double[]{0.2, 0.2})});
        Assert.assertEquals((double)fourExtrema.xM, (double)optimum.getPoint()[0], (double)7.0E-7);
        Assert.assertEquals((double)fourExtrema.yM, (double)optimum.getPoint()[1], (double)3.0E-7);
        Assert.assertEquals((double)fourExtrema.valueXmYm, (double)((Double)optimum.getValue()), (double)2.0E-14);
        Assert.assertTrue((optimizer.getEvaluations() > 120 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 150 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getIterations() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMaximize2() {
        SimplexOptimizer optimizer = new SimplexOptimizer((ConvergenceChecker)new SimpleValueChecker(1.0E-15, 1.0E-30));
        FourExtrema fourExtrema = new FourExtrema();
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(200), new ObjectiveFunction((MultivariateFunction)fourExtrema), GoalType.MAXIMIZE, new InitialGuess(new double[]{1.0, 0.0}), new MultiDirectionalSimplex(new double[]{0.2, 0.2})});
        Assert.assertEquals((double)fourExtrema.xP, (double)optimum.getPoint()[0], (double)2.0E-8);
        Assert.assertEquals((double)fourExtrema.yP, (double)optimum.getPoint()[1], (double)3.0E-6);
        Assert.assertEquals((double)fourExtrema.valueXpYp, (double)((Double)optimum.getValue()), (double)2.0E-12);
        Assert.assertTrue((optimizer.getEvaluations() > 180 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 220 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getIterations() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRosenbrock() {
        MultivariateFunction rosenbrock = new MultivariateFunction(){

            public double value(double[] x) {
                ++SimplexOptimizerMultiDirectionalTest.this.count;
                double a = x[1] - x[0] * x[0];
                double b = 1.0 - x[0];
                return 100.0 * a * a + b * b;
            }
        };
        this.count = 0;
        SimplexOptimizer optimizer = new SimplexOptimizer(-1.0, 0.001);
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), new ObjectiveFunction(rosenbrock), GoalType.MINIMIZE, new InitialGuess(new double[]{-1.2, 1.0}), new MultiDirectionalSimplex((double[][])new double[][]{{-1.2, 1.0}, {0.9, 1.2}, {3.5, -2.3}})});
        Assert.assertEquals((long)this.count, (long)optimizer.getEvaluations());
        Assert.assertTrue((optimizer.getEvaluations() > 50 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 100 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)optimum.getValue() > 0.01 ? 1 : 0) != 0);
    }

    @Test
    public void testPowell() {
        MultivariateFunction powell = new MultivariateFunction(){

            public double value(double[] x) {
                ++SimplexOptimizerMultiDirectionalTest.this.count;
                double a = x[0] + 10.0 * x[1];
                double b = x[2] - x[3];
                double c = x[1] - 2.0 * x[2];
                double d = x[0] - x[3];
                return a * a + 5.0 * b * b + c * c * c * c + 10.0 * d * d * d * d;
            }
        };
        this.count = 0;
        SimplexOptimizer optimizer = new SimplexOptimizer(-1.0, 0.001);
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(1000), new ObjectiveFunction(powell), GoalType.MINIMIZE, new InitialGuess(new double[]{3.0, -1.0, 0.0, 1.0}), new MultiDirectionalSimplex(4)});
        Assert.assertEquals((long)this.count, (long)optimizer.getEvaluations());
        Assert.assertTrue((optimizer.getEvaluations() > 800 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 900 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)optimum.getValue() > 0.01 ? 1 : 0) != 0);
    }

    @Test
    public void testMath283() {
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-14, 1.0E-14);
        Gaussian2D function = new Gaussian2D(0.0, 0.0, 1.0);
        PointValuePair estimate = optimizer.optimize(new OptimizationData[]{new MaxEval(1000), new ObjectiveFunction((MultivariateFunction)function), GoalType.MAXIMIZE, new InitialGuess(function.getMaximumPosition()), new MultiDirectionalSimplex(2)});
        double EPSILON = 1.0E-5;
        double expectedMaximum = function.getMaximum();
        double actualMaximum = (Double)estimate.getValue();
        Assert.assertEquals((double)expectedMaximum, (double)actualMaximum, (double)1.0E-5);
        double[] expectedPosition = function.getMaximumPosition();
        double[] actualPosition = estimate.getPoint();
        Assert.assertEquals((double)expectedPosition[0], (double)actualPosition[0], (double)1.0E-5);
        Assert.assertEquals((double)expectedPosition[1], (double)actualPosition[1], (double)1.0E-5);
    }

    private static class Gaussian2D
    implements MultivariateFunction {
        private final double[] maximumPosition;
        private final double std;

        public Gaussian2D(double xOpt, double yOpt, double std) {
            this.maximumPosition = new double[]{xOpt, yOpt};
            this.std = std;
        }

        public double getMaximum() {
            return this.value(this.maximumPosition);
        }

        public double[] getMaximumPosition() {
            return (double[])this.maximumPosition.clone();
        }

        public double value(double[] point) {
            double x = point[0];
            double y = point[1];
            double twoS2 = 2.0 * this.std * this.std;
            return 1.0 / (twoS2 * Math.PI) * FastMath.exp((double)(-(x * x + y * y) / twoS2));
        }
    }

    private static class FourExtrema
    implements MultivariateFunction {
        final double xM = -3.841947088256864;
        final double yM = -1.391745200270735;
        final double xP = 0.22866822373490592;
        final double yP = 1.391745200270735;
        final double valueXmYm = 0.2373295333134217;
        final double valueXmYp = -0.2373295333134217;
        final double valueXpYm = -0.7290400707055187;
        final double valueXpYp = 0.7290400707055187;

        private FourExtrema() {
        }

        public double value(double[] variables) {
            double x = variables[0];
            double y = variables[1];
            return x == 0.0 || y == 0.0 ? 0.0 : FastMath.atan((double)x) * FastMath.atan((double)(x + 2.0)) * FastMath.atan((double)y) * FastMath.atan((double)y) / (x * y);
        }
    }
}

